//----------------------------------------------------------------------------
//
// Project      : Call To Power 2
// File type    : C++ header file
// Description  : declarations for the AgreementMatrix class
//
//----------------------------------------------------------------------------
//
// Disclaimer
//
// THIS FILE IS NOT GENERATED OR SUPPORTED BY ACTIVISION.
//
// This material has been developed at apolyton.net by the Apolyton CtP2 
// Source Code Project. Contact the authors at ctp2source@apolyton.net.
//
//----------------------------------------------------------------------------
//
// Compiler flags
// 
// ACTIVISION_ORIGINAL		
// - When defined, generates the original Activision code.
// - When not defined, generates the modified Apolyton code.
//
// DOTNET
// - If defined then code that will work on the .NET platform will be used
//
// _MSC_VER		
// - When defined, uses Microsoft C++ specific features.
// - When not defined, generates standard C++.
//
// Note: For the blocks with _MSC_VER preprocessor directives, the following
//       is implied: the (_MSC_VER) preprocessor directive lines and the blocks 
//       between #else and #endif are modified Apolyton code. The blocks 
//       between #if and #else are the original Activision code.
//
//----------------------------------------------------------------------------
//
// Modifications from the original Activision code:
//
// - Marked DOTNET
//
//----------------------------------------------------------------------------
#pragma once
#ifndef __AGREEMENT_MATRIX_H__
#define __AGREEMENT_MATRIX_H__


#pragma warning(disable: 4786)


#include <vector>
#include "c3debugstl.h"

#include "DiplomatTypes.h"

class CivArchive; 

class AgreementMatrix
{
public:

	
	
	

	
	static ai::Agreement s_badAgreement;
	static AgreementMatrix s_agreements;
	
#if defined (_DEBUG)
	#if defined (DOTNET)
		typedef std::vector<ai::Agreement, std::allocator<ai::Agreement> > AgreementVector;
	#else
		typedef std::vector<ai::Agreement, dbgallocator<ai::Agreement> > AgreementVector;
	#endif	
#else
	
	typedef std::vector<ai::Agreement> AgreementVector;
#endif

	AgreementMatrix();

	
	void Resize(const PLAYER_INDEX & newMaxPlayers);

	
	void Load(CivArchive & archive);

	
	void Save(CivArchive & archive) const;

	
	const ai::Agreement & GetAgreement( const PLAYER_INDEX sender_player,
										const PLAYER_INDEX receiver_player,
										const PROPOSAL_TYPE type ) const;

	
	sint16 GetAgreementDuration( const PLAYER_INDEX sender_player,
								 const PLAYER_INDEX receiver_player,
								 const PROPOSAL_TYPE type ) const;
	
	
	void SetAgreement( const ai::Agreement & agreement );

	
	
	
	bool HasAgreement(const PLAYER_INDEX & sender_player,
					  const PLAYER_INDEX & receiver_player,
					  const PROPOSAL_TYPE type) const;

	
	
	bool HasAgreement(const PLAYER_INDEX & sender_player,
					  const PROPOSAL_TYPE type) const;

	
	void CancelAgreement(const PLAYER_INDEX & sender_player,
						 const PLAYER_INDEX & receiver_player, 
						 const PROPOSAL_TYPE type );

	
	void BreakAgreements(const PLAYER_INDEX & sender_player,  const PLAYER_INDEX & foreign_player);

	
	sint32 TurnsSinceLastWar(const PLAYER_INDEX & player,
							 const PLAYER_INDEX & foreigner) const;

	
	sint32 TurnsAtWar(const PLAYER_INDEX & player,
					  const PLAYER_INDEX & foreigner) const;

	
	void SetAgreementFast(sint32 index, const ai::Agreement &agreement);
 
	
	sint16 GetMaxPlayers() { return m_maxPlayers; }


	
	
	inline sint32 AgreementIndex(const PLAYER_INDEX & sender_player,
							     const PLAYER_INDEX & receiver_player) const
	{
		
		Assert(sender_player<m_maxPlayers);
		Assert(receiver_player<m_maxPlayers);
		return PROPOSAL_MAX*(receiver_player * m_maxPlayers +  
			sender_player);						  
	}

	
	
	
	inline sint32 HasAgreementIndexed(const sint32 index,
							   const PROPOSAL_TYPE type,
							   const sint32 curRound) const
	{
		
		const ai::Agreement & agreement = m_agreements[ index+type ];

		
		
		return (agreement.start != -1) && ((agreement.end == -1) || (agreement.end > curRound));
	}

	
	void ClearAgreementsInvolving(const PLAYER_INDEX playerId);

private:
	AgreementVector m_agreements;
	sint16 m_maxPlayers;
};

#endif __AGREEMENT_MATRIX_H__
