
/*
 * DO NOT EDIT THIS FILE!
 * It is generated automatically by ctpdb
 */
#include "c3.h"
#include "c3errors.h"
#include "ResourceRecord.h"
#include "DBLexer.h"
#include "DBTokens.h"
#include "CTPDatabase.h"
#include "StrDB.h"
#include "BitArray.h"

#include "SoundRecord.h"
#include "IconRecord.h"
#include "GovernmentRecord.h"

CTPDatabase<ResourceRecord> *g_theResourceDB = NULL;

void ResourceRecord::Init()
{
    m_flags0 = 0;
    m_Gold = 0;
    m_Food = 0;
    m_Production = 0;
    m_SpriteID = 0;
    m_Probability = 0.000000;
    m_Sound = 0x7fffffff;
    m_Icon = 0x7fffffff;
    m_GovernmentsModified = NULL;
    m_numGovernmentsModified = 0;
//GovMod Specific flag initialization
    m_hasGovernmentsModified=true;

}

ResourceRecord::~ResourceRecord()
{
	int index = 0;
	// free array GovernmentsModified 
 	if (m_numGovernmentsModified > 0) 
		delete [m_numGovernmentsModified] m_GovernmentsModified; 
	m_GovernmentsModified = NULL; 
	m_numGovernmentsModified = 0; 

}

void ResourceRecord::operator=(const ResourceRecord & rval)
{
	int index = 0;
	m_index = rval.m_index;
	m_Gold = rval.m_Gold; 

	m_Food = rval.m_Food; 

	m_Production = rval.m_Production; 

	m_SpriteID = rval.m_SpriteID; 

	m_Probability = rval.m_Probability; 

	m_Sound = rval.m_Sound; 

	m_Icon = rval.m_Icon; 

	// free array GovernmentsModified 
 	if (m_numGovernmentsModified > 0) 
	{
		delete [m_numGovernmentsModified] m_GovernmentsModified; 
		m_GovernmentsModified = NULL; 
		m_numGovernmentsModified = 0; 
	}
	if (rval.m_numGovernmentsModified > 0) 
	{
		m_GovernmentsModified = new sint32 [rval.m_numGovernmentsModified]; 
		memcpy(m_GovernmentsModified, rval.m_GovernmentsModified, sizeof(sint32)*rval.m_numGovernmentsModified); 

	} 
	m_numGovernmentsModified = rval.m_numGovernmentsModified;

	m_flags0 = rval.m_flags0; 
}

char *g_Resource_Tokens[] =
{
    "Gold",
    "Food",
    "Production",
    "SpriteID",
    "Probability",
    "Sound",
    "Icon",
    "GovernmentsModified",
    "GLHidden",
};

ResourceRecordAccessorInfo g_ResourceRecord_Accessors[] = 
{
    { ResourceRecord::GetGold, NULL, NULL, NULL, NULL },
    { ResourceRecord::GetFood, NULL, NULL, NULL, NULL },
    { ResourceRecord::GetProduction, NULL, NULL, NULL, NULL },
    { ResourceRecord::GetSpriteID, NULL, NULL, NULL, NULL },
    { NULL, NULL, ResourceRecord::GetProbability, NULL, NULL },
    {ResourceRecord::GetSoundIndex, NULL, NULL, NULL, NULL },
    {ResourceRecord::GetIconIndex, NULL, NULL, NULL, NULL },
    { NULL, NULL, NULL, NULL, NULL}, /* GovernmentsModified (array) */
    { NULL, ResourceRecord::GetGLHidden, NULL, NULL, NULL },
};

#define k_Token_Resource_Gold                    ((k_Token_Custom_Base) + 0)
#define k_Token_Resource_Food                    ((k_Token_Custom_Base) + 1)
#define k_Token_Resource_Production              ((k_Token_Custom_Base) + 2)
#define k_Token_Resource_SpriteID                ((k_Token_Custom_Base) + 3)
#define k_Token_Resource_Probability             ((k_Token_Custom_Base) + 4)
#define k_Token_Resource_Sound                   ((k_Token_Custom_Base) + 5)
#define k_Token_Resource_Icon                    ((k_Token_Custom_Base) + 6)
#define k_Token_Resource_GovernmentsModified     ((k_Token_Custom_Base) + 7)
#define k_Token_Resource_GLHidden                ((k_Token_Custom_Base) + 8)
#define k_Token_Resource_Max                     ((k_Token_Custom_Base) + 9)


static BitArray s_ParsedTokens(9);
void ResourceRecord::CheckRequiredFields(DBLexer *lex)
{
    // Ick.
    if(!s_ParsedTokens.Bit(k_Token_Resource_Gold - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field Gold missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Resource_SpriteID - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field SpriteID missing"));
    }
    if(!s_ParsedTokens.Bit(k_Token_Resource_Probability - k_Token_Custom_Base)) {
        DBERROR(("Warning: required field Probability missing"));
    }
}
    
sint32 ResourceRecord::Parse(DBLexer *lex)
{
    bool done = false;
    sint32 result = 0;
    sint32 tok;
    DBPARSE_ERROR err = DBPARSE_OK;
    s_ParsedTokens.Clear();
    lex->SetTokens(g_Resource_Tokens, k_Token_Resource_Max);
    tok = lex->GetToken();
    if(tok != k_Token_Name) {
        DBERROR(("Record does not start with name"));
        return 0;
    }
    if(!g_theStringDB->GetStringID(lex->GetTokenText(), m_name)) {
        g_theStringDB->InsertStr(lex->GetTokenText(), lex->GetTokenText());
        if(!g_theStringDB->GetStringID(lex->GetTokenText(), m_name))
            SetTextName(lex->GetTokenText());
    }

    tok = lex->GetToken();
    // Start of GovMod Specific lexical analysis
    if(tok == k_Token_Modified) {
         do {
				  tok = lex->PeekAhead();
				  if(tok != k_Token_Name) {
					  DBERROR(("Modified record invalid- must be Government identifier or description.  No quotes, No spaces."));
					  return 0;
				  }
                g_theGovernmentDB->ParseRecordInArray(lex, (sint32 **)&m_GovernmentsModified, &m_numGovernmentsModified, err);
				  tok = lex->GetToken();
         } while (tok == k_Token_ModifiedDelimiter);
	  }
    // End of GovMod Specific lexical analysis
    if(tok != k_Token_OpenBrace) {
        DBERROR(("Missing open brace"));
        return 0;
    }

    while(!done) {
        tok = lex->GetToken();
        if(tok >= k_Token_Custom_Base && tok < k_Token_Resource_Max) { 
            s_ParsedTokens.SetBit(tok - k_Token_Custom_Base);
        }
        switch(tok) {
            case k_Token_Resource_Gold:
                if(!lex->GetIntAssignment(m_Gold)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Resource_Food:
                if(!lex->GetIntAssignment(m_Food)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Resource_Production:
                if(!lex->GetIntAssignment(m_Production)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Resource_SpriteID:
                if(!lex->GetIntAssignment(m_SpriteID)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Resource_Probability:
                if(!lex->GetFloatAssignment(m_Probability)) {
                    DBERROR(("Expected number"));
                    done = true; break;
                }
                break;
            case k_Token_Resource_Sound:
                if(!g_theSoundDB->GetRecordFromLexer(lex, m_Sound, err)) {
                    done = true; break;
                }
                break;
            case k_Token_Resource_Icon:
                if(!g_theIconDB->GetRecordFromLexer(lex, m_Icon, err)) {
                    done = true; break;
                }
                break;
            case k_Token_Resource_GovernmentsModified:
                if(!g_theGovernmentDB->ParseRecordInArray(lex, (sint32 **)&m_GovernmentsModified, &m_numGovernmentsModified, err)) 
                {
                    done = true; break;
                }
                break;
            case k_Token_Resource_GLHidden:
                m_flags0 |= k_Resource_GLHidden_Bit;
                break;
            case k_Token_CloseBrace:
                done = true;
                result = 1;
                break;
            default:
                DBERROR(("Unknown token"));
                done = true;
                break;
        }
    }
    CheckRequiredFields(lex);
    lex->RestoreTokens();
    return result;
}

void ResourceRecord::ResolveDBReferences()
{
    if(m_Sound & 0x80000000) {
        sint32 id = m_Sound & 0x7fffffff;
        if(!g_theSoundDB->GetNamedItem(id, m_Sound)) {
            c3errors_ErrorDialog("DB", "%s not found in Sound database", g_theStringDB->GetNameStr(id));
        }
    } else if(m_Sound == 0x7fffffff) {
        m_Sound = -1;
    }
    if(m_Icon & 0x80000000) {
        sint32 id = m_Icon & 0x7fffffff;
        if(!g_theIconDB->GetNamedItem(id, m_Icon)) {
            c3errors_ErrorDialog("DB", "%s not found in Icon database", g_theStringDB->GetNameStr(id));
        }
    } else if(m_Icon == 0x7fffffff) {
        m_Icon = -1;
    }
    {
        sint32 i;
        for(i = 0; i < m_numGovernmentsModified; i++) {
            if(m_GovernmentsModified[i] & 0x80000000) {
                sint32 id = m_GovernmentsModified[i] & 0x7fffffff;
                if(!g_theGovernmentDB->GetNamedItem(id, m_GovernmentsModified[i])) {
                    c3errors_ErrorDialog("DB", "%s not found in Government database", g_theStringDB->GetNameStr(id));
                }
            } else if(m_GovernmentsModified[i] == 0x7fffffff){
                m_GovernmentsModified[i] = -1;
            }
        }
    }
}
/*
 * Member class Parsers
 * (DO NOT EDIT!  Automatically generated file)
 */
/*
 * Data Parsers
 * (DO NOT EDIT!  Automatically generated file)
 */
void ResourceRecord::Merge(const ResourceRecord & rval){
	int index = 0, obj_index = 0;
	// resize m_GovernmentsModified if necessary
	if (rval.m_numGovernmentsModified > m_numGovernmentsModified)
 	{ 
		delete m_GovernmentsModified;
 		m_GovernmentsModified = NULL;
 		if (rval.m_numGovernmentsModified > 0)
 			m_GovernmentsModified = new sint32 [rval.m_numGovernmentsModified]; 
		m_numGovernmentsModified = rval.m_numGovernmentsModified;
 	} 

	// copy values of rval.m_GovernmentsModified to m_GovernmentsModified
	for (index = 0; index < m_numGovernmentsModified; index++) 
	{ 
 		if (index < rval.m_numGovernmentsModified)
 			m_GovernmentsModified[index] = rval.m_GovernmentsModified[index];
	} 
 } 

/*
 * Data accessors
 * (DO NOT EDIT!  Automatically generated file)
 */
const SoundRecord *ResourceRecord::GetSound() const
{
    return g_theSoundDB->Get(m_Sound);
}

const IconRecord *ResourceRecord::GetIcon() const
{
    return g_theIconDB->Get(m_Icon);
}

sint32 ResourceRecord::GetGovernmentsModifiedIndex(sint32 index) const
{
    Assert(index >= 0);
    Assert(index < m_numGovernmentsModified);
    if((index < 0) || (index >= m_numGovernmentsModified)) {
        return 0;
    }
    return m_GovernmentsModified[index];
}

const GovernmentRecord *ResourceRecord::GetGovernmentsModified(sint32 index) const
{
    Assert(index >= 0);
    Assert(index < m_numGovernmentsModified);
    if((index < 0) || (index >= m_numGovernmentsModified)) {
        return 0;
    }
    return g_theGovernmentDB->Get(m_GovernmentsModified[index]);
}

