
/*
 * DO NOT EDIT THIS FILE!
 * It is generated automatically by ctpdb
 */
#include "c3.h"
#include "c3errors.h"
#include "PopRecord.h"
#include "DBLexer.h"
#include "DBTokens.h"
#include "CTPDatabase.h"
#include "StrDB.h"
#include "BitArray.h"

#include "AdvanceRecord.h"
#include "GovernmentRecord.h"

CTPDatabase<PopRecord> *g_thePopDB = NULL;

void PopRecord::Init()
{
    m_EnableAdvance = 0x7fffffff;
    m_GovernmentsModified = NULL;
    m_numGovernmentsModified = 0;
    m_Science = 0;
    m_Happiness = 0;
    m_Food = 0;
    m_Production = 0;
    m_Commerce = 0;
//GovMod Specific flag initialization
    m_hasGovernmentsModified=true;

}

PopRecord::~PopRecord()
{
	int index = 0;
	// free array GovernmentsModified 
 	if (m_numGovernmentsModified > 0) 
		delete [m_numGovernmentsModified] m_GovernmentsModified; 
	m_GovernmentsModified = NULL; 
	m_numGovernmentsModified = 0; 

}

void PopRecord::operator=(const PopRecord & rval)
{
	int index = 0;
	m_index = rval.m_index;
	m_EnableAdvance = rval.m_EnableAdvance; 

	// free array GovernmentsModified 
 	if (m_numGovernmentsModified > 0) 
	{
		delete [m_numGovernmentsModified] m_GovernmentsModified; 
		m_GovernmentsModified = NULL; 
		m_numGovernmentsModified = 0; 
	}
	if (rval.m_numGovernmentsModified > 0) 
	{
		m_GovernmentsModified = new sint32 [rval.m_numGovernmentsModified]; 
		memcpy(m_GovernmentsModified, rval.m_GovernmentsModified, sizeof(sint32)*rval.m_numGovernmentsModified); 

	} 
	m_numGovernmentsModified = rval.m_numGovernmentsModified;

	m_Science = rval.m_Science; 

	m_Happiness = rval.m_Happiness; 

	m_Food = rval.m_Food; 

	m_Production = rval.m_Production; 

	m_Commerce = rval.m_Commerce; 

}

char *g_Pop_Tokens[] =
{
    "EnableAdvance",
    "GovernmentsModified",
    "Science",
    "Happiness",
    "Food",
    "Production",
    "Commerce",
};

PopRecordAccessorInfo g_PopRecord_Accessors[] = 
{
    {PopRecord::GetEnableAdvanceIndex, NULL, NULL, NULL, NULL },
    { NULL, NULL, NULL, NULL, NULL}, /* GovernmentsModified (array) */
    { PopRecord::GetScience, NULL, NULL, NULL, NULL },
    { PopRecord::GetHappiness, NULL, NULL, NULL, NULL },
    { PopRecord::GetFood, NULL, NULL, NULL, NULL },
    { PopRecord::GetProduction, NULL, NULL, NULL, NULL },
    { PopRecord::GetCommerce, NULL, NULL, NULL, NULL },
};

#define k_Token_Pop_EnableAdvance                ((k_Token_Custom_Base) + 0)
#define k_Token_Pop_GovernmentsModified          ((k_Token_Custom_Base) + 1)
#define k_Token_Pop_Science                      ((k_Token_Custom_Base) + 2)
#define k_Token_Pop_Happiness                    ((k_Token_Custom_Base) + 3)
#define k_Token_Pop_Food                         ((k_Token_Custom_Base) + 4)
#define k_Token_Pop_Production                   ((k_Token_Custom_Base) + 5)
#define k_Token_Pop_Commerce                     ((k_Token_Custom_Base) + 6)
#define k_Token_Pop_Max                          ((k_Token_Custom_Base) + 7)


static BitArray s_ParsedTokens(7);
void PopRecord::CheckRequiredFields(DBLexer *lex)
{
    // Ick.
}
    
sint32 PopRecord::Parse(DBLexer *lex)
{
    bool done = false;
    sint32 result = 0;
    sint32 tok;
    DBPARSE_ERROR err = DBPARSE_OK;
    s_ParsedTokens.Clear();
    lex->SetTokens(g_Pop_Tokens, k_Token_Pop_Max);
    tok = lex->GetToken();
    if(tok != k_Token_Name) {
        DBERROR(("Record does not start with name"));
        return 0;
    }
    if(!g_theStringDB->GetStringID(lex->GetTokenText(), m_name)) {
        g_theStringDB->InsertStr(lex->GetTokenText(), lex->GetTokenText());
        if(!g_theStringDB->GetStringID(lex->GetTokenText(), m_name))
            SetTextName(lex->GetTokenText());
    }

    tok = lex->GetToken();
    // Start of GovMod Specific lexical analysis
    if(tok == k_Token_Modified) {
         do {
				  tok = lex->PeekAhead();
				  if(tok != k_Token_Name) {
					  DBERROR(("Modified record invalid- must be Government identifier or description.  No quotes, No spaces."));
					  return 0;
				  }
                g_theGovernmentDB->ParseRecordInArray(lex, (sint32 **)&m_GovernmentsModified, &m_numGovernmentsModified, err);
				  tok = lex->GetToken();
         } while (tok == k_Token_ModifiedDelimiter);
	  }
    // End of GovMod Specific lexical analysis
    if(tok != k_Token_OpenBrace) {
        DBERROR(("Missing open brace"));
        return 0;
    }

    while(!done) {
        tok = lex->GetToken();
        if(tok >= k_Token_Custom_Base && tok < k_Token_Pop_Max) { 
            s_ParsedTokens.SetBit(tok - k_Token_Custom_Base);
        }
        switch(tok) {
            case k_Token_Pop_EnableAdvance:
                if(!g_theAdvanceDB->GetRecordFromLexer(lex, m_EnableAdvance, err)) {
                    done = true; break;
                }
                break;
            case k_Token_Pop_GovernmentsModified:
                if(!g_theGovernmentDB->ParseRecordInArray(lex, (sint32 **)&m_GovernmentsModified, &m_numGovernmentsModified, err)) 
                {
                    done = true; break;
                }
                break;
            case k_Token_Pop_Science:
                if(!lex->GetIntAssignment(m_Science)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Pop_Happiness:
                if(!lex->GetIntAssignment(m_Happiness)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Pop_Food:
                if(!lex->GetIntAssignment(m_Food)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Pop_Production:
                if(!lex->GetIntAssignment(m_Production)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_Pop_Commerce:
                if(!lex->GetIntAssignment(m_Commerce)) {
                    DBERROR(("Expected integer"));
                    done = true; break;
                }
                break;
            case k_Token_CloseBrace:
                done = true;
                result = 1;
                break;
            default:
                DBERROR(("Unknown token"));
                done = true;
                break;
        }
    }
    CheckRequiredFields(lex);
    lex->RestoreTokens();
    return result;
}

void PopRecord::ResolveDBReferences()
{
    if(m_EnableAdvance & 0x80000000) {
        sint32 id = m_EnableAdvance & 0x7fffffff;
        if(!g_theAdvanceDB->GetNamedItem(id, m_EnableAdvance)) {
            c3errors_ErrorDialog("DB", "%s not found in Advance database", g_theStringDB->GetNameStr(id));
        }
    } else if(m_EnableAdvance == 0x7fffffff) {
        m_EnableAdvance = -1;
    }
    {
        sint32 i;
        for(i = 0; i < m_numGovernmentsModified; i++) {
            if(m_GovernmentsModified[i] & 0x80000000) {
                sint32 id = m_GovernmentsModified[i] & 0x7fffffff;
                if(!g_theGovernmentDB->GetNamedItem(id, m_GovernmentsModified[i])) {
                    c3errors_ErrorDialog("DB", "%s not found in Government database", g_theStringDB->GetNameStr(id));
                }
            } else if(m_GovernmentsModified[i] == 0x7fffffff){
                m_GovernmentsModified[i] = -1;
            }
        }
    }
}
/*
 * Member class Parsers
 * (DO NOT EDIT!  Automatically generated file)
 */
/*
 * Data Parsers
 * (DO NOT EDIT!  Automatically generated file)
 */
void PopRecord::Merge(const PopRecord & rval){
	int index = 0, obj_index = 0;
	// resize m_GovernmentsModified if necessary
	if (rval.m_numGovernmentsModified > m_numGovernmentsModified)
 	{ 
		delete m_GovernmentsModified;
 		m_GovernmentsModified = NULL;
 		if (rval.m_numGovernmentsModified > 0)
 			m_GovernmentsModified = new sint32 [rval.m_numGovernmentsModified]; 
		m_numGovernmentsModified = rval.m_numGovernmentsModified;
 	} 

	// copy values of rval.m_GovernmentsModified to m_GovernmentsModified
	for (index = 0; index < m_numGovernmentsModified; index++) 
	{ 
 		if (index < rval.m_numGovernmentsModified)
 			m_GovernmentsModified[index] = rval.m_GovernmentsModified[index];
	} 
 } 

/*
 * Data accessors
 * (DO NOT EDIT!  Automatically generated file)
 */
const AdvanceRecord *PopRecord::GetEnableAdvance() const
{
    return g_theAdvanceDB->Get(m_EnableAdvance);
}

sint32 PopRecord::GetGovernmentsModifiedIndex(sint32 index) const
{
    Assert(index >= 0);
    Assert(index < m_numGovernmentsModified);
    if((index < 0) || (index >= m_numGovernmentsModified)) {
        return 0;
    }
    return m_GovernmentsModified[index];
}

const GovernmentRecord *PopRecord::GetGovernmentsModified(sint32 index) const
{
    Assert(index >= 0);
    Assert(index < m_numGovernmentsModified);
    if((index < 0) || (index >= m_numGovernmentsModified)) {
        return 0;
    }
    return g_theGovernmentDB->Get(m_GovernmentsModified[index]);
}

