/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.BufferedReader;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.Arrays;
import jmkirschberg.games.civ2.City;
import jmkirschberg.games.civ2.CityToFile;
import jmkirschberg.games.civ2.Civ2Data;
import jmkirschberg.games.civ2.StrConstants;
import jmkirschberg.games.civ2.Technology;
import jmkirschberg.games.civ2.Unit;
import jmkirschberg.games.civ2.UnitToFile;
import jmkirschberg.games.civ2.Util;

public class Offer
implements Externalizable {
    private static final String IDENTIFIER_STRING = "CIV2-PBEM-DIPLOMACY";
    private int goldDemmanderTributer = 0;
    private int goldDemmander = 0;
    private int goldTributerDemmander = 0;
    private int goldTributer = 0;
    private boolean peace = false;
    private boolean alliance = false;
    private boolean ceaseFire = false;
    private boolean terrainMapDemmanderTributer = false;
    private boolean terrainMapTributerDemmander = false;
    private boolean unitsMapDemmanderTributer = false;
    private boolean unitsMapTributerDemmander = false;
    private boolean citiesMapDemmanderTributer = false;
    private boolean citiesMapTributerDemmander = false;
    private boolean allMapDemmanderTributer = false;
    private boolean allMapTributerDemmander = false;
    private boolean[] foreignsMapDemmanderTributer = new boolean[7];
    private boolean[] foreignsMapTributerDemmander = new boolean[7];
    private int turnGame;
    private boolean demmanderRevolution = false;
    private boolean tributerRevolution = false;
    private Technology[] techDemmanderTributer = null;
    private Technology[] techTributerDemmander = null;
    private Unit[] unitsDemmanderTributer = null;
    private Unit[] unitsTributerDemmander = null;
    private City[] citiesDemmanderTributer = null;
    private City[] citiesTributerDemmander = null;
    private int civDemmander = 0;
    private int civTributer = 0;
    private int[] signature;
    private int error = 0;
    private Civ2Data data = null;
    public static final int NO_ERROR = 0;
    public static final int BAD_SIGNATURE = 1;
    public static final int BAD_DEMMANDER = 2;
    public static final int BAD_TRIBUTER = 3;
    public static final int SAME_DEMMANDER_TRIBUTER = 4;
    public static final int TOO_MUCH_OFFERED_GOLD = 5;
    public static final int TOO_LESS_OFFERED_GOLD = 6;
    public static final int TOO_MUCH_DEMMANDED_GOLD = 7;
    public static final int TOO_LESS_DEMMANDED_GOLD = 8;
    public static final int NON_TECH_DEMMANDED = 9;
    public static final int NON_TECH_OFFERED = 10;
    public static final int ALREADY_TECH_DEMMANDED = 11;
    public static final int ALREADY_TECH_OFFERED = 12;
    public static final int UNIT_OFFERED_NON_EXISTS = 13;
    public static final int UNIT_DEMMANDED_NON_EXISTS = 14;
    public static final int CITY_OFFERED_NON_EXISTS = 15;
    public static final int CITY_DEMMANDED_NON_EXISTS = 16;
    public static final int OBSOLETE_OFFER = 17;

    public Offer() {
        int i = 0;
        while (i < 7) {
            this.foreignsMapDemmanderTributer[i] = false;
            this.foreignsMapTributerDemmander[i] = false;
            ++i;
        }
    }

    public void setData(Civ2Data data) {
        this.data = data;
    }

    public int getCivDemmander() {
        return this.civDemmander;
    }

    public int getCivTributer() {
        return this.civTributer;
    }

    public int getGoldDemmanderTributer() {
        return this.goldDemmanderTributer;
    }

    public int getGoldTributerDemmander() {
        return this.goldTributerDemmander;
    }

    public Technology[] getTechDemmanderTributer() {
        return this.techDemmanderTributer;
    }

    public Technology[] getTechTributerDemmander() {
        return this.techTributerDemmander;
    }

    public int getTurnGame() {
        return this.turnGame;
    }

    public boolean getPeace() {
        return this.peace;
    }

    public boolean getAlliance() {
        return this.alliance;
    }

    public boolean getCeaseFire() {
        return this.ceaseFire;
    }

    public int getGoldDemmander() {
        return this.goldDemmander;
    }

    public int getGoldTributer() {
        return this.goldTributer;
    }

    public void setGoldDemmanderTributer(int gold) {
        if (gold < 0) {
            throw new AssertionError();
        }
        this.goldDemmanderTributer = gold;
    }

    public void setGoldTributerDemmander(int gold) {
        if (gold < 0) {
            throw new AssertionError();
        }
        this.goldTributerDemmander = gold;
    }

    public void setGoldDemmander(int gold) {
        if (gold < 0) {
            throw new AssertionError();
        }
        this.goldDemmander = gold;
    }

    public void setGoldTributer(int gold) {
        if (gold < 0) {
            throw new AssertionError();
        }
        this.goldTributer = gold;
    }

    public void setTurnGame(int turn) {
        if (turn < 0) {
            throw new AssertionError();
        }
        this.turnGame = turn;
    }

    public void setTechDemmanderTributer(Technology[] tech) {
        this.techDemmanderTributer = tech;
    }

    public void setTechTributerDemmander(Technology[] tech) {
        this.techTributerDemmander = tech;
    }

    public void setCivDemmander(int civ) {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        this.civDemmander = civ;
    }

    public void setCivTributer(int civ) {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        this.civTributer = civ;
    }

    public void setPeace() {
        this.alliance = false;
        this.ceaseFire = false;
        this.peace = true;
    }

    public void setAlliance() {
        this.alliance = true;
        this.ceaseFire = false;
        this.peace = false;
    }

    public void setCeaseFire() {
        this.alliance = false;
        this.ceaseFire = true;
        this.peace = false;
    }

    public void setSignature(int[] sig) {
        this.signature = sig;
    }

    public int[] getSignature() {
        return this.signature;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        UnitToFile tempUnit;
        CityToFile tempCity;
        int i;
        this.error = 0;
        this.signature = (int[])in.readObject();
        this.civDemmander = Util.readUnsignedShort(in);
        this.civTributer = Util.readUnsignedShort(in);
        this.turnGame = Util.readUnsignedShort(in);
        this.goldDemmander = Util.readUnsignedShort(in);
        this.goldTributer = Util.readUnsignedShort(in);
        this.goldDemmanderTributer = Util.readUnsignedShort(in);
        this.goldTributerDemmander = Util.readUnsignedShort(in);
        int temp = in.read();
        if (temp == 0) {
            this.techDemmanderTributer = null;
        } else {
            this.techDemmanderTributer = new Technology[temp];
            i = 0;
            while (i < this.techDemmanderTributer.length) {
                this.techDemmanderTributer[i] = (Technology)in.readObject();
                ++i;
            }
        }
        temp = in.read();
        if (temp == 0) {
            this.techTributerDemmander = null;
        } else {
            this.techTributerDemmander = new Technology[temp];
            i = 0;
            while (i < this.techTributerDemmander.length) {
                this.techTributerDemmander[i] = (Technology)in.readObject();
                ++i;
            }
        }
        temp = in.read();
        if (temp == 0) {
            this.citiesDemmanderTributer = null;
        } else {
            this.citiesDemmanderTributer = new City[temp];
            i = 0;
            while (i < this.citiesDemmanderTributer.length) {
                tempCity = new CityToFile();
                tempCity.readExternal(in);
                this.citiesDemmanderTributer[i] = tempCity.getCity(this.data.getCities());
                ++i;
            }
        }
        temp = in.read();
        if (temp == 0) {
            this.citiesTributerDemmander = null;
        } else {
            this.citiesTributerDemmander = new City[temp];
            i = 0;
            while (i < this.citiesTributerDemmander.length) {
                tempCity = new CityToFile();
                tempCity.readExternal(in);
                this.citiesTributerDemmander[i] = tempCity.getCity(this.data.getCities());
                ++i;
            }
        }
        temp = in.read();
        if (temp == 0) {
            this.unitsDemmanderTributer = null;
        } else {
            this.unitsDemmanderTributer = new Unit[temp];
            i = 0;
            while (i < this.unitsDemmanderTributer.length) {
                tempUnit = new UnitToFile();
                tempUnit.readExternal(in);
                this.unitsDemmanderTributer[i] = tempUnit.getUnit(this.data.getUnits());
                ++i;
            }
        }
        temp = in.read();
        if (temp == 0) {
            this.unitsTributerDemmander = null;
        } else {
            this.unitsTributerDemmander = new Unit[temp];
            i = 0;
            while (i < this.unitsTributerDemmander.length) {
                tempUnit = new UnitToFile();
                tempUnit.readExternal(in);
                this.unitsTributerDemmander[i] = tempUnit.getUnit(this.data.getUnits());
                ++i;
            }
        }
        this.terrainMapDemmanderTributer = (Boolean)in.readObject();
        this.terrainMapTributerDemmander = (Boolean)in.readObject();
        this.unitsMapDemmanderTributer = (Boolean)in.readObject();
        this.unitsMapTributerDemmander = (Boolean)in.readObject();
        this.citiesMapDemmanderTributer = (Boolean)in.readObject();
        this.citiesMapTributerDemmander = (Boolean)in.readObject();
        this.allMapDemmanderTributer = (Boolean)in.readObject();
        this.allMapTributerDemmander = (Boolean)in.readObject();
        this.foreignsMapDemmanderTributer = (boolean[])in.readObject();
        this.foreignsMapTributerDemmander = (boolean[])in.readObject();
        this.ceaseFire = (Boolean)in.readObject();
        this.peace = (Boolean)in.readObject();
        this.alliance = (Boolean)in.readObject();
        this.demmanderRevolution = (Boolean)in.readObject();
        this.tributerRevolution = (Boolean)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeObject(this.signature);
        Util.writeUnsignedShort(out, this.civDemmander);
        Util.writeUnsignedShort(out, this.civTributer);
        Util.writeUnsignedShort(out, this.turnGame);
        Util.writeUnsignedShort(out, this.goldDemmander);
        Util.writeUnsignedShort(out, this.goldTributer);
        Util.writeUnsignedShort(out, this.goldDemmanderTributer);
        Util.writeUnsignedShort(out, this.goldTributerDemmander);
        if (this.techDemmanderTributer != null) {
            out.write(this.techDemmanderTributer.length);
            i = 0;
            while (i < this.techDemmanderTributer.length) {
                out.writeObject(this.techDemmanderTributer[i]);
                ++i;
            }
        } else {
            out.write(0);
        }
        if (this.techTributerDemmander != null) {
            out.write(this.techTributerDemmander.length);
            i = 0;
            while (i < this.techTributerDemmander.length) {
                out.writeObject(this.techTributerDemmander[i]);
                ++i;
            }
        } else {
            out.write(0);
        }
        if (this.citiesDemmanderTributer != null) {
            out.write(this.citiesDemmanderTributer.length);
            i = 0;
            while (i < this.citiesDemmanderTributer.length) {
                new CityToFile(this.citiesDemmanderTributer[i]).writeExternal(out);
                ++i;
            }
        } else {
            out.write(0);
        }
        if (this.citiesTributerDemmander != null) {
            out.write(this.citiesTributerDemmander.length);
            i = 0;
            while (i < this.citiesTributerDemmander.length) {
                new CityToFile(this.citiesTributerDemmander[i]).writeExternal(out);
                ++i;
            }
        } else {
            out.write(0);
        }
        if (this.unitsDemmanderTributer != null) {
            out.write(this.unitsDemmanderTributer.length);
            i = 0;
            while (i < this.unitsDemmanderTributer.length) {
                new UnitToFile(this.unitsDemmanderTributer[i]).writeExternal(out);
                ++i;
            }
        } else {
            out.write(0);
        }
        if (this.unitsTributerDemmander != null) {
            out.write(this.unitsTributerDemmander.length);
            i = 0;
            while (i < this.unitsTributerDemmander.length) {
                new UnitToFile(this.unitsTributerDemmander[i]).writeExternal(out);
                ++i;
            }
        } else {
            out.write(0);
        }
        out.writeObject(new Boolean(this.terrainMapDemmanderTributer));
        out.writeObject(new Boolean(this.terrainMapTributerDemmander));
        out.writeObject(new Boolean(this.unitsMapDemmanderTributer));
        out.writeObject(new Boolean(this.unitsMapTributerDemmander));
        out.writeObject(new Boolean(this.citiesMapDemmanderTributer));
        out.writeObject(new Boolean(this.citiesMapTributerDemmander));
        out.writeObject(new Boolean(this.allMapDemmanderTributer));
        out.writeObject(new Boolean(this.allMapTributerDemmander));
        out.writeObject(this.foreignsMapDemmanderTributer);
        out.writeObject(this.foreignsMapTributerDemmander);
        out.writeObject(new Boolean(this.ceaseFire));
        out.writeObject(new Boolean(this.peace));
        out.writeObject(new Boolean(this.alliance));
        out.writeObject(new Boolean(this.demmanderRevolution));
        out.writeObject(new Boolean(this.tributerRevolution));
    }

    public boolean getTerrainMapDemmanderTributer() {
        return this.terrainMapDemmanderTributer;
    }

    public void setTerrainMapDemmanderTributer(boolean b) {
        this.terrainMapDemmanderTributer = b;
    }

    public boolean getTerrainMapTributerDemmander() {
        return this.terrainMapTributerDemmander;
    }

    public void setTerrainMapTributerDemmander(boolean b) {
        this.terrainMapTributerDemmander = b;
    }

    public boolean getUnitsMapDemmanderTributer() {
        return this.unitsMapDemmanderTributer;
    }

    public void setUnitsMapDemmanderTributer(boolean b) {
        this.unitsMapDemmanderTributer = b;
    }

    public boolean getUnitsMapTributerDemmander() {
        return this.unitsMapTributerDemmander;
    }

    public void setUnitsMapTributerDemmander(boolean b) {
        this.unitsMapTributerDemmander = b;
    }

    public boolean getCitiesMapDemmanderTributer() {
        return this.citiesMapDemmanderTributer;
    }

    public void setCitiesMapDemmanderTributer(boolean b) {
        this.citiesMapDemmanderTributer = b;
    }

    public boolean getCitiesMapTributerDemmander() {
        return this.citiesMapTributerDemmander;
    }

    public void setCitiesMapTributerDemmander(boolean b) {
        this.citiesMapTributerDemmander = b;
    }

    public boolean getAllMapDemmanderTributer() {
        return this.allMapDemmanderTributer;
    }

    public void setAllMapDemmanderTributer(boolean b) {
        this.allMapDemmanderTributer = b;
    }

    public boolean getAllMapTributerDemmander() {
        return this.allMapTributerDemmander;
    }

    public void setAllMapTributerDemmander(boolean b) {
        this.allMapTributerDemmander = b;
    }

    public void setCitiesDemmanderTributer(City[] cities) {
        this.citiesDemmanderTributer = cities;
    }

    public void setCitiesTributerDemmander(City[] cities) {
        this.citiesTributerDemmander = cities;
    }

    public City[] getCitiesDemmanderTributer() {
        return this.citiesDemmanderTributer;
    }

    public City[] getCitiesTributerDemmander() {
        return this.citiesTributerDemmander;
    }

    public Unit[] getUnitsTributerDemmander() {
        return this.unitsTributerDemmander;
    }

    public Unit[] getUnitsDemmanderTributer() {
        return this.unitsDemmanderTributer;
    }

    public void getUnitsTributerDemmander(Unit[] u) {
        this.unitsTributerDemmander = u;
    }

    public void getUnitsDemmanderTributer(Unit[] u) {
        this.unitsDemmanderTributer = u;
    }

    public void setForeignsMapDemmanderTributer(boolean[] b) {
        this.foreignsMapDemmanderTributer = b;
    }

    public void setForeignsMapTributerDemmander(boolean[] b) {
        this.foreignsMapTributerDemmander = b;
    }

    public boolean[] getForeignsMapDemmanderTributer() {
        return this.foreignsMapDemmanderTributer;
    }

    public boolean[] getForeignsMapTributerDemmander() {
        return this.foreignsMapTributerDemmander;
    }

    public void setDemmanderRevolution() {
        this.demmanderRevolution = true;
    }

    public void setTributerRevolution() {
        this.tributerRevolution = true;
    }

    public boolean getDemmanderRevolution() {
        return this.demmanderRevolution;
    }

    public boolean getTributerRevolution() {
        return this.tributerRevolution;
    }

    public static void main(String[] args) {
        System.exit(0);
        System.out.println("Standard test for Civ2 PBEM Diplomacy-Offer");
        System.out.println("Made by Javier Mu\u00f1oz Kirschberg - M\u00e1laga 2002");
        System.out.println("Please enter the full path of the file to open:");
        Offer o = new Offer();
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        try {
            int i;
            String name = input.readLine();
            File file = new File(name);
            ObjectInputStream p = new ObjectInputStream(new FileInputStream(file));
            o.readExternal(p);
            System.out.println("Civ Demmander " + o.getCivDemmander());
            System.out.println("Civ Tributer " + o.getCivTributer());
            System.out.println("Gold Civ Demmander " + o.getGoldDemmander());
            System.out.println("Gold Civ Tributer " + o.getGoldTributer());
            System.out.println("Gold Civ Demmander->Tributer " + o.getGoldDemmanderTributer());
            System.out.println("Gold Civ Tributer->Demmander " + o.getGoldTributerDemmander());
            if (o.getTechDemmanderTributer() != null) {
                i = 0;
                while (i < o.getTechDemmanderTributer().length) {
                    System.out.println("Tech Demmander->Tributer " + o.getTechDemmanderTributer()[i]);
                    ++i;
                }
            }
            if (o.getTechTributerDemmander() != null) {
                i = 0;
                while (i < o.getTechTributerDemmander().length) {
                    System.out.println("Tech Tributer->Demmander " + o.getTechTributerDemmander()[i]);
                    ++i;
                }
            }
            if (o.getPeace()) {
                System.out.println("Peace Offer ");
            } else if (o.getAlliance()) {
                System.out.println("Alliance Offer ");
            } else if (o.getCeaseFire()) {
                System.out.println("Cease Fire ");
            }
        }
        catch (NullPointerException e) {
            System.out.println("Incorrect FileName");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class Not Found Exception");
        }
        catch (IOException e) {
            System.out.println("Error while reading file name");
        }
    }

    public boolean checkOffer() {
        int i;
        boolean check = true;
        if (this.error != 0) {
            check = false;
        } else if (!Arrays.equals(this.data.getSignature(), this.signature)) {
            this.error = 1;
            check = false;
        } else if (this.civDemmander > 6 || this.civDemmander < 0) {
            this.error = 2;
            check = false;
        } else if (this.civTributer > 6 || this.civTributer < 0) {
            this.error = 3;
            check = false;
        } else if (this.civDemmander == this.civTributer) {
            this.error = 4;
            check = false;
        } else if (this.goldDemmanderTributer > this.data.getTribe(this.civDemmander).getGold()) {
            this.error = 5;
            check = false;
        } else if (this.goldDemmanderTributer < 0) {
            this.error = 6;
            check = false;
        } else if (this.goldTributerDemmander > this.data.getTribe(this.civTributer).getGold()) {
            this.error = 7;
            check = false;
        } else if (this.goldTributerDemmander < 0) {
            this.error = 8;
            check = false;
        } else if (this.techDemmanderTributer != null && this.techDemmanderTributer.length > 0) {
            i = 0;
            while (i < this.techDemmanderTributer.length && check) {
                if (!this.data.getTribe(this.civDemmander).hasTech(this.techDemmanderTributer[i])) {
                    this.error = 10;
                    check = false;
                } else if (this.data.getTribe(this.civTributer).hasTech(this.techDemmanderTributer[i])) {
                    this.error = 12;
                    check = false;
                }
                ++i;
            }
        } else if (this.techTributerDemmander != null && this.techTributerDemmander.length > 0) {
            i = 0;
            while (i < this.techTributerDemmander.length && check) {
                if (!this.data.getTribe(this.civTributer).hasTech(this.techTributerDemmander[i])) {
                    this.error = 9;
                    check = false;
                } else if (this.data.getTribe(this.civDemmander).hasTech(this.techTributerDemmander[i])) {
                    this.error = 11;
                    check = false;
                }
                ++i;
            }
        }
        i = 0;
        while (this.unitsDemmanderTributer != null && i < this.unitsDemmanderTributer.length) {
            if (this.unitsDemmanderTributer[i] == null) {
                this.error = 13;
            }
            ++i;
        }
        int i2 = 0;
        while (this.unitsTributerDemmander != null && i2 < this.unitsTributerDemmander.length) {
            if (this.unitsTributerDemmander[i2] == null) {
                this.error = 14;
            }
            ++i2;
        }
        int i3 = 0;
        while (this.citiesDemmanderTributer != null && i3 < this.citiesDemmanderTributer.length) {
            if (this.citiesDemmanderTributer[i3] == null) {
                this.error = 15;
            }
            ++i3;
        }
        int i4 = 0;
        while (this.citiesTributerDemmander != null && i4 < this.citiesTributerDemmander.length) {
            if (this.citiesTributerDemmander[i4] == null) {
                this.error = 16;
            }
            ++i4;
        }
        if (this.civTributer == 0) {
            if (this.turnGame != this.data.getTurnNumber()) {
                this.error = 17;
                check = false;
            } else if (this.civDemmander > this.civTributer) {
                if (!(this.turnGame + 1 == this.data.getTurnNumber() && this.civTributer > this.data.getLastCivMoved() || this.turnGame == this.data.getTurnNumber() && this.civTributer < this.data.getLastCivMoved())) {
                    check = false;
                    this.error = 17;
                }
            } else if (this.turnGame != this.data.getTurnNumber() || this.civTributer <= this.data.getLastCivMoved()) {
                check = false;
                this.error = 17;
            }
        }
        return check;
    }

    public int getError() {
        return this.error;
    }

    public String getErrorMessage(int language) {
        String temp = new String();
        switch (this.error) {
            case 0: {
                temp = temp + StrConstants.STR_NO_ERROR[language];
                break;
            }
            case 1: {
                temp = temp + StrConstants.STR_BAD_SIGNATURE[language];
                break;
            }
            case 2: {
                temp = temp + StrConstants.STR_BAD_DEMMANDER[language];
                break;
            }
            case 3: {
                temp = temp + StrConstants.STR_BAD_TRIBUTER[language];
                break;
            }
            case 4: {
                temp = temp + StrConstants.STR_SAME_DEMMANDER_TRIBUTER[language];
                break;
            }
            case 5: {
                temp = temp + StrConstants.STR_TOO_MUCH_OFFERED_GOLD[language];
                break;
            }
            case 6: {
                temp = temp + StrConstants.STR_TOO_LESS_OFFERED_GOLD[language];
                break;
            }
            case 7: {
                temp = temp + StrConstants.STR_TOO_MUCH_DEMMANDED_GOLD[language];
                break;
            }
            case 8: {
                temp = temp + StrConstants.STR_TOO_LESS_DEMMANDED_GOLD[language];
                break;
            }
            case 10: {
                temp = temp + StrConstants.STR_NON_TECH_OFFERED[language];
                break;
            }
            case 9: {
                temp = temp + StrConstants.STR_NON_TECH_DEMMANDED[language];
                break;
            }
            case 12: {
                temp = temp + StrConstants.STR_ALREADY_TECH_OFFERED[language];
                break;
            }
            case 11: {
                temp = temp + StrConstants.STR_ALREADY_TECH_DEMMANDED[language];
                break;
            }
            case 13: {
                temp = temp + StrConstants.STR_UNIT_OFFERED_NON_EXISTS[language];
                break;
            }
            case 14: {
                temp = temp + StrConstants.STR_UNIT_DEMMANDED_NON_EXISTS[language];
                break;
            }
            case 16: {
                temp = temp + StrConstants.STR_CITY_DEMMANDED_NON_EXISTS[language];
                break;
            }
            case 15: {
                temp = temp + StrConstants.STR_CITY_OFFERED_NON_EXISTS[language];
                break;
            }
            case 17: {
                temp = temp + StrConstants.STR_OBSOLETE_OFFER[language];
                break;
            }
            default: {
                temp = temp + StrConstants.STR_UNKNOW_ERROR[language];
            }
        }
        return temp;
    }

    static {
        IDENTIFIER_STRING = IDENTIFIER_STRING;
        NO_ERROR = 0;
        BAD_SIGNATURE = 1;
        BAD_DEMMANDER = 2;
        BAD_TRIBUTER = 3;
        SAME_DEMMANDER_TRIBUTER = 4;
        TOO_MUCH_OFFERED_GOLD = 5;
        TOO_LESS_OFFERED_GOLD = 6;
        TOO_MUCH_DEMMANDED_GOLD = 7;
        TOO_LESS_DEMMANDED_GOLD = 8;
        NON_TECH_DEMMANDED = 9;
        NON_TECH_OFFERED = 10;
        ALREADY_TECH_DEMMANDED = 11;
        ALREADY_TECH_OFFERED = 12;
        UNIT_OFFERED_NON_EXISTS = 13;
        UNIT_DEMMANDED_NON_EXISTS = 14;
        CITY_OFFERED_NON_EXISTS = 15;
        CITY_DEMMANDED_NON_EXISTS = 16;
        OBSOLETE_OFFER = 17;
    }
}

