/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jmkirschberg.games.civ2.Civ2Data;
import jmkirschberg.games.civ2.Offer;
import jmkirschberg.games.civ2.StrConstants;
import jmkirschberg.games.civ2.Technology;
import jmkirschberg.games.civ2.Tribe;

public class DiplomaticDialog
extends JDialog {
    private Civ2Data data;
    private Offer offer;
    private boolean buttonOkPush = false;
    private ArrayList techArrayDemmander = new ArrayList();
    private ArrayList techArrayTributer = new ArrayList();
    private int language = 0;
    private Tribe demmander;
    private Tribe tributer;
    private JTextField goldFieldTributer;
    private JButton buttonAddDemmander;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane1;
    private JComboBox techComboBoxDemmander;
    private JButton buttonOk;
    private JTextField goldFieldDemmander;
    private JComboBox teatryComboBox;
    private JList techFieldDemmander;
    private JButton buttonRemoveTributer;
    private JComboBox techComboBoxTributer;
    private JButton buttonAddTributer;
    private JLabel jLabel9;
    private JLabel jLabel8;
    private JButton buttonRemoveDemmander;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private JButton buttonCancel;
    private JLabel jLabel5;
    private JLabel jLabel4;
    private JLabel jLabel10;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JList techFieldTributer;
    private JLabel jLabel1;

    public DiplomaticDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public boolean show(Offer o, Civ2Data data) throws IOException {
        return this.show(o, data, 0);
    }

    public boolean show(Offer o, Civ2Data data, int lang) throws IOException {
        this.offer = o;
        this.data = data;
        this.tributer = data.getTribe(o.getCivTributer());
        this.demmander = data.getTribe(o.getCivDemmander());
        this.language = lang;
        this.inizialite();
        super.show();
        return this.buttonOkPush;
    }

    private void inizialite() throws IOException {
        int i;
        Technology[] temp;
        this.buttonOk.setText(StrConstants.STR_BUTTON_OK[this.language]);
        this.buttonCancel.setText(StrConstants.STR_BUTTON_CANCEL[this.language]);
        this.buttonAddTributer.setText(StrConstants.STR_BUTTON_ADD[this.language]);
        this.buttonAddDemmander.setText(StrConstants.STR_BUTTON_ADD[this.language]);
        this.buttonRemoveTributer.setText(StrConstants.STR_BUTTON_REMOVE[this.language]);
        this.buttonRemoveDemmander.setText(StrConstants.STR_BUTTON_REMOVE[this.language]);
        this.jLabel1.setText(StrConstants.STR_GOLD_OFFER[this.language]);
        this.jLabel2.setText(StrConstants.STR_TECH_OFFER[this.language]);
        this.jLabel4.setText(StrConstants.STR_TECH_OFFERED[this.language]);
        this.jLabel3.setText(StrConstants.STR_MAXIMUM[this.language] + this.demmander.getMoney());
        this.jLabel5.setText(StrConstants.STR_MAKE[this.language]);
        this.jLabel6.setText(StrConstants.STR_GOLD_DEMMAND[this.language]);
        this.jLabel8.setText(StrConstants.STR_TECH_DEMMAND[this.language]);
        this.jLabel9.setText(StrConstants.STR_TECH_DEMMANDED[this.language]);
        this.goldFieldDemmander.setText("0");
        this.goldFieldTributer.setText("0");
        this.techComboBoxDemmander.removeAllItems();
        this.techComboBoxTributer.removeAllItems();
        if (this.demmander.hasEmbassy(this.offer.getCivTributer())) {
            this.jLabel7.setText(StrConstants.STR_MAXIMUM[this.language] + this.tributer.getMoney());
        } else {
            this.jLabel7.setText(StrConstants.STR_MAXIMUM[this.language] + StrConstants.STR_UNKNOW[this.language]);
        }
        boolean count = false;
        if (this.demmander.hasEmbassy(this.offer.getCivTributer())) {
            temp = this.data.getTechAdvantage(this.offer.getCivDemmander(), this.offer.getCivTributer());
            if (temp != null) {
                i = 0;
                while (i < temp.length) {
                    this.techComboBoxDemmander.addItem(temp[i]);
                    ++i;
                }
            }
        } else {
            Technology[] demmanderTechs = this.demmander.getTechs(this.data.getRules().getTechnologies());
            i = 0;
            while (i < demmanderTechs.length) {
                this.techComboBoxDemmander.addItem(demmanderTechs[i]);
                ++i;
            }
        }
        count = false;
        if (this.demmander.hasEmbassy(this.offer.getCivTributer())) {
            temp = this.data.getTechAdvantage(this.offer.getCivTributer(), this.offer.getCivDemmander());
            if (temp != null) {
                i = 0;
                while (i < temp.length) {
                    this.techComboBoxTributer.addItem(temp[i]);
                    ++i;
                }
            }
        } else {
            Technology[] tributerTechs = this.data.getRules().getTechnologies();
            i = 0;
            while (i < tributerTechs.length) {
                if (!this.demmander.hasTech(tributerTechs[i])) {
                    this.techComboBoxTributer.addItem(tributerTechs[i]);
                }
                ++i;
            }
        }
        this.teatryComboBox.removeAllItems();
        this.teatryComboBox.addItem(StrConstants.STR_NONE[this.language]);
        this.jLabel10.setText(StrConstants.STR_CURRENT_NONE[this.language]);
        if (this.demmander.hasPeace(this.offer.getCivTributer()) || this.demmander.hasAlliance(this.offer.getCivTributer())) {
            if (this.demmander.hasAlliance(this.offer.getCivTributer())) {
                this.teatryComboBox.addItem(StrConstants.STR_PEACE[this.language]);
                this.jLabel10.setText(StrConstants.STR_CURRENT_ALLIANCE[this.language]);
            } else {
                this.teatryComboBox.addItem(StrConstants.STR_ALLIANCE[this.language]);
                this.jLabel10.setText(StrConstants.STR_CURRENT_PEACE[this.language]);
            }
        } else {
            this.teatryComboBox.addItem(StrConstants.STR_PEACE[this.language]);
            this.teatryComboBox.addItem(StrConstants.STR_ALLIANCE[this.language]);
            if (this.demmander.hasCeaseFire(this.offer.getCivTributer())) {
                this.jLabel10.setText(StrConstants.STR_CURRENT_CEASE_FIRE[this.language]);
            } else {
                this.teatryComboBox.addItem(StrConstants.STR_CEASE_FIRE[this.language]);
            }
        }
        this.teatryComboBox.setSelectedIndex(0);
        this.teatryComboBox.setVisible(true);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.goldFieldTributer = new JTextField();
        this.techComboBoxTributer = new JComboBox();
        this.buttonAddTributer = new JButton();
        this.jLabel4 = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.techFieldDemmander = new JList();
        this.jLabel5 = new JLabel();
        this.teatryComboBox = new JComboBox();
        this.jLabel6 = new JLabel();
        this.goldFieldDemmander = new JTextField();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.techFieldTributer = new JList();
        this.jLabel9 = new JLabel();
        this.buttonRemoveTributer = new JButton();
        this.buttonRemoveDemmander = new JButton();
        this.techComboBoxDemmander = new JComboBox();
        this.buttonAddDemmander = new JButton();
        this.jLabel10 = new JLabel();
        this.getContentPane().setLayout(null);
        this.setTitle("Civ2 PBEM DIPLOMACY");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DiplomaticDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setText("jLabel1");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(50, 40, 160, 16);
        this.jLabel2.setText("jLabel2");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(10, 150, 160, 16);
        this.jLabel3.setText("jLabel3");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(380, 40, 110, 16);
        this.getContentPane().add(this.goldFieldTributer);
        this.goldFieldTributer.setBounds(240, 90, 110, 20);
        this.getContentPane().add(this.techComboBoxTributer);
        this.techComboBoxTributer.setBounds(460, 150, 110, 25);
        this.buttonAddTributer.setText("Add");
        this.buttonAddTributer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DiplomaticDialog.this.buttonAddTributerActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.buttonAddTributer);
        this.buttonAddTributer.setBounds(580, 150, 56, 26);
        this.jLabel4.setText("jLabel4");
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(50, 200, 130, 16);
        this.buttonCancel.setText("Cancel");
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DiplomaticDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.buttonCancel);
        this.buttonCancel.setBounds(10, 360, 73, 26);
        this.buttonOk.setText("Ok");
        this.buttonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DiplomaticDialog.this.buttonOkActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.buttonOk);
        this.buttonOk.setBounds(540, 360, 90, 26);
        this.jScrollPane1.setViewportView(this.techFieldDemmander);
        this.getContentPane().add(this.jScrollPane1);
        this.jScrollPane1.setBounds(100, 230, 190, 100);
        this.jLabel5.setText("jLabel5");
        this.getContentPane().add(this.jLabel5);
        this.jLabel5.setBounds(100, 360, 90, 16);
        this.teatryComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DiplomaticDialog.this.teatryComboBoxActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.teatryComboBox);
        this.teatryComboBox.setBounds(190, 360, 140, 25);
        this.jLabel6.setText("jLabel6");
        this.getContentPane().add(this.jLabel6);
        this.jLabel6.setBounds(50, 90, 170, 20);
        this.goldFieldDemmander.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DiplomaticDialog.this.goldFieldDemmanderActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.goldFieldDemmander);
        this.goldFieldDemmander.setBounds(240, 40, 110, 20);
        this.jLabel7.setText("jLabel7");
        this.getContentPane().add(this.jLabel7);
        this.jLabel7.setBounds(380, 90, 140, 16);
        this.jLabel8.setText("jLabel8");
        this.getContentPane().add(this.jLabel8);
        this.jLabel8.setBounds(320, 150, 140, 16);
        this.jScrollPane2.setViewportView(this.techFieldTributer);
        this.getContentPane().add(this.jScrollPane2);
        this.jScrollPane2.setBounds(330, 230, 180, 100);
        this.jLabel9.setText("jLabel9");
        this.getContentPane().add(this.jLabel9);
        this.jLabel9.setBounds(290, 200, 180, 16);
        this.buttonRemoveTributer.setText("Remove");
        this.buttonRemoveTributer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DiplomaticDialog.this.buttonRemoveTributerActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.buttonRemoveTributer);
        this.buttonRemoveTributer.setBounds(530, 250, 80, 26);
        this.buttonRemoveDemmander.setText("Remove");
        this.buttonRemoveDemmander.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DiplomaticDialog.this.buttonRemoveDemmanderActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.buttonRemoveDemmander);
        this.buttonRemoveDemmander.setBounds(10, 250, 80, 26);
        this.techComboBoxDemmander.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DiplomaticDialog.this.techComboBoxDemmanderActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.techComboBoxDemmander);
        this.techComboBoxDemmander.setBounds(120, 150, 110, 25);
        this.buttonAddDemmander.setText("Add");
        this.buttonAddDemmander.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DiplomaticDialog.this.buttonAddDemmanderActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.buttonAddDemmander);
        this.buttonAddDemmander.setBounds(240, 150, 56, 26);
        this.jLabel10.setText("jLabel10");
        this.getContentPane().add(this.jLabel10);
        this.jLabel10.setBounds(360, 360, 160, 16);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(640, 430));
        this.setLocation((screenSize.width - 640) / 2, (screenSize.height - 430) / 2);
    }

    private void techComboBoxDemmanderActionPerformed(ActionEvent evt) {
    }

    private void buttonRemoveTributerActionPerformed(ActionEvent evt) {
        int temp = this.techFieldTributer.getSelectedIndex();
        if (temp > -1 && temp < this.techArrayTributer.size()) {
            this.techArrayTributer.remove(temp);
            this.techFieldTributer.setListData(this.techArrayTributer.toArray());
        }
    }

    private void buttonRemoveDemmanderActionPerformed(ActionEvent evt) {
        int temp = this.techFieldDemmander.getSelectedIndex();
        if (temp > -1 && temp < this.techArrayDemmander.size()) {
            this.techArrayDemmander.remove(temp);
            this.techFieldDemmander.setListData(this.techArrayDemmander.toArray());
        }
    }

    private void goldFieldDemmanderActionPerformed(ActionEvent evt) {
    }

    private void buttonAddDemmanderActionPerformed(ActionEvent evt) {
        if (this.techComboBoxDemmander.getSelectedItem() != null) {
            boolean isAlready;
            String temp = this.techComboBoxDemmander.getSelectedItem().toString();
            boolean bl = isAlready = this.techArrayDemmander.indexOf(this.techComboBoxDemmander.getSelectedItem()) != -1;
            if (!isAlready) {
                this.techArrayDemmander.add(this.techComboBoxDemmander.getSelectedItem());
                this.techFieldDemmander.setListData(this.techArrayDemmander.toArray());
            }
        }
    }

    private void teatryComboBoxActionPerformed(ActionEvent evt) {
    }

    private void buttonAddTributerActionPerformed(ActionEvent evt) {
        if (this.techComboBoxTributer.getSelectedItem() != null) {
            boolean isAlready;
            String temp = this.techComboBoxTributer.getSelectedItem().toString();
            boolean bl = isAlready = this.techArrayTributer.indexOf(this.techComboBoxTributer.getSelectedItem()) != -1;
            if (!isAlready) {
                this.techArrayTributer.add(this.techComboBoxTributer.getSelectedItem());
                this.techFieldTributer.setListData(this.techArrayTributer.toArray());
            }
        }
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.buttonOkPush = false;
        this.setVisible(false);
        this.dispose();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        int j;
        int i;
        Technology[] temp;
        ComboBoxModel model;
        boolean goldTribute = false;
        boolean error = false;
        try {
            this.offer.setGoldDemmanderTributer(new Integer(this.goldFieldDemmander.getText()));
        }
        catch (Exception e) {
            this.goldFieldDemmander.setText("0");
            JOptionPane.showMessageDialog(null, StrConstants.STR_INCORRECT_GOLD_OFFER[this.language], StrConstants.STR_ERROR[this.language], 0);
            error = true;
        }
        try {
            this.offer.setGoldTributerDemmander(new Integer(this.goldFieldTributer.getText()));
        }
        catch (Exception e) {
            this.goldFieldTributer.setText("0");
            JOptionPane.showMessageDialog(null, StrConstants.STR_INCORRECT_GOLD_DEMMAND[this.language], StrConstants.STR_ERROR[this.language], 0);
            error = true;
        }
        try {
            if (this.demmander.getMoney() < this.offer.getGoldDemmanderTributer() || this.offer.getGoldDemmanderTributer() < 0) {
                JOptionPane.showMessageDialog(null, StrConstants.STR_INCORRECT_GOLD_OFFER[this.language], StrConstants.STR_ERROR[this.language], 0);
                error = true;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, StrConstants.STR_UNKNOW_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
            error = true;
        }
        try {
            if (this.demmander.hasEmbassy(this.offer.getCivTributer())) {
                if (this.tributer.getMoney() < this.offer.getGoldTributerDemmander() || this.offer.getGoldTributerDemmander() < 0) {
                    JOptionPane.showMessageDialog(null, StrConstants.STR_INCORRECT_GOLD_DEMMAND[this.language], StrConstants.STR_ERROR[this.language], 0);
                    error = true;
                }
            } else if (this.offer.getGoldTributerDemmander() < 0) {
                JOptionPane.showMessageDialog(null, StrConstants.STR_INCORRECT_GOLD_DEMMAND[this.language], StrConstants.STR_ERROR[this.language], 0);
                error = true;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, StrConstants.STR_UNKNOW_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
            error = true;
        }
        if (this.techArrayDemmander.size() == 0) {
            this.offer.setTechDemmanderTributer(null);
        } else {
            model = this.techComboBoxDemmander.getModel();
            temp = new Technology[this.techArrayDemmander.size()];
            i = 0;
            while (i < this.techArrayDemmander.size()) {
                j = 0;
                while (j < model.getSize()) {
                    if (model.getElementAt(j) == this.techArrayDemmander.get(i)) {
                        temp[i] = (Technology)model.getElementAt(j);
                    }
                    ++j;
                }
                ++i;
            }
            this.offer.setTechDemmanderTributer(temp);
        }
        if (this.techArrayTributer.size() == 0) {
            this.offer.setTechTributerDemmander(null);
        } else {
            model = this.techComboBoxTributer.getModel();
            temp = new Technology[this.techArrayTributer.size()];
            i = 0;
            while (i < this.techArrayTributer.size()) {
                j = 0;
                while (j < model.getSize()) {
                    if (model.getElementAt(j) == this.techArrayTributer.get(i)) {
                        temp[i] = (Technology)model.getElementAt(j);
                    }
                    ++j;
                }
                ++i;
            }
            this.offer.setTechTributerDemmander(temp);
        }
        if (this.teatryComboBox.getSelectedItem() == StrConstants.STR_PEACE[this.language]) {
            this.offer.setPeace();
        } else if (this.teatryComboBox.getSelectedItem() == StrConstants.STR_CEASE_FIRE[this.language]) {
            this.offer.setCeaseFire();
        } else if (this.teatryComboBox.getSelectedItem() == StrConstants.STR_ALLIANCE[this.language]) {
            this.offer.setAlliance();
        }
        if (!error) {
            this.buttonOkPush = true;
            this.setVisible(false);
            this.dispose();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
    }
}

