/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;
import jmkirschberg.games.civ2.JFrameUnit;

public class UnitsGraphicFile {
    public static final int MIN_UNIT = 0;
    public static final int MAX_UNIT = 62;
    private static final int ROW_SIZE = 9;
    private static final int COLUMN_SIZE = 7;
    private static final int X_SIZE = 65;
    private static final int Y_SIZE = 50;
    private BufferedImage units;

    public UnitsGraphicFile(File f) throws FileNotFoundException, IOException {
        this.units = ImageIO.read(f);
    }

    public Image getAll() {
        return this.units;
    }

    public Image get(int i) {
        if (i < 0 || i > 62) {
            throw new AssertionError();
        }
        return this.units.getSubimage(i % 9 * 65, i / 9 * 49, 66, 50);
    }

    public static void main(String[] args) {
        System.out.println("Test function for Civ2Data class - Civ2 PBEM Diplomacy");
        System.out.println("By Javier Mu\u00f1oz Kirschberg - M\u00e1laga 2002");
        System.out.println("Please select a option");
        System.out.println("1.- Read a Units file and then draw it");
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        try {
            int option = input.read();
            switch (option) {
                case 49: {
                    System.out.println("Enter the file name (GIF format, please!)");
                    String name = input.readLine();
                    name = input.readLine();
                    UnitsGraphicFile units = new UnitsGraphicFile(new File(name));
                    JFrameUnit window = new JFrameUnit(units);
                    window.show();
                    System.out.println("Terminate the process when you want!");
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    static {
        MIN_UNIT = 0;
        MAX_UNIT = 62;
        ROW_SIZE = 9;
        COLUMN_SIZE = 7;
        X_SIZE = 65;
        Y_SIZE = 50;
    }
}

