/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import jmkirschberg.games.civ2.Coordinate;
import jmkirschberg.games.civ2.Map;
import jmkirschberg.games.civ2.Util;

public class Unit {
    private static final int UNKNOW_BYTES = 11;
    private static final int VETERAN = 128;
    private static final int GREYSTAR = 32;
    private Map map;
    private Coordinate coordinate;
    private Coordinate goCoordinate;
    private boolean veteran;
    private boolean greyStar;
    private int byte6;
    private int type;
    private int id;
    private int owner;
    private int movement;
    private int foreigns;
    private int hitPointsLost;
    private int commodity;
    private int orders;
    private int homeCity;
    private int idTop;
    private int idBelow;
    private int[] unknow = new int[11];

    public Unit() {
        this.coordinate = new Coordinate();
        this.goCoordinate = new Coordinate();
    }

    public Unit(Map map, int id) {
        this.id = id;
        this.map = map;
    }

    public void setId(int id) {
        if (id > 255) {
            throw new AssertionError();
        }
        this.id = id;
    }

    public int getHomeCity() {
        return this.homeCity;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public int gettId() {
        return this.id;
    }

    public Map getMap() {
        return this.map;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public int getOwner() {
        return this.owner - 1;
    }

    public boolean exists() {
        return Map.checkCoordinate(this.coordinate);
    }

    public void readExternal(DataInput source) throws IOException {
        int count = 0;
        this.coordinate.readExternal(source);
        this.unknow[count++] = source.readUnsignedByte();
        this.byte6 = source.readUnsignedByte();
        if ((this.byte6 & 0x80) == 128) {
            this.veteran = true;
        }
        if ((this.byte6 & 0x20) == 32) {
            this.greyStar = true;
        }
        this.type = source.readUnsignedByte();
        this.owner = source.readUnsignedByte();
        this.movement = source.readUnsignedByte();
        this.foreigns = source.readUnsignedByte();
        this.hitPointsLost = source.readUnsignedByte();
        this.unknow[count++] = source.readUnsignedByte();
        this.unknow[count++] = source.readUnsignedByte();
        this.commodity = source.readUnsignedByte();
        this.unknow[count++] = source.readUnsignedByte();
        this.orders = source.readUnsignedByte();
        this.homeCity = source.readUnsignedByte();
        this.unknow[count++] = source.readUnsignedByte();
        this.goCoordinate.readExternal(source);
        this.idTop = Util.readUnsignedShort(source);
        this.idBelow = Util.readUnsignedShort(source);
        int i = 0;
        while (i < 6) {
            this.unknow[count++] = source.readUnsignedByte();
            ++i;
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        int count = 0;
        this.coordinate.writeExternal(out);
        out.writeByte(this.unknow[count++]);
        out.writeByte(this.byte6);
        out.writeByte(this.type);
        out.writeByte(this.owner);
        out.writeByte(this.movement);
        out.writeByte(this.foreigns);
        out.writeByte(this.hitPointsLost);
        out.writeByte(this.unknow[count++]);
        out.writeByte(this.unknow[count++]);
        out.writeByte(this.commodity);
        out.writeByte(this.unknow[count++]);
        out.writeByte(this.orders);
        out.writeByte(this.homeCity);
        out.writeByte(this.unknow[count++]);
        this.goCoordinate.writeExternal(out);
        Util.writeUnsignedShort(out, this.idTop);
        Util.writeUnsignedShort(out, this.idBelow);
        int i = 0;
        while (i < 6) {
            out.writeByte(this.unknow[count++]);
            ++i;
        }
    }

    public static Unit[] getUnitFromCiv(Unit[] units, int civ) {
        if (civ < 0 || civ > 6) {
            throw new AssertionError();
        }
        ArrayList<Unit> unitsFromCiv = new ArrayList<Unit>();
        int i = 0;
        while (i < units.length) {
            if (units[i].owner == civ) {
                unitsFromCiv.add(units[i]);
            }
            ++i;
        }
        Unit[] result = null;
        if (unitsFromCiv.size() > 0) {
            result = (Unit[])unitsFromCiv.toArray();
        }
        return result;
    }

    public void reveal(int civ) {
        if (civ < 0 || civ > 6) {
            throw new AssertionError();
        }
        this.foreigns |= 2 << civ;
    }

    public boolean knowsAbout(int i) {
        if (i < 0 || i > 6) {
            throw new AssertionError();
        }
        return (this.foreigns & 2 << i) == 2 << i;
    }

    public void setOwner(int civ) {
        if (civ < 0 || civ > 6) {
            throw new AssertionError();
        }
        this.foreigns |= 2 << this.owner;
        this.owner = civ;
    }

    public void setCoordinate(Coordinate c) {
        if (!Map.checkCoordinate(c)) {
            throw new AssertionError();
        }
        this.coordinate = c;
    }

    public void kill() {
        this.coordinate.setInvalid();
    }

    public int getType() {
        return this.type;
    }

    static {
        UNKNOW_BYTES = 11;
        VETERAN = 128;
        GREYSTAR = 32;
    }
}

