/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class Password {
    private static final int YES = 5;
    private static final int NO = 0;
    private boolean isPasswordProtected;
    private int hash;

    Password() {
    }

    public void readExternal(DataInput input) throws IOException {
        this.isPasswordProtected = input.readUnsignedByte() == 5;
        this.hash = input.readInt();
    }

    public void writeExternal(DataOutput output) throws IOException {
        if (this.isPasswordProtected) {
            output.writeByte(5);
        } else {
            output.writeByte(0);
        }
        output.writeInt(this.hash);
    }

    public boolean isPasswordProtected() {
        return this.isPasswordProtected;
    }

    public boolean checkPassword(String text) {
        if (!this.isPasswordProtected) {
            throw new AssertionError();
        }
        return text.hashCode() == this.hash;
    }

    public void setPassword(String text) {
        this.isPasswordProtected = true;
        this.hash = text.hashCode();
    }

    static {
        YES = 5;
        NO = 0;
    }
}

