/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import jmkirschberg.games.civ2.City;
import jmkirschberg.games.civ2.Map;
import jmkirschberg.games.civ2.NotNetFormatException;
import jmkirschberg.games.civ2.NotOfferCheckedException;
import jmkirschberg.games.civ2.NotPasswordProtectedException;
import jmkirschberg.games.civ2.NotRulesFormatException;
import jmkirschberg.games.civ2.Offer;
import jmkirschberg.games.civ2.Password;
import jmkirschberg.games.civ2.Rules;
import jmkirschberg.games.civ2.Technology;
import jmkirschberg.games.civ2.Tribe;
import jmkirschberg.games.civ2.Unit;

public class Civ2Data {
    private static final String STR_CIVILIZE = "CIVILIZE";
    private static final int NET_VERSION = 44;
    private static final int POS_UNITS = 58;
    private static final int POS_CITIES = 60;
    private Technology[] techs;
    private Map map;
    private Unit[] units;
    private City[] cities;
    private Tribe[] tribes;
    private Tribe barbarian;
    private Rules rules;
    private int[] options;
    private Password[] passwords;
    private int[] fromPasswordsToTribes;
    private int[] fromCitiesToEnd;
    private static final int SIZE_OPTIONS = 100;
    private static final int SIZE_FROM_PASSWORDS_TO_TRIBES = 449;
    private static final int POS_TURN_NUMBER = 28;
    private static final int POS_LAST_CIV_MOVED = 41;
    private int turns;
    private int playerCiv;

    public Civ2Data(DataInputStream saveGameStream, DataInputStream rulesStream) throws IOException, NotRulesFormatException, NotNetFormatException {
        try {
            this.options = new int[100];
            this.passwords = new Password[7];
            int i = 0;
            while (i < this.passwords.length) {
                this.passwords[i] = new Password();
                ++i;
            }
            this.fromPasswordsToTribes = new int[449];
            this.cities = null;
            this.units = null;
            this.tribes = new Tribe[7];
            int i2 = 0;
            while (i2 < this.tribes.length) {
                this.tribes[i2] = new Tribe();
                ++i2;
            }
            this.barbarian = new Tribe();
            this.map = new Map();
            this.rules = new Rules();
            this.rules.readExternal(rulesStream);
        }
        catch (ClassNotFoundException e) {
            throw new IOException();
        }
        this.readExternal(saveGameStream);
    }

    /*
     * Unable to fully structure code
     */
    public void readExternal(DataInput input) throws IOException, NotRulesFormatException, NotNetFormatException {
        block17: {
            i = 0;
            while (i < this.options.length) {
                this.options[i] = input.readUnsignedByte();
                ++i;
            }
            temp = new byte["CIVILIZE".length()];
            i = 0;
            while (i < temp.length) {
                temp[i] = (byte)this.options[i];
                ++i;
            }
            if (!"CIVILIZE".equals(new String(temp))) {
                throw new NotNetFormatException();
            }
            if (this.options[temp.length] != 0 | this.options[temp.length + 2] != 44) {
                throw new NotNetFormatException();
            }
            i = 0;
            while (i < this.passwords.length) {
                this.passwords[i].readExternal(input);
                ++i;
            }
            i = 0;
            while (i < this.fromPasswordsToTribes.length) {
                this.fromPasswordsToTribes[i] = input.readUnsignedByte();
                ++i;
            }
            i = 0;
            while (i < this.tribes.length) {
                this.tribes[i] = new Tribe();
                this.tribes[i].readTribeName(input);
                ++i;
            }
            this.barbarian.readTribeTechMoney(input);
            this.barbarian.setIndex(-1);
            i = 0;
            while (i < this.tribes.length) {
                this.tribes[i].readTribeTechMoney(input);
                this.tribes[i].setIndex(i);
                if (this.tribes[i].isMale()) {
                    this.tribes[i].setRulesNameLeader(this.rules.getLeaderMaleName(this.tribes[i].getTribeNumber()));
                } else {
                    this.tribes[i].setRulesNameLeader(this.rules.getLeaderFemaleName(this.tribes[i].getTribeNumber()));
                }
                this.tribes[i].setRulesNameTribe(this.rules.getNameTribe(this.tribes[i].getTribeNumber()));
                this.tribes[i].setRulesNameTribeAdjective(this.rules.getNameTribeAdjective(this.tribes[i].getTribeNumber()));
                ++i;
            }
            this.map.readExternal(input);
            unitsSize = this.options[58] + (this.options[59] << 8);
            this.units = new Unit[unitsSize];
            i = 0;
            while (i < this.units.length) {
                this.units[i] = new Unit();
                this.units[i].readExternal(input);
                ++i;
            }
            citiesSize = this.options[60] + (this.options[61] << 8);
            this.cities = new City[citiesSize];
            i = 0;
            while (i < this.cities.length) {
                this.cities[i] = new City();
                this.cities[i].readExternal(input);
                ++i;
            }
            extraInfo = new ArrayList<Integer>();
            try {
                while (true) {
                    extraInfo.add(new Integer(input.readUnsignedByte()));
                }
            }
            catch (EOFException e) {
                this.fromCitiesToEnd = new int[extraInfo.size()];
                i = 0;
                ** while (i < extraInfo.size())
            }
lbl-1000:
            // 1 sources

            {
                this.fromCitiesToEnd[i] = (Integer)extraInfo.get(i);
                ++i;
                continue;
lbl76:
                // 1 sources

                break block17;
            }
            catch (IOException e) {
                throw e;
            }
        }
    }

    public void writeExternal(DataOutput output) throws IOException {
        int i = 0;
        while (i < this.options.length) {
            output.writeByte(this.options[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.passwords.length) {
            this.passwords[i2].writeExternal(output);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.fromPasswordsToTribes.length) {
            output.writeByte(this.fromPasswordsToTribes[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.tribes.length) {
            this.tribes[i4].writeTribeName(output);
            ++i4;
        }
        this.barbarian.writeTribeTechMoney(output);
        int i5 = 0;
        while (i5 < this.tribes.length) {
            this.tribes[i5].writeTribeTechMoney(output);
            ++i5;
        }
        this.map.writeExternal(output);
        int i6 = 0;
        while (i6 < this.units.length) {
            this.units[i6].writeExternal(output);
            ++i6;
        }
        int i7 = 0;
        while (i7 < this.cities.length) {
            this.cities[i7].writeExternal(output);
            ++i7;
        }
        int i8 = 0;
        while (i8 < this.fromCitiesToEnd.length) {
            output.writeByte(this.fromCitiesToEnd[i8]);
            ++i8;
        }
    }

    public void revealTerrain(int civ1, int civ2) {
        this.map.revealTerrain(civ1, civ2);
    }

    public void revealUnits(int civ1, int civ2) {
        int i = 0;
        while (i < this.units.length) {
            if (this.units[i].exists() && this.units[i].getOwner() == civ2) {
                this.map.revealUnit(this.units[i], civ1);
            }
            ++i;
        }
    }

    public void revealCities(int civ1, int civ2) {
        int i = 0;
        while (i < this.cities.length) {
            if (this.cities[i].getOwner() == civ2 && this.cities[i].exists()) {
                this.map.revealCity(this.cities[i], civ1, civ2);
            }
            ++i;
        }
    }

    public void revealMap(int civ1, int civ2) {
        this.map.revealFeatures(civ1, civ2);
        int i = 0;
        while (i < this.units.length) {
            if (this.units[i].getOwner() == civ2 && this.units[i].exists()) {
                this.map.revealUnit(this.units[i], civ1);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.cities.length) {
            if (this.cities[i2].getOwner() == civ2 && this.cities[i2].exists()) {
                this.map.revealCity(this.cities[i2], civ1, civ2);
            }
            ++i2;
        }
    }

    public City getCapital(int civ) {
        City result = null;
        int i = 0;
        while (i < this.cities.length) {
            if (this.cities[i].exists() && this.cities[i].isCapital() && this.cities[i].getOwner() == civ) {
                result = this.cities[i];
            }
            ++i;
        }
        return result;
    }

    public City[] getCapital() {
        City[] capitals = new City[7];
        int i = 0;
        while (i < capitals.length) {
            capitals[i] = null;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.cities.length) {
            int owner = this.cities[i2].getOwner();
            if (this.cities[i2].exists() && this.cities[i2].isCapital() && capitals[owner] == null) {
                capitals[owner] = this.cities[i2];
            }
            ++i2;
        }
        return capitals;
    }

    public City getClosest(Unit u) {
        City c = null;
        int distance = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.cities.length) {
            if (u.getCoordinate().distance(this.cities[i].getCoordinate()) < distance) {
                distance = u.getCoordinate().distance(this.cities[i].getCoordinate());
                c = this.cities[i];
            }
            ++i;
        }
        return c;
    }

    public City getClosest(Unit u, int civ) {
        if (civ < 0 || civ > 6) {
            throw new AssertionError();
        }
        City c = null;
        int distance = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.cities.length) {
            if (c.knowsAbout(civ) && u.getCoordinate().distance(this.cities[i].getCoordinate()) < distance) {
                distance = u.getCoordinate().distance(this.cities[i].getCoordinate());
                c = this.cities[i];
            }
            ++i;
        }
        return c;
    }

    public String[] getNameTribeAdjective() {
        String[] result = new String[7];
        int i = 0;
        while (i < result.length) {
            result[i] = this.tribes[i].getNameTribeAdjective();
            ++i;
        }
        return result;
    }

    public String[] getNameTribe() {
        String[] result = new String[7];
        int i = 0;
        while (i < result.length) {
            result[i] = this.tribes[i].getNameTribe();
            ++i;
        }
        return result;
    }

    public String[] getNameLeader() {
        String[] result = new String[7];
        int i = 0;
        while (i < result.length) {
            result[i] = this.tribes[i].getNameLeader();
            ++i;
        }
        return result;
    }

    public int[] getMoney() {
        int[] money = new int[7];
        int i = 0;
        while (i < 7) {
            money[i] = this.tribes[i].getMoney();
            ++i;
        }
        return money;
    }

    public boolean hasEmbassy(int civ1, int civ2) {
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0) {
            throw new AssertionError();
        }
        return this.tribes[civ1].hasEmbassy(civ2);
    }

    public Technology[] getTechAdvantage(int civ1, int civ2) {
        Technology[] advantages;
        if (civ1 > 6 || civ2 > 6 || civ1 < 0 || civ2 < 0) {
            throw new AssertionError();
        }
        ArrayList<Technology> techs = new ArrayList<Technology>();
        Technology[] techCiv1 = this.tribes[civ1].getTechs(this.rules.getTechnologies());
        int i = 0;
        while (i < techCiv1.length) {
            if (!this.tribes[civ2].hasTech(techCiv1[i])) {
                techs.add(techCiv1[i]);
            }
            ++i;
        }
        if (techs.size() > 0) {
            advantages = new Technology[techs.size()];
            int i2 = 0;
            while (i2 < techs.size()) {
                advantages[i2] = (Technology)techs.get(i2);
                ++i2;
            }
        } else {
            advantages = null;
        }
        return advantages;
    }

    public Tribe getTribe(int civ) {
        if ((civ > 6 || civ < 0) && civ != -1) {
            throw new AssertionError();
        }
        if (civ == -1) {
            return this.barbarian;
        }
        return this.tribes[civ];
    }

    public City[] getCities() {
        return this.cities;
    }

    public Unit[] getUnits() {
        return this.units;
    }

    public boolean isPasswordProtected(int civ) {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        return this.passwords[civ].isPasswordProtected();
    }

    public boolean equalPassword(int civ, String text) throws NotPasswordProtectedException {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        return this.passwords[civ].checkPassword(text);
    }

    public int getTurnNumber() {
        return this.options[28] + (this.options[29] << 8);
    }

    public String getTurnNumberPrintable() {
        String result;
        int temp = this.options[30] + (this.options[31] << 8);
        if (temp > 32768) {
            temp = 65536 - temp + 1;
            result = "b";
        } else {
            result = "a";
        }
        result = result + temp;
        result = result + ".dat";
        return result;
    }

    public int[] getSignature() {
        return this.map.getHeader();
    }

    public void setPassword(int civ, String text) {
        if (civ > 6 || civ < 0) {
            throw new AssertionError();
        }
        this.passwords[civ].setPassword(text);
    }

    public static void main(String[] args) {
        System.out.println("Test function for Civ2Data class - Civ2 PBEM Diplomacy");
        System.out.println("By Javier Mu\u00f1oz Kirschberg - M\u00e1laga 2002");
        System.out.println("Enter the file name (output on TestCiv2Dip.net)");
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        String name = null;
        String name2 = null;
        Civ2Data data = null;
        int pos = 0;
        try {
            name = input.readLine();
            pos = name.lastIndexOf(System.getProperty("file.separator"));
            name2 = name.substring(0, pos + 1);
            name2 = name2 + "RULES.TXT";
            FileInputStream saved = new FileInputStream(name);
            FileInputStream rules = new FileInputStream(name2);
            data = new Civ2Data(new DataInputStream(saved), new DataInputStream(rules));
        }
        catch (IOException e) {
            System.out.println("Fatal I/O error");
            System.exit(0);
        }
        catch (NotRulesFormatException e) {
            System.out.println("Invalid RULES.TXT format");
            System.out.println(e);
        }
        catch (NotNetFormatException e) {
            System.out.println("Not a valid Civ2 MPGE NET file");
            System.out.println(e);
        }
        System.out.println("Please select a option");
        System.out.println("1.- Write the same NET file");
        System.out.println("2.- Exchange terrain maps");
        System.out.println("3.- Exchange entire maps");
        System.out.println("4.- Show capitals");
        System.out.println("5.- Show a civ techs");
        System.out.println("6.- Reveal a foreign map");
        try {
            int option = input.read();
            switch (option) {
                case 49: {
                    input.readLine();
                    String name3 = name.substring(0, pos + 1);
                    name3 = name3 + "TestCiv2Dip.net";
                    FileOutputStream output = new FileOutputStream(name3);
                    data.writeExternal(new DataOutputStream(output));
                    break;
                }
                case 50: {
                    input.readLine();
                    System.out.println("Enter the civ to read terrain from");
                    int civ1 = input.read() - 48;
                    name2 = input.readLine();
                    System.out.println("Enter the civ to write terrain to");
                    int civ2 = input.read() - 48;
                    name2 = input.readLine();
                    data.revealTerrain(civ2, civ1);
                    FileOutputStream output = new FileOutputStream(name);
                    data.writeExternal(new DataOutputStream(output));
                    System.out.println("Done!");
                    break;
                }
                case 51: {
                    input.readLine();
                    System.out.println("Enter the civ to read map from");
                    int civ1 = input.read() - 48;
                    name2 = input.readLine();
                    System.out.println("Enter the civ to write map to");
                    int civ2 = input.read() - 48;
                    name2 = input.readLine();
                    data.revealMap(civ2, civ1);
                    FileOutputStream output = new FileOutputStream(name);
                    data.writeExternal(new DataOutputStream(output));
                    System.out.println("Done!");
                    break;
                }
                case 52: {
                    input.readLine();
                    City[] cities = data.getCities();
                    int i = 0;
                    while (i < cities.length) {
                        if (cities[i].isCapital()) {
                            Tribe tribe = data.getTribe(cities[i].getOwner());
                            System.out.println("City " + cities[i].getName() + " is " + "capital of " + tribe.getNameLeader() + " from " + tribe.getNameTribe());
                        }
                        ++i;
                    }
                    System.out.println("Done!");
                    break;
                }
                case 53: {
                    input.readLine();
                    System.out.println("Enter the civ to read techs from");
                    int civ1 = input.read() - 48;
                    Technology[] techsCiv1 = data.getTribe(civ1).getTechs(data.getRules().getTechnologies());
                    int i = 0;
                    while (i < techsCiv1.length) {
                        System.out.println(techsCiv1[i].toString());
                        ++i;
                    }
                    break;
                }
                case 54: {
                    input.readLine();
                    System.out.println("Enter the civ to read map from");
                    int civ2 = input.read() - 48;
                    name2 = input.readLine();
                    System.out.println("Enter the civ to write map to");
                    int civ1 = input.read() - 48;
                    name2 = input.readLine();
                    System.out.println("Enter the foreign civ");
                    int civ3 = input.read() - 48;
                    name2 = input.readLine();
                    data.revealForeignMap(civ1, civ2, civ3);
                    break;
                }
            }
            data.writeExternal(new DataOutputStream(new FileOutputStream(new File(name))));
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found");
            System.out.println(e);
        }
        catch (IOException e) {
            System.out.println("IOException");
            System.out.println(e);
        }
    }

    public void revealForeignMap(int civ1, int civ2, int civ3) {
        if (civ1 < 0 || civ2 < 0 || civ3 < 0 || civ1 > 6 || civ2 > 6 || civ3 > 6 || civ3 == civ1) {
            throw new AssertionError();
        }
        this.map.revealForeignMap(civ1, civ2, civ3);
        int i = 0;
        while (i < this.cities.length) {
            if (this.cities[i].knowsAbout(civ2) && this.cities[i].getOwner() == civ3) {
                this.cities[i].reveal(civ1);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.units.length) {
            if (this.units[i2].knowsAbout(civ2) && this.units[i2].getOwner() == civ3) {
                this.units[i2].reveal(civ1);
            }
            ++i2;
        }
    }

    public void setOffer(Offer o) throws NotOfferCheckedException {
        int i;
        Unit[] unitsBarter;
        int i2;
        int i3;
        if (!o.checkOffer()) {
            throw new NotOfferCheckedException();
        }
        int demmander = o.getCivDemmander();
        int tributer = o.getCivTributer();
        this.tribes[demmander].setMoney(this.tribes[demmander].getMoney() + o.getGoldTributerDemmander() - o.getGoldDemmanderTributer());
        this.tribes[tributer].setMoney(this.tribes[tributer].getMoney() + o.getGoldDemmanderTributer() - o.getGoldTributerDemmander());
        if (o.getTechDemmanderTributer() != null) {
            i3 = 0;
            while (i3 < o.getTechDemmanderTributer().length) {
                this.tribes[tributer].addTech(o.getTechDemmanderTributer()[i3]);
                ++i3;
            }
        }
        if (o.getTechTributerDemmander() != null) {
            i3 = 0;
            while (i3 < o.getTechTributerDemmander().length) {
                this.tribes[demmander].addTech(o.getTechTributerDemmander()[i3]);
                ++i3;
            }
        }
        if (o.getPeace()) {
            this.tribes[demmander].setPeace(tributer);
            this.tribes[tributer].setPeace(demmander);
        } else if (o.getCeaseFire()) {
            this.tribes[demmander].setCeaseFire(tributer);
            this.tribes[tributer].setCeaseFire(demmander);
        } else if (o.getAlliance()) {
            this.tribes[demmander].setAlliance(tributer);
            this.tribes[tributer].setAlliance(demmander);
        }
        if (o.getTerrainMapDemmanderTributer()) {
            this.map.revealTerrain(tributer, demmander);
        }
        if (o.getTerrainMapTributerDemmander()) {
            this.map.revealTerrain(demmander, tributer);
        }
        if (o.getUnitsMapDemmanderTributer()) {
            this.map.revealTerrain(tributer, demmander);
            this.revealUnits(tributer, demmander);
        }
        if (o.getUnitsMapTributerDemmander()) {
            this.map.revealTerrain(demmander, tributer);
            this.revealUnits(demmander, tributer);
        }
        if (o.getCitiesMapDemmanderTributer()) {
            this.map.revealTerrain(tributer, demmander);
            this.revealCities(tributer, demmander);
        }
        if (o.getCitiesMapTributerDemmander()) {
            this.map.revealTerrain(demmander, tributer);
            this.revealCities(demmander, tributer);
        }
        if (o.getAllMapDemmanderTributer()) {
            this.revealMap(tributer, demmander);
        }
        if (o.getAllMapTributerDemmander()) {
            this.revealMap(demmander, tributer);
        }
        boolean[] mapsDemmanderTributer = o.getForeignsMapDemmanderTributer();
        int i4 = 0;
        while (i4 < mapsDemmanderTributer.length) {
            if (mapsDemmanderTributer[i4]) {
                this.revealForeignMap(tributer, demmander, i4);
            }
            ++i4;
        }
        boolean[] mapsTributerDemmander = o.getForeignsMapTributerDemmander();
        int i5 = 0;
        while (i5 < mapsTributerDemmander.length) {
            if (mapsTributerDemmander[i5]) {
                this.revealForeignMap(demmander, tributer, i5);
            }
            ++i5;
        }
        City[] citiesBarter = o.getCitiesDemmanderTributer();
        if (citiesBarter != null) {
            i2 = 0;
            while (i2 < citiesBarter.length) {
                this.setCityOwner(citiesBarter[i2], tributer);
                this.map.revealCity(citiesBarter[i2], tributer, demmander);
                this.map.revealCity(citiesBarter[i2], demmander, tributer);
                ++i2;
            }
        }
        if ((citiesBarter = o.getCitiesTributerDemmander()) != null) {
            i2 = 0;
            while (i2 < citiesBarter.length) {
                this.setCityOwner(citiesBarter[i2], demmander);
                this.map.revealCity(citiesBarter[i2], demmander, tributer);
                this.map.revealCity(citiesBarter[i2], tributer, demmander);
                ++i2;
            }
        }
        if ((unitsBarter = o.getUnitsTributerDemmander()) != null) {
            i = 0;
            while (i < unitsBarter.length) {
                unitsBarter[i].setCoordinate(this.getCapital(demmander).getCoordinate());
                unitsBarter[i].setOwner(demmander);
                ++i;
            }
        }
        if ((unitsBarter = o.getUnitsDemmanderTributer()) != null) {
            i = 0;
            while (i < unitsBarter.length) {
                unitsBarter[i].setCoordinate(this.getCapital(tributer).getCoordinate());
                unitsBarter[i].setOwner(tributer);
                ++i;
            }
        }
        if (o.getDemmanderRevolution()) {
            this.tribes[demmander].setRevolution();
        }
        if (o.getTributerRevolution()) {
            this.tribes[tributer].setRevolution();
        }
    }

    public void setCityOwner(City city, int civ) {
        if (civ > 6 || civ < 0 || city.getOwner() == civ) {
            throw new AssertionError();
        }
        int cityId = 0;
        int i = 0;
        while (city != this.cities[i]) {
            if (this.cities[i].exists()) {
                ++cityId;
            }
            ++i;
        }
        int j = 0;
        while (j < this.units.length) {
            if (this.units[j].getCoordinate().equals(city.getCoordinate())) {
                this.units[j].kill();
            } else if (this.units[j].getHomeCity() == cityId) {
                this.units[j].kill();
            }
            ++j;
        }
        city.setOwner(civ);
    }

    public Rules getRules() {
        return this.rules;
    }

    public int getLastCivMoved() {
        return this.options[41] - 1;
    }

    static {
        STR_CIVILIZE = STR_CIVILIZE;
        NET_VERSION = 44;
        POS_UNITS = 58;
        POS_CITIES = 60;
        SIZE_OPTIONS = 100;
        SIZE_FROM_PASSWORDS_TO_TRIBES = 449;
        POS_TURN_NUMBER = 28;
        POS_LAST_CIV_MOVED = 41;
    }
}

