/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import jmkirschberg.games.civ2.City;
import jmkirschberg.games.civ2.Coordinate;

class CityToFile
implements Externalizable {
    private Coordinate pos;
    private String name;
    private int owner;

    public CityToFile() {
        this.pos = new Coordinate();
        this.name = new String();
        this.owner = 0;
    }

    public CityToFile(City c) {
        this.pos = c.getCoordinate();
        this.name = c.getName();
        this.owner = c.getOwner();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.pos.readExternal(new DataInputStream((InputStream)((Object)objectInput)));
        this.name = (String)objectInput.readObject();
        this.owner = objectInput.read();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.pos.writeExternal(new DataOutputStream((OutputStream)((Object)objectOutput)));
        objectOutput.writeObject(this.name);
        objectOutput.write(this.owner);
    }

    public City getCity(City[] cities) {
        City city = null;
        int i = 0;
        while (i < cities.length && city == null) {
            if (cities[i].getName().equals(this.name) && cities[i].getOwner() == this.owner && cities[i].getCoordinate().equals(this.pos)) {
                city = cities[i];
            }
            ++i;
        }
        return city;
    }
}

