/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public abstract class Util {
    public static final int MIN_CIV = 0;
    public static final int MAX_CIV = 6;
    public static final int BARBARIAN_CIV = -1;
    public static final int RULES_CIVS = 21;
    public static final int MAX_GOLD = 32000;
    public static final int MIN_GOLD = 0;
    public static final int MIN_TECH = 1;
    public static final int MAX_TECH = 104;
    public static final int LEN_SIGNATURE = 14;
    private static int CHARAC_END;
    private static int CHARAC_SPACE;

    public static String readASCII(DataInput d) throws IOException {
        ArrayList<Byte> ascii = new ArrayList<Byte>();
        byte temp = d.readByte();
        do {
            ascii.add(new Byte(temp));
        } while ((temp = d.readByte()) != CHARAC_END);
        byte[] tempArray = new byte[ascii.size()];
        int i = 0;
        while (i < tempArray.length) {
            tempArray[i] = (Byte)ascii.get(i);
            ++i;
        }
        return new String(tempArray);
    }

    public static String readASCII(DataInput d, int b) throws IOException {
        String result = new String();
        ArrayList<Byte> ascii = new ArrayList<Byte>();
        byte temp = d.readByte();
        int counter = 1;
        while (counter < b) {
            ascii.add(new Byte(temp));
            temp = d.readByte();
            ++counter;
        }
        byte[] tempArray = new byte[ascii.size()];
        int i = 0;
        while (i < tempArray.length) {
            tempArray[i] = (Byte)ascii.get(i);
            ++i;
        }
        result = new String(tempArray).trim();
        if (result.indexOf(CHARAC_END) > -1) {
            result = result.substring(0, result.indexOf(CHARAC_END));
        }
        return result;
    }

    public static void writeASCII(DataOutput d, String s) throws IOException {
        byte[] ascii = s.getBytes();
        int i = 0;
        while (i < s.length()) {
            d.writeByte(ascii[i]);
            ++i;
        }
        d.writeByte(CHARAC_END);
    }

    public static void writeASCII(DataOutput d, String s, int size) throws IOException {
        byte[] ascii = s.getBytes();
        int count = 0;
        while (count < s.length() && count < size - 1) {
            d.writeByte(ascii[count++]);
        }
        while (count < size) {
            d.writeByte(CHARAC_END);
            ++count;
        }
    }

    public static int readUnsignedShort(DataInput d) throws IOException {
        int low = d.readUnsignedByte();
        int high = d.readUnsignedByte();
        return (high << 8) + low;
    }

    public static void writeUnsignedShort(DataOutput d, int i) throws IOException {
        d.writeByte(i);
        d.writeByte(i >>> 8);
    }

    static {
        MIN_CIV = 0;
        MAX_CIV = 6;
        BARBARIAN_CIV = -1;
        RULES_CIVS = 21;
        MAX_GOLD = 32000;
        MIN_GOLD = 0;
        MIN_TECH = 1;
        MAX_TECH = 104;
        LEN_SIGNATURE = 14;
        CHARAC_END = 0;
        CHARAC_SPACE = 32;
    }
}

