/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import jmkirschberg.games.civ2.Technology;

class TribeTechMoney {
    private static final int SIZE_TRIBE = 1428;
    private static final int SIZE_TEATRIES = 4;
    private static final int CONTACT = 1;
    private static final int CEASE_FIRE = 2;
    private static final int PEACE = 4;
    private static final int ALLIANCE = 8;
    private static final int VENDETTA = 16;
    private static final int EMBASSY = 128;
    private static final int WAR = 32;
    private static final int MALE = 1;
    private static final int MONEY = 2;
    private static final int CIV_INDEX = 6;
    private static final int RESEARCH_PROGRESS = 8;
    private static final int RESEARCH_TECH = 10;
    private static final int PERCENTAGES = 20;
    private static final int GOVERNMENT = 21;
    private static final int REPUTATION = 30;
    private static final int TEATRIES = 36;
    private static final int ATTITUDES = 65;
    private static final int TECH = 88;
    private static final int MALE_VALUE = 0;
    private static final int FEMALE_VALUE = 2;
    private static final int TECH_SIZE = 12;
    private static final int GOV_ANARCHY = 0;
    private int[] raw = new int[1428];
    private boolean male;
    private int money;
    private int civIndex;
    private int researchProgress;
    private int researchTech;
    private int percentages;
    private int government;
    private int reputation;
    private boolean[] contact = new boolean[7];
    private boolean[] ceaseFire = new boolean[7];
    private boolean[] peace = new boolean[7];
    private boolean[] alliance = new boolean[7];
    private boolean[] vendetta = new boolean[7];
    private boolean[] embassy = new boolean[7];
    private boolean[] war = new boolean[7];
    private int[] attitude = new int[7];
    private int[] techs = null;

    public boolean isMale() {
        return this.male;
    }

    public int getMoney() {
        return this.money;
    }

    public boolean hasEmbassy(int civ1) {
        if (civ1 > 6 || civ1 < 0) {
            throw new AssertionError();
        }
        return this.embassy[civ1];
    }

    public void setRevolution() {
        this.government = 0;
    }

    public Technology[] getTechs(Technology[] t) {
        ArrayList<Technology> techsArray = new ArrayList<Technology>();
        int i = 0;
        while (i < t.length) {
            int j = 0;
            while (j < this.techs.length) {
                if (this.techs[j] == t[i].getOriginalPos()) {
                    techsArray.add(t[i]);
                }
                ++j;
            }
            ++i;
        }
        Technology[] temp = new Technology[techsArray.size()];
        int i2 = 0;
        while (i2 < temp.length) {
            temp[i2] = (Technology)techsArray.get(i2);
            ++i2;
        }
        return temp;
    }

    public int getGold() {
        return this.money;
    }

    public boolean hasTech(Technology tech) {
        boolean sucess = false;
        int i = 0;
        while (!sucess && i < this.techs.length) {
            if (this.techs[i] == tech.getOriginalPos()) {
                sucess = true;
            }
            ++i;
        }
        return sucess;
    }

    public boolean hasPeace(int i) {
        if (i < 0 || i > 6) {
            throw new AssertionError();
        }
        return this.peace[i];
    }

    public boolean hasAlliance(int i) {
        if (i < 0 || i > 6) {
            throw new AssertionError();
        }
        return this.alliance[i];
    }

    public boolean hasCeaseFire(int i) {
        if (i < 0 || i > 6) {
            throw new AssertionError();
        }
        return this.ceaseFire[i];
    }

    public boolean hasContact(int i) {
        if (i < 0 || i > 6) {
            throw new AssertionError();
        }
        return this.contact[i];
    }

    private void toRaw() {
        this.raw[1] = this.male ? 0 : 2;
        this.raw[2] = this.money;
        this.raw[3] = this.money > 255 ? this.money >>> 8 : 0;
        this.raw[6] = this.civIndex;
        this.raw[8] = this.researchProgress;
        this.raw[10] = this.researchTech;
        this.raw[20] = this.percentages;
        this.raw[21] = this.government;
        this.raw[30] = this.reputation;
        int i = 0;
        while (i <= 6) {
            if (this.contact[i]) {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] | 1;
            } else {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] & 0xFFFFFFFE;
            }
            if (this.ceaseFire[i]) {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] | 2;
            } else {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] & 0xFFFFFFFD;
            }
            if (this.peace[i]) {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] | 4;
            } else {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] & 0xFFFFFFFB;
            }
            if (this.alliance[i]) {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] | 8;
            } else {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] & 0xFFFFFFF7;
            }
            if (this.vendetta[i]) {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] | 0x10;
            } else {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] & 0xFFFFFFEF;
            }
            if (this.embassy[i]) {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] | 0x80;
            } else {
                int n = 36 + i * 4;
                this.raw[n] = this.raw[n] & 0xFFFFFF7F;
            }
            if (this.war[i]) {
                int n = 36 + i * 4 + 1;
                this.raw[n] = this.raw[n] | 0x20;
            } else {
                int n = 36 + i * 4 + 1;
                this.raw[n] = this.raw[n] & 0xFFFFFFDF;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < 12) {
            this.raw[88 + i2] = 0;
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.techs.length) {
            this.raw[88 + this.techs[i3] / 8] = this.raw[88 + this.techs[i3] / 8] | 1 << this.techs[i3] % 8;
            ++i3;
        }
    }

    private void fromRaw() {
        this.male = this.raw[1] == 0;
        this.money = this.raw[2] + (this.raw[3] << 8);
        this.civIndex = this.raw[6];
        this.researchProgress = this.raw[8];
        this.researchTech = this.raw[10];
        this.percentages = this.raw[20];
        this.government = this.raw[21];
        this.reputation = this.raw[30];
        int i = 0;
        while (i <= 6) {
            this.contact[i] = (this.raw[36 + i * 4] & 1) == 1;
            this.peace[i] = (this.raw[36 + i * 4] & 4) == 4;
            this.alliance[i] = (this.raw[36 + i * 4] & 8) == 8;
            this.ceaseFire[i] = (this.raw[36 + i * 4] & 2) == 2;
            this.vendetta[i] = (this.raw[36 + i * 4] & 0x10) == 16;
            this.embassy[i] = (this.raw[36 + i * 4] & 0x80) == 128;
            this.war[i] = (this.raw[36 + i * 4 + 1] & 0x20) == 32;
            ++i;
        }
        ArrayList<Integer> techsArray = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < 12) {
            int j = 0;
            while (j < 8) {
                if ((this.raw[88 + i2] & 1 << j) == 1 << j) {
                    techsArray.add(new Integer(i2 * 8 + j));
                }
                ++j;
            }
            ++i2;
        }
        this.techs = new int[techsArray.size()];
        int i3 = 0;
        while (i3 < techsArray.size()) {
            this.techs[i3] = (Integer)techsArray.get(i3);
            ++i3;
        }
    }

    public void readExternal(DataInput input) throws IOException {
        int i = 0;
        while (i < this.raw.length) {
            this.raw[i] = input.readUnsignedByte();
            ++i;
        }
        this.fromRaw();
    }

    public void writeExternal(DataOutput output) throws IOException {
        this.toRaw();
        int i = 0;
        while (i < this.raw.length) {
            output.writeByte(this.raw[i]);
            ++i;
        }
    }

    public int getTribeNumber() {
        return this.civIndex;
    }

    public void setMoney(int money) {
        if (0 > money || 32000 < money) {
            throw new AssertionError();
        }
        this.money = money;
    }

    public void addTech(Technology tech) {
        int[] temp = new int[this.techs.length + 1];
        int i = 0;
        while (i < this.techs.length) {
            temp[i] = this.techs[i];
            ++i;
        }
        temp[temp.length - 1] = tech.getOriginalPos();
        this.techs = temp;
        if (this.researchTech == tech.getOriginalPos()) {
            this.researchTech = 255;
            this.raw[11] = 255;
        }
    }

    public void setPeace(int civ) {
        if (civ < 0 || civ > 6) {
            throw new AssertionError();
        }
        this.peace[civ] = true;
        this.ceaseFire[civ] = true;
        this.alliance[civ] = false;
        this.war[civ] = false;
        this.vendetta[civ] = false;
    }

    public void setAlliance(int civ) {
        if (civ < 0 || civ > 6) {
            throw new AssertionError();
        }
        this.alliance[civ] = true;
        this.peace[civ] = true;
        this.ceaseFire[civ] = true;
        this.war[civ] = false;
        this.vendetta[civ] = false;
    }

    public void setCeaseFire(int civ) {
        if (civ < 0 || civ > 6) {
            throw new AssertionError();
        }
        this.alliance[civ] = false;
        this.peace[civ] = false;
        this.ceaseFire[civ] = true;
        this.war[civ] = false;
        this.vendetta[civ] = false;
    }

    static {
        SIZE_TRIBE = 1428;
        SIZE_TEATRIES = 4;
        CONTACT = 1;
        CEASE_FIRE = 2;
        PEACE = 4;
        ALLIANCE = 8;
        VENDETTA = 16;
        EMBASSY = 128;
        WAR = 32;
        MALE = 1;
        MONEY = 2;
        CIV_INDEX = 6;
        RESEARCH_PROGRESS = 8;
        RESEARCH_TECH = 10;
        PERCENTAGES = 20;
        GOVERNMENT = 21;
        REPUTATION = 30;
        TEATRIES = 36;
        ATTITUDES = 65;
        TECH = 88;
        MALE_VALUE = 0;
        FEMALE_VALUE = 2;
        TECH_SIZE = 12;
        GOV_ANARCHY = 0;
    }
}

