/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import jmkirschberg.games.civ2.Civ2Data;
import jmkirschberg.games.civ2.DiplomaticDialog;
import jmkirschberg.games.civ2.MapCityDialog;
import jmkirschberg.games.civ2.NotNetFormatException;
import jmkirschberg.games.civ2.NotOfferCheckedException;
import jmkirschberg.games.civ2.NotPasswordProtectedException;
import jmkirschberg.games.civ2.NotRulesFileFoundException;
import jmkirschberg.games.civ2.NotRulesFormatException;
import jmkirschberg.games.civ2.Offer;
import jmkirschberg.games.civ2.OfferDialog;
import jmkirschberg.games.civ2.Rules;
import jmkirschberg.games.civ2.StrConstants;
import jmkirschberg.games.civ2.Technology;
import jmkirschberg.utils.io.ExtensionFileFilter;

public class Launcher
extends JFrame {
    private static final int INIT_STATE = 0;
    private static final int SELECTED_FILE = 1;
    private static final int SELECTED_CIV = 2;
    private static final int INTRO_PASSWORD = 3;
    private static final int RE_INTRO_PASSWORD = 4;
    private static final int MAKE_OFFER = 5;
    private static final int VIEW_OFFER = 6;
    private static final int SELECT_TRIBUTER_CIV = 7;
    private static final int NO_ACTION = 0;
    private static final int SET_PASSWORD_ACTION = 1;
    private static final int MAKE_BARTER_ACTION = 2;
    private static final int VIEW_BARTER_ACTION = 3;
    private int action = 0;
    private boolean firstPassword = false;
    private int state = 0;
    private Civ2Data data = null;
    private int[] matching = new int[7];
    private String[] names = null;
    private String tempPassword;
    private JRadioButton[] jRadioButtonArray;
    private int language = 0;
    private int civSelected;
    private Offer offer = new Offer();
    private File netFile;
    private File rulesFile;
    private JPanel jPanel1;
    private JScrollPane panelCredits;
    private JLabel label;
    private JLabel labelLanguage;
    private ButtonGroup buttonGroup1;
    private JComboBox languageComboBox;
    private JRadioButton jRadioButton7;
    private JRadioButton jRadioButton6;
    private JRadioButton jRadioButton5;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton1;
    private JPasswordField textField;
    private JLabel jLabel1;
    private JTextArea labelCredits;
    private JButton buttonPrev;
    private JButton buttonNext;

    public Launcher() {
        this.initComponents();
        this.state = 0;
        this.jRadioButtonArray = new JRadioButton[7];
        this.jRadioButtonArray[0] = this.jRadioButton1;
        this.jRadioButtonArray[1] = this.jRadioButton2;
        this.jRadioButtonArray[2] = this.jRadioButton3;
        this.jRadioButtonArray[3] = this.jRadioButton4;
        this.jRadioButtonArray[4] = this.jRadioButton5;
        this.jRadioButtonArray[5] = this.jRadioButton6;
        this.jRadioButtonArray[6] = this.jRadioButton7;
        this.languageComboBox.setVisible(true);
        this.languageComboBox.removeAllItems();
        this.languageComboBox.addItem(StrConstants.STR_ENGLISH[this.language]);
        this.languageComboBox.addItem(StrConstants.STR_SPANISH[this.language]);
        this.languageComboBox.addItem(StrConstants.STR_ITALIAN[this.language]);
        this.languageComboBox.addItem(StrConstants.STR_GERMAN[this.language]);
        this.languageComboBox.addItem(StrConstants.STR_FRENCH[this.language]);
        this.setState();
    }

    private void showDone() {
        JOptionPane.showMessageDialog(null, StrConstants.STR_DONE[this.language], StrConstants.STR_DONE[this.language], 1);
    }

    private void hideAll() {
        int i = 0;
        while (i < this.jRadioButtonArray.length) {
            this.jRadioButtonArray[i].setVisible(false);
            this.jRadioButtonArray[i].setSelected(false);
            ++i;
        }
        this.label.setVisible(false);
        if (this.state != 0) {
            this.buttonPrev.setEnabled(true);
            this.buttonNext.setEnabled(false);
            this.labelCredits.setVisible(false);
            this.panelCredits.setVisible(false);
        } else {
            this.buttonPrev.setEnabled(false);
            this.buttonNext.setEnabled(true);
            this.labelCredits.setText(StrConstants.STR_CREDITS[this.language]);
            this.labelCredits.setVisible(true);
            this.panelCredits.setVisible(true);
        }
        this.buttonNext.setText(StrConstants.STR_BUTTON_NEXT[this.language]);
        this.buttonPrev.setText(StrConstants.STR_BUTTON_PREV[this.language]);
        this.labelLanguage.setText(StrConstants.STR_LANGUAGE[this.language]);
        this.labelLanguage.setVisible(true);
        this.languageComboBox.setVisible(true);
        this.languageComboBox.removeAllItems();
        this.languageComboBox.addItem(StrConstants.STR_ENGLISH[this.language]);
        this.languageComboBox.addItem(StrConstants.STR_SPANISH[this.language]);
        this.languageComboBox.addItem(StrConstants.STR_ITALIAN[this.language]);
        this.languageComboBox.addItem(StrConstants.STR_GERMAN[this.language]);
        this.languageComboBox.addItem(StrConstants.STR_FRENCH[this.language]);
        this.textField.setVisible(false);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.buttonNext = new JButton();
        this.buttonPrev = new JButton();
        this.label = new JLabel();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jRadioButton6 = new JRadioButton();
        this.jRadioButton7 = new JRadioButton();
        this.textField = new JPasswordField();
        this.labelLanguage = new JLabel();
        this.languageComboBox = new JComboBox();
        this.panelCredits = new JScrollPane();
        this.labelCredits = new JTextArea();
        this.setTitle("CIV2 PBEM DIPLOMACY");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Launcher.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(null);
        this.jPanel1.setPreferredSize(new Dimension(600, 440));
        this.jLabel1.setFont(new Font("Dialog", 1, 24));
        this.jLabel1.setText("CIV2 PBEM DIPLOMACY Utility");
        this.jPanel1.add(this.jLabel1);
        this.jLabel1.setBounds(100, 20, 370, 40);
        this.jRadioButton1.setText("Set Password");
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton1);
        this.jRadioButton1.setBounds(40, 90, 160, 24);
        this.jRadioButton2.setText("Make Barter");
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton2);
        this.jRadioButton2.setBounds(230, 90, 180, 24);
        this.jRadioButton3.setText("Accept Barter");
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton3);
        this.jRadioButton3.setBounds(420, 90, 160, 24);
        this.buttonNext.setText("Next>>");
        this.buttonNext.setAutoscrolls(true);
        this.buttonNext.setEnabled(false);
        this.buttonNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.buttonNextActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buttonNext);
        this.buttonNext.setBounds(484, 330, 100, 26);
        this.buttonPrev.setText("<<Prev");
        this.buttonPrev.setEnabled(false);
        this.buttonPrev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.buttonPrevActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.buttonPrev);
        this.buttonPrev.setBounds(10, 330, 100, 26);
        this.label.setText("First of all, we're going to load the save file");
        this.jPanel1.add(this.label);
        this.label.setBounds(120, 246, 330, 20);
        this.jRadioButton4.setText("jRadioButton4");
        this.buttonGroup1.add(this.jRadioButton4);
        this.jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton4ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton4);
        this.jRadioButton4.setBounds(40, 140, 170, 24);
        this.jRadioButton5.setText("jRadioButton5");
        this.buttonGroup1.add(this.jRadioButton5);
        this.jRadioButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton5ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton5);
        this.jRadioButton5.setBounds(230, 140, 170, 24);
        this.jRadioButton6.setText("jRadioButton6");
        this.buttonGroup1.add(this.jRadioButton6);
        this.jRadioButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton6ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton6);
        this.jRadioButton6.setBounds(420, 140, 170, 24);
        this.jRadioButton7.setText("jRadioButton7");
        this.buttonGroup1.add(this.jRadioButton7);
        this.jRadioButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.jRadioButton7ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jRadioButton7);
        this.jRadioButton7.setBounds(40, 190, 180, 24);
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                Launcher.this.textFieldTextChange(evt);
            }
        });
        this.jPanel1.add(this.textField);
        this.textField.setBounds(10, 290, 570, 20);
        this.labelLanguage.setText("Language");
        this.jPanel1.add(this.labelLanguage);
        this.labelLanguage.setBounds(120, 330, 120, 16);
        this.languageComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Launcher.this.languageComboBoxActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.languageComboBox);
        this.languageComboBox.setBounds(270, 330, 120, 25);
        this.labelCredits.setEditable(false);
        this.labelCredits.setLineWrap(true);
        this.labelCredits.setWrapStyleWord(true);
        this.panelCredits.setViewportView(this.labelCredits);
        this.jPanel1.add(this.panelCredits);
        this.panelCredits.setBounds(30, 70, 500, 160);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(600, 390));
        this.setLocation((screenSize.width - 600) / 2, (screenSize.height - 390) / 2);
    }

    private void languageComboBoxActionPerformed(ActionEvent evt) {
        if (this.languageComboBox.getSelectedItem() == StrConstants.STR_ENGLISH[this.language]) {
            this.language = 0;
            this.setState();
        } else if (this.languageComboBox.getSelectedItem() == StrConstants.STR_SPANISH[this.language]) {
            this.language = 1;
            this.setState();
        } else if (this.languageComboBox.getSelectedItem() == StrConstants.STR_ITALIAN[this.language]) {
            this.language = 2;
            this.setState();
        } else if (this.languageComboBox.getSelectedItem() == StrConstants.STR_GERMAN[this.language]) {
            this.language = 3;
            this.setState();
        } else if (this.languageComboBox.getSelectedItem() == StrConstants.STR_FRENCH[this.language]) {
            this.language = 4;
            this.setState();
        }
    }

    private void textFieldTextChange(KeyEvent evt) {
        if (new String(this.textField.getPassword()).length() > 0) {
            this.buttonNext.setEnabled(true);
        } else {
            this.buttonNext.setEnabled(false);
        }
    }

    private void jRadioButton7ActionPerformed(ActionEvent evt) {
        this.buttonNext.setEnabled(true);
    }

    private void jRadioButton6ActionPerformed(ActionEvent evt) {
        this.buttonNext.setEnabled(true);
    }

    private void jRadioButton5ActionPerformed(ActionEvent evt) {
        this.buttonNext.setEnabled(true);
    }

    private void jRadioButton4ActionPerformed(ActionEvent evt) {
        this.buttonNext.setEnabled(true);
    }

    private void buttonPrevActionPerformed(ActionEvent evt) {
        switch (this.state) {
            case 1: {
                this.state = 0;
                this.setState();
                break;
            }
            case 2: {
                this.state = 1;
                this.setState();
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                this.state = 2;
                this.setState();
            }
        }
    }

    private void buttonNextActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter NETfilter = new ExtensionFileFilter("NET", StrConstants.STR_EXTENSION_NET[this.language]);
        switch (this.state) {
            case 0: {
                chooser.addChoosableFileFilter(NETfilter);
                chooser.setFileFilter(NETfilter);
                int returnVal = chooser.showOpenDialog(this);
                chooser.removeChoosableFileFilter(NETfilter);
                if (returnVal != 0) break;
                try {
                    DataInputStream rulesInput;
                    this.netFile = chooser.getSelectedFile();
                    String netFileString = chooser.getSelectedFile().getPath();
                    if (netFileString.lastIndexOf(System.getProperty("file.separator")) == -1) {
                        throw new NotRulesFileFoundException();
                    }
                    String rulesFileString = netFileString.substring(0, netFileString.lastIndexOf(System.getProperty("file.separator")));
                    rulesFileString = rulesFileString + System.getProperty("file.separator") + "RULES.TXT";
                    this.rulesFile = new File(rulesFileString);
                    DataInputStream netInput = new DataInputStream(new FileInputStream(this.netFile));
                    try {
                        rulesInput = new DataInputStream(new FileInputStream(this.rulesFile));
                    }
                    catch (FileNotFoundException e) {
                        throw new NotRulesFileFoundException();
                    }
                    this.data = new Civ2Data(netInput, rulesInput);
                    this.offer.setData(this.data);
                    this.state = 1;
                }
                catch (FileNotFoundException e) {
                    JOptionPane.showMessageDialog(null, StrConstants.STR_FILE_NOT_FOUND_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                    this.state = 0;
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, StrConstants.STR_IO_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                    this.state = 0;
                }
                catch (NotNetFormatException e) {
                    JOptionPane.showMessageDialog(null, StrConstants.STR_NO_NET_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                    this.state = 0;
                }
                catch (NotRulesFileFoundException e) {
                    JOptionPane.showMessageDialog(null, StrConstants.STR_RULES_NOT_FOUND_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                    this.state = 0;
                }
                catch (NotRulesFormatException e) {
                    JOptionPane.showMessageDialog(null, StrConstants.STR_RULES_BAD_FORMAT_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                    this.state = 0;
                }
                this.setState();
                break;
            }
            case 1: {
                int i = 0;
                while (i < 7) {
                    if (this.jRadioButtonArray[i].isSelected()) {
                        this.offer.setCivDemmander(this.matching[i]);
                        this.civSelected = this.matching[i];
                    }
                    ++i;
                }
                this.state = 2;
                this.setState();
                break;
            }
            case 2: {
                if (!this.data.isPasswordProtected(this.civSelected)) {
                    if (this.jRadioButton1.isSelected()) {
                        if (this.action == 1) {
                            this.firstPassword = true;
                            this.state = 3;
                        }
                    } else {
                        JOptionPane.showMessageDialog(null, StrConstants.STR_NO_DIP_WITHOUT_PASSWORD[this.language], StrConstants.STR_ERROR[this.language], 0);
                        this.state = 1;
                    }
                } else {
                    this.state = 3;
                }
                this.setState();
                break;
            }
            case 3: {
                this.tempPassword = new String(this.textField.getPassword());
                if (this.action == 1 && this.firstPassword) {
                    this.state = 4;
                } else {
                    try {
                        if (!this.data.equalPassword(this.civSelected, this.tempPassword)) {
                            JOptionPane.showMessageDialog(null, StrConstants.STR_PASSWORD_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                            this.state = 3;
                        } else {
                            switch (this.action) {
                                case 1: {
                                    this.state = 4;
                                    break;
                                }
                                case 2: {
                                    this.state = 7;
                                    break;
                                }
                                case 3: {
                                    this.state = 6;
                                }
                            }
                        }
                    }
                    catch (NotPasswordProtectedException e) {
                        JOptionPane.showMessageDialog(null, StrConstants.STR_INTERNAL_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                        this.state = 2;
                    }
                }
                this.setState();
                break;
            }
            case 4: {
                String tempPassword2 = new String(this.textField.getPassword());
                if (this.firstPassword && !tempPassword2.equals(this.tempPassword)) {
                    JOptionPane.showMessageDialog(null, StrConstants.STR_NOT_MATCH_PASSWORD[this.language], StrConstants.STR_ERROR[this.language], 0);
                } else {
                    this.data.setPassword(this.civSelected, tempPassword2);
                    try {
                        this.data.writeExternal(new DataOutputStream(new FileOutputStream(this.netFile)));
                    }
                    catch (FileNotFoundException e) {
                        JOptionPane.showMessageDialog(null, StrConstants.STR_FILE_NOT_FOUND_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                        this.state = 0;
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(null, StrConstants.STR_IO_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                        this.state = 0;
                    }
                    this.firstPassword = false;
                    this.showDone();
                }
                this.state = 2;
                this.setState();
                break;
            }
            case 7: {
                int i = 0;
                while (i < 7 && !this.jRadioButtonArray[i].isSelected()) {
                    ++i;
                }
                this.offer.setCivTributer(this.matching[i]);
                this.state = 5;
                this.setState();
            }
        }
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        if (this.state == 2) {
            this.action = 3;
        }
        this.buttonNext.setEnabled(true);
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        if (this.state == 2) {
            this.action = 2;
        }
        this.buttonNext.setEnabled(true);
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        if (this.state == 2) {
            this.action = 1;
        }
        this.buttonNext.setEnabled(true);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private void setState() {
        JFileChooser chooser = new JFileChooser();
        ExtensionFileFilter DATfilter = new ExtensionFileFilter("DAT", StrConstants.STR_EXTENSION_DAT[this.language]);
        DiplomaticDialog dialog = new DiplomaticDialog((Frame)this, true);
        MapCityDialog dialog2 = new MapCityDialog((Frame)this, true);
        OfferDialog dialogOffer = new OfferDialog((Frame)this, true);
        switch (this.state) {
            case 0: {
                this.hideAll();
                this.label.setVisible(true);
                this.label.setText(StrConstants.STR_WELCOME[this.language]);
                break;
            }
            case 1: {
                this.hideAll();
                this.label.setVisible(true);
                this.label.setText(StrConstants.STR_SELECT_LEADER_NAME[this.language]);
                this.names = this.data.getNameLeader();
                int j = 0;
                int i = 0;
                while (i < this.names.length) {
                    if (this.names[i].length() > 0) {
                        this.jRadioButtonArray[j].setText(this.names[i] + " (" + this.data.getTribe(i).getNameTribe() + ")");
                        this.jRadioButtonArray[j].setVisible(true);
                        this.jRadioButtonArray[j].setEnabled(true);
                        this.matching[j] = i;
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                this.hideAll();
                this.label.setText(StrConstants.STR_WELCOME_LEADER[this.language] + this.names[this.civSelected]);
                this.label.setVisible(true);
                this.jRadioButton1.setVisible(true);
                this.jRadioButton2.setVisible(true);
                this.jRadioButton3.setVisible(true);
                this.jRadioButton1.setText(StrConstants.STR_SET_PASSWORD[this.language]);
                this.jRadioButton2.setText(StrConstants.STR_MAKE_BARTER[this.language]);
                this.jRadioButton3.setText(StrConstants.STR_VIEW_BARTER[this.language]);
                break;
            }
            case 3: {
                this.hideAll();
                if (this.firstPassword) {
                    this.label.setText(StrConstants.STR_FIRST_PASSWORD[this.language]);
                } else {
                    this.label.setText(StrConstants.STR_PASSWORD[this.language]);
                }
                this.label.setVisible(true);
                this.textField.setVisible(true);
                this.textField.setEditable(true);
                this.textField.setText("");
                break;
            }
            case 4: {
                this.hideAll();
                if (this.firstPassword) {
                    this.label.setText(StrConstants.STR_CONFIRM_PASSWORD[this.language]);
                } else {
                    this.label.setText(StrConstants.STR_FIRST_PASSWORD[this.language]);
                }
                this.label.setVisible(true);
                this.textField.setVisible(true);
                this.textField.setEditable(true);
                this.textField.setText("");
                break;
            }
            case 7: {
                this.hideAll();
                this.label.setText(StrConstants.STR_OPPOSITE_LEADER[this.language]);
                this.label.setVisible(true);
                int j = 0;
                boolean[] temp = this.data.getTribe(this.civSelected).getContacts();
                int i = 0;
                while (i < temp.length) {
                    if (temp[i] && this.names[i].length() > 0 && i != this.civSelected) {
                        this.matching[j] = i;
                        this.jRadioButtonArray[j].setText(this.names[i] + " (" + this.data.getTribe(i).getNameTribe() + ")");
                        this.jRadioButtonArray[j].setVisible(true);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 5: {
                try {
                    if (dialog.show(this.offer, this.data, this.language) && dialog2.show(this.offer, this.data, this.language)) {
                        chooser.setSelectedFile(new File(this.data.getTribe(this.offer.getCivDemmander()).getNameTribe() + this.data.getTurnNumberPrintable()));
                        chooser.addChoosableFileFilter(DATfilter);
                        chooser.setFileFilter(DATfilter);
                        if (chooser.showSaveDialog(this) == 0) {
                            if (this.offer.getTechTributerDemmander() != null) {
                                Technology[] tech = this.offer.getTechTributerDemmander();
                                int i = 0;
                                while (i < tech.length) {
                                    if (Rules.isGovernment(tech[i]) && JOptionPane.showConfirmDialog(null, StrConstants.STR_DO_YOU_WANT_A_REVOLUTION_WHEN_ACCEPT[this.language], StrConstants.STR_REVOLUTION[this.language], 0) == 0) {
                                        this.offer.setDemmanderRevolution();
                                    }
                                    ++i;
                                }
                            }
                            FileOutputStream f = new FileOutputStream(chooser.getSelectedFile());
                            f.getChannel().truncate(0L);
                            ObjectOutputStream p = new ObjectOutputStream(f);
                            this.offer.setTurnGame(this.data.getTurnNumber());
                            this.offer.setSignature(this.data.getSignature());
                            this.offer.setGoldDemmander(this.data.getTribe(this.offer.getCivDemmander()).getMoney());
                            this.offer.setGoldTributer(this.data.getTribe(this.offer.getCivTributer()).getMoney());
                            this.offer.writeExternal(p);
                            this.showDone();
                        }
                        chooser.removeChoosableFileFilter(DATfilter);
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(null, StrConstants.STR_IO_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                }
                catch (SecurityException e) {
                    JOptionPane.showMessageDialog(null, StrConstants.STR_SECURITY_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                }
                this.state = 2;
                this.setState();
                break;
            }
            case 6: {
                if (chooser.showOpenDialog(this) == 0) {
                    try {
                        ObjectInputStream p = new ObjectInputStream(new FileInputStream(chooser.getSelectedFile()));
                        Offer offer = new Offer();
                        offer.setData(this.data);
                        offer.readExternal(p);
                        if (offer.getCivTributer() != this.civSelected) {
                            JOptionPane.showMessageDialog(null, StrConstants.STR_NOT_FOR_YOU[this.language], StrConstants.STR_ERROR[this.language], 0);
                        } else if (!offer.checkOffer()) {
                            JOptionPane.showMessageDialog(null, offer.getErrorMessage(this.language), StrConstants.STR_ERROR[this.language], 0);
                        } else if (dialogOffer.show(offer, this.data, this.language, true)) {
                            if (offer.getTechDemmanderTributer() != null) {
                                Technology[] tech = offer.getTechDemmanderTributer();
                                int i = 0;
                                while (i < tech.length) {
                                    if (Rules.isGovernment(tech[i]) && JOptionPane.showConfirmDialog(null, StrConstants.STR_DO_YOU_WANT_A_REVOLUTION[this.language], StrConstants.STR_REVOLUTION[this.language], 0) == 0) {
                                        offer.setTributerRevolution();
                                    }
                                    ++i;
                                }
                            }
                            this.data.setOffer(offer);
                            this.data.writeExternal(new DataOutputStream(new FileOutputStream(this.netFile)));
                            this.showDone();
                        }
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(null, StrConstants.STR_IO_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                    }
                    catch (ClassNotFoundException e) {
                        JOptionPane.showMessageDialog(null, StrConstants.STR_IO_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                    }
                    catch (SecurityException e) {
                        JOptionPane.showMessageDialog(null, StrConstants.STR_SECURITY_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                    }
                    catch (NotOfferCheckedException e) {
                        JOptionPane.showMessageDialog(null, StrConstants.STR_NOT_GOOD_OFFER_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                    }
                    catch (ClassCastException e) {
                        JOptionPane.showMessageDialog(null, StrConstants.STR_IO_ERROR[this.language], StrConstants.STR_ERROR[this.language], 0);
                    }
                }
                this.state = 2;
                this.setState();
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new Launcher().show();
    }

    static {
        INIT_STATE = 0;
        SELECTED_FILE = 1;
        SELECTED_CIV = 2;
        INTRO_PASSWORD = 3;
        RE_INTRO_PASSWORD = 4;
        MAKE_OFFER = 5;
        VIEW_OFFER = 6;
        SELECT_TRIBUTER_CIV = 7;
        NO_ACTION = 0;
        SET_PASSWORD_ACTION = 1;
        MAKE_BARTER_ACTION = 2;
        VIEW_BARTER_ACTION = 3;
    }
}

