/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jmkirschberg.games.civ2.City;
import jmkirschberg.games.civ2.Civ2Data;
import jmkirschberg.games.civ2.Offer;
import jmkirschberg.games.civ2.StrConstants;
import jmkirschberg.games.civ2.Technology;

public class OfferDialog
extends JDialog {
    private Civ2Data data;
    private Offer offer;
    private int language = 0;
    private boolean buttonOkPushed;
    private boolean twoButtons = false;
    private JLabel label;
    private JScrollPane jScrollPane1;
    private JTextArea textOffer;
    private JButton buttonOk;
    private JButton buttonCancel;

    public OfferDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textOffer = new JTextArea();
        this.label = new JLabel();
        this.buttonCancel = new JButton();
        this.buttonOk = new JButton();
        this.getContentPane().setLayout(null);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                OfferDialog.this.closeDialog(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.textOffer);
        this.getContentPane().add(this.jScrollPane1);
        this.jScrollPane1.setBounds(0, 30, 420, 250);
        this.label.setText("jLabel1");
        this.getContentPane().add(this.label);
        this.label.setBounds(60, 10, 170, 16);
        this.buttonCancel.setText("jButton1");
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OfferDialog.this.buttonCancelActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.buttonCancel);
        this.buttonCancel.setBounds(20, 300, 81, 26);
        this.buttonOk.setText("jButton1");
        this.buttonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OfferDialog.this.buttonOkActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.buttonOk);
        this.buttonOk.setBounds(330, 300, 81, 26);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(420, 360));
        this.setLocation((screenSize.width - 420) / 2, (screenSize.height - 360) / 2);
    }

    private void buttonCancelActionPerformed(ActionEvent evt) {
        this.buttonOkPushed = false;
        this.setVisible(false);
        this.dispose();
    }

    private void buttonOkActionPerformed(ActionEvent evt) {
        this.buttonOkPushed = true;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public boolean show(Offer o, Civ2Data data, int lang, boolean twoButtons) {
        this.offer = o;
        this.data = data;
        this.language = lang;
        this.twoButtons = twoButtons;
        this.inizialite();
        super.show();
        return this.buttonOkPushed;
    }

    private void inizialite() {
        City[] citiesTributerDemmander;
        City[] citiesDemmanderTributer;
        this.buttonOk.setText(StrConstants.STR_BUTTON_OK[this.language]);
        if (this.twoButtons) {
            this.buttonCancel.setText(StrConstants.STR_BUTTON_CANCEL[this.language]);
        }
        this.label.setText(StrConstants.STR_DO_YOU_ACCEPT[this.language]);
        String text = this.data.getNameLeader()[this.offer.getCivDemmander()] + StrConstants.STR_OFFER_YOU[this.language];
        text = text + this.offer.getGoldDemmanderTributer() + StrConstants.STR_GOLD[this.language] + StrConstants.STR_NEW_LINE;
        if (this.offer.getPeace()) {
            text = text + StrConstants.STR_PEACE_TEATRY[this.language] + StrConstants.STR_NEW_LINE;
        } else if (this.offer.getAlliance()) {
            text = text + StrConstants.STR_ALLIANCE_TEATRY[this.language] + StrConstants.STR_NEW_LINE;
        } else if (this.offer.getCeaseFire()) {
            text = text + StrConstants.STR_CEASE_FIRE_TEATRY[this.language] + StrConstants.STR_NEW_LINE;
        }
        Technology[] techDemmanderTributer = this.offer.getTechDemmanderTributer();
        if (techDemmanderTributer != null) {
            int i = 0;
            while (i < techDemmanderTributer.length) {
                text = text + StrConstants.STR_SECRET_OF[this.language];
                text = text + techDemmanderTributer[i].getName();
                text = text + StrConstants.STR_NEW_LINE;
                ++i;
            }
        }
        if ((citiesDemmanderTributer = this.offer.getCitiesDemmanderTributer()) != null) {
            int i = 0;
            while (i < citiesDemmanderTributer.length) {
                text = text + StrConstants.STR_CITY_OF[this.language];
                text = text + citiesDemmanderTributer[i].getName();
                text = text + StrConstants.STR_NEW_LINE;
                ++i;
            }
        }
        if (this.offer.getTerrainMapDemmanderTributer()) {
            text = text + StrConstants.STR_HIS_TERRAIN_MAP[this.language] + StrConstants.STR_NEW_LINE;
        }
        if (this.offer.getCitiesMapDemmanderTributer()) {
            text = text + StrConstants.STR_HIS_CITIES_MAP[this.language] + StrConstants.STR_NEW_LINE;
        }
        if (this.offer.getUnitsMapDemmanderTributer()) {
            text = text + StrConstants.STR_HIS_UNITS_MAP[this.language] + StrConstants.STR_NEW_LINE;
        }
        if (this.offer.getAllMapDemmanderTributer()) {
            text = text + StrConstants.STR_HIS_ALL_MAP[this.language] + StrConstants.STR_NEW_LINE;
        }
        boolean[] foreignsMapDemmanderTributer = this.offer.getForeignsMapDemmanderTributer();
        int i = 0;
        while (i < foreignsMapDemmanderTributer.length) {
            if (foreignsMapDemmanderTributer[i]) {
                text = text + StrConstants.STR_HIS_FOREIGN_MAP[this.language] + this.data.getTribe(i).getNameTribe() + StrConstants.STR_NEW_LINE;
            }
            ++i;
        }
        text = text + StrConstants.STR_DEMMAND[this.language];
        text = text + StrConstants.STR_GREAT_LEADER[this.language] + this.data.getNameLeader()[this.offer.getCivTributer()] + StrConstants.STR_NEW_LINE;
        text = text + this.offer.getGoldTributerDemmander() + StrConstants.STR_GOLD[this.language] + StrConstants.STR_NEW_LINE;
        Technology[] techTributerDemmander = this.offer.getTechTributerDemmander();
        if (techTributerDemmander != null) {
            int i2 = 0;
            while (i2 < techTributerDemmander.length) {
                text = text + StrConstants.STR_SECRET_OF[this.language] + techTributerDemmander[i2].getName() + StrConstants.STR_NEW_LINE;
                ++i2;
            }
        }
        if ((citiesTributerDemmander = this.offer.getCitiesTributerDemmander()) != null) {
            int i3 = 0;
            while (i3 < citiesTributerDemmander.length) {
                text = text + StrConstants.STR_CITY_OF[this.language];
                text = text + citiesTributerDemmander[i3].getName();
                text = text + StrConstants.STR_NEW_LINE;
                ++i3;
            }
        }
        if (this.offer.getTerrainMapTributerDemmander()) {
            text = text + StrConstants.STR_YOUR_TERRAIN_MAP[this.language] + StrConstants.STR_NEW_LINE;
        }
        if (this.offer.getCitiesMapTributerDemmander()) {
            text = text + StrConstants.STR_YOUR_CITIES_MAP[this.language] + StrConstants.STR_NEW_LINE;
        }
        if (this.offer.getUnitsMapTributerDemmander()) {
            text = text + StrConstants.STR_YOUR_UNITS_MAP[this.language] + StrConstants.STR_NEW_LINE;
        }
        if (this.offer.getAllMapTributerDemmander()) {
            text = text + StrConstants.STR_YOUR_ALL_MAP[this.language] + StrConstants.STR_NEW_LINE;
        }
        boolean[] foreignsMapTributerDemmander = this.offer.getForeignsMapTributerDemmander();
        int i4 = 0;
        while (i4 < foreignsMapTributerDemmander.length) {
            if (foreignsMapTributerDemmander[i4]) {
                text = text + StrConstants.STR_YOUR_FOREIGN_MAP[this.language] + this.data.getTribe(i4).getNameTribe() + StrConstants.STR_NEW_LINE;
            }
            ++i4;
        }
        this.textOffer.setText(text);
    }

    public static void main(String[] args) {
        new OfferDialog((Frame)new JFrame(), true).show();
    }
}

