Attribute VB_Name = "RunMain"
Option Explicit

Declare Function GetShortPathName Lib _
    "kernel32" Alias "GetShortPathNameA" _
    (ByVal lpszLongPath As String, ByVal lpszShortPath As String, _
    ByVal cchBuffer As Long) As Long

Sub Main()
    Dim FileName As String, Dots() As String, Extension As String, _
    Maps() As String, Scns() As String, Savs() As String, _
    Note As String, Menu As String, Civ2 As String, _
    Number As String, Title As String, _
    Pause As Single, i As Integer, ID As Double

    FileName = Replace(Command, """", Empty)
    FileName = GetShortPath(FileName)

    If FileName = Empty Then
        MsgBox "File not found", vbExclamation
        End
    End If
    
    Dots = Split(FileName, ".")
    Extension = Dots(UBound(Dots))

    Maps = Split(LoadResString(101), "|")
    Scns = Split(LoadResString(102), "|")
    Savs = Split(LoadResString(103), "|")
    
    'It's OK if the CD notice doesn't exist. Set the variable to empty
    On Error Resume Next
        Note = LoadResString(104)
        If Err.Number <> 0 Then Note = Empty
    On Error GoTo 0
    
    Menu = LoadResString(105)
    Civ2 = LoadResString(106)

    If InStr(LCase(Maps(2)), "*." & LCase(Extension) & ";") > 0 Then
        For i = 1 To CInt(Maps(0)) - 1
            Number = Number & "{DOWN}"
        Next
        Title = Maps(1)
    ElseIf InStr(LCase(Scns(2)), "*." & LCase(Extension) & ";") > 0 Then
        For i = 1 To CInt(Scns(0)) - 1
            Number = Number & "{DOWN}"
        Next
        Title = Scns(1)
    ElseIf InStr(LCase(Savs(2)), "*." & LCase(Extension) & ";") > 0 Then
        For i = 1 To CInt(Savs(0)) - 1
            Number = Number & "{DOWN}"
        Next
        Title = Savs(1)
    Else
        MsgBox "File format not supported", vbExclamation
        End
    End If

    'replace SendKeys special characters
    FileName = Replace(Replace(FileName, "{", "<"), "}", ">")
    FileName = Replace(Replace(FileName, "(", "{(}"), ")", "{)}")
    FileName = Replace(Replace(Replace(FileName, "%", "{%}"), "^", "{^}"), "~", "{~}")
    FileName = Replace(Replace(FileName, "<", "{{}"), ">", "{}}")
    
    ChDrive Civ2
    ChDir Civ2 & "\..\"
        
    ID = Shell(Civ2)
    
    Pause = (Timer + 4) Mod 86400
    While Pause > Timer
        DoEvents
    Wend

    If Note <> Empty Then
       AppActivate Note
       SendKeys "~", True
    
       Pause = (Timer + 1) Mod 86400
       While Pause > Timer
           DoEvents
       Wend
    End If
 
    'abort the intro movie (doesn't do anything interesting when there's no movie)
    SendKeys " ", True
    
    AppActivate Menu
    SendKeys "{TAB}" & Number & "~", True
    
    Pause = (Timer + 1) Mod 86400
    While Pause > Timer
        DoEvents
    Wend

    AppActivate Title
    SendKeys "%n" & FileName & "~", True
    
    AppActivate ID
End Sub

Function GetShortPath(File As String) As String
    Dim Length As Long

    Length = GetShortPathName(File, File, 256)
    GetShortPath = Left(File, Length)
End Function
