/*************************************************************************************************************
SCENARIO NAME: LazyCSPL
VERSION: V1.0
DATE: 25/05/2003
AUTHOR: Angelo Scotto
E-MAIL: scotto_a@hotmail.com
MISC: A program inspired by Xin Yu's LazyCiv to allow PBEM on ToT
*************************************************************************************************************/

#include "cspl.h"
#include "lazycspl.h"
#include <stdlib.h> //Useful to import itoa standard C function : it converts numbers in strings allowing
					//the programmer to show Civ data in a messagebox
#include <stdio.h>
/*************************************************************************************************************
THREAD CONTROL ROUTINES : PLACE YOUR CODE IN THE FOLLOWING FUNCTIONS
*************************************************************************************************************/

/*
SaveProduction: Save the production queue
*/
void SaveProduction()
{
City Temp;

byte Owner=GetCurrentCiv();

while(ReadNextCity(&Temp))
 {
 //StoringProduction of Non-Human Civs
   if (Temp.Owner!=Owner)
   {
	Temp.Name[12]=NULL;
    Temp.Name[15]=Temp.ItemProduction;
    memcpy(&(Temp.Name[13]),&(Temp.Production),2);
	ReWriteCity(Temp,Temp.ID);
   }
 }
ResetCity();
MessageCSPL("Production Saved");
}

/*
LoadProduction: ReLoad the production queue
*/
void LoadProduction()
{
City Temp;

byte Owner=GetCurrentCiv();

while(ReadNextCity(&Temp))
 {
 //ReLoadingProduction
   if (Temp.Owner!=Owner)
   {
    Temp.ItemProduction=Temp.Name[15];
    memcpy(&(Temp.Production),&(Temp.Name[13]),2);
	ReWriteCity(Temp,Temp.ID);
   }
 }
ResetCity();
MessageCSPL("Production Loaded");
}


void UnitCheck(Unit Temp)
{
//Place your code for Unit Thread here
}
void CityCheck(City Temp)
{
//Place your code for City Thread here
}
void WonderCheck()
{
//Place your code for Wonder Thread here
}
void MapCheck()
{
//Place your code for Map Thread here
}
void GlbCheck(Global Global1)
{
//Place your code for Global Thread here
}
void CivCheck(Civ Prova)
{
//Place your code for Civ Thread here
}
void AttackCheck(Unit* Attacker,Unit* Attacked,BOOL Winner)
{
//Place your code for Attack Thread here
}
void KeyboardCheck(char keypressed)
{
if (keypressed=='l' || keypressed=='L') LoadProduction();
else if (keypressed=='s' || keypressed=='S') SaveProduction();
}

/*************************************************************************************************************
CSPL CLIENT TEMPLATE : DON'T TOUCH THIS
*************************************************************************************************************/
int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPTSTR lpCmdLine,int nCmdShow)
{MainInstance=hInstance;

static char szAppName [] = "CSPL";
MSG msg;
HWND hWnd;
WNDCLASS wndclass;

	wndclass.style=CS_HREDRAW|CS_VREDRAW;
	wndclass.lpfnWndProc=WndProc;
	wndclass.cbClsExtra=0;
	wndclass.cbWndExtra=0;
	wndclass.hInstance=MainInstance;
	wndclass.hCursor=LoadCursor(NULL,IDC_ARROW);
	wndclass.hIcon=LoadIcon(MainInstance,MAKEINTRESOURCE(IDCSPL));
	wndclass.lpszMenuName=MAKEINTRESOURCE(IDR_MENU1);
	wndclass.hbrBackground=(HBRUSH
	)GetStockObject(LTGRAY_BRUSH);
	wndclass.lpszClassName=szAppName;

	if (!RegisterClass (&wndclass))
		return FALSE;

	hWnd=CreateWindowEx(WS_EX_TOPMOST,szAppName,TitleCSPL,WS_CAPTION|WS_SYSMENU,XWindow,YWindow,Width,Height,NULL,NULL,MainInstance,NULL);

	if (!hWnd) return FALSE;

	ShowWindow(hWnd,nCmdShow);
	UpdateWindow(hWnd);

	InitializeCSPL();

while (GetMessage(&msg,NULL,0,0))
{TranslateMessage(&msg);
DispatchMessage(&msg);
}	
return (msg.wParam);

}

LRESULT CALLBACK WndProc(HWND hWnd,UINT imessage, WPARAM wParam,LPARAM lParam)
{switch (imessage)
	{case WM_CLOSE:
	{DestroyWindow(hWnd);return 0;break;}
	case WM_COMMAND:
		switch(LOWORD(wParam)){
		case ID_MAIN_EXIT: {DestroyWindow(hWnd);return 0;break;}
		case ID_MAIN_ABOUT: AboutBox();return 1;break;
		case ID_MAIN_ABOUTSCN: AboutScn();return 1;break;
		}return DefWindowProc(hWnd,imessage,wParam,lParam);break;
	case WM_CHAR:
		if (wParam=='x') {DestroyWindow(hWnd);return 0;break;}
			else {KeyboardCheck(wParam);return 0;break;}
	case WM_DESTROY:
		CloseHandle(Process);ExitProcess(0);return 0;break;
	default:return DefWindowProc(hWnd,imessage,wParam,lParam);break;
	}
}


BOOL MessageCSPL(LPCSTR Testo)
{
	char Text[50];
	MSGBOXPARAMS MBP;
	sprintf(Text,"CSPL Version %i,%i",CSPLVersion,CSPLRelease);

    MBP.cbSize=sizeof(MSGBOXPARAMS);
    MBP.hwndOwner=NULL; 
    MBP.hInstance=MainInstance; 
    MBP.lpszText=Testo; 
    MBP.lpszCaption=Text; 
    MBP.dwStyle=MB_USERICON | MB_OK; 
    MBP.lpszIcon=MAKEINTRESOURCE(IDCSPL); 
    MBP.dwContextHelpId=NULL;
    MBP.lpfnMsgBoxCallback=NULL; 
    MBP.dwLanguageId=MAKELANGID(LANG_NEUTRAL,SUBLANG_SYS_DEFAULT);

return	MessageBoxIndirect(&MBP);

}

int RequestCSPL(LPCSTR Testo)
{

	char Text[50];
	MSGBOXPARAMS MBP;
	sprintf(Text,"CSPL Version %i,%i",CSPLVersion,CSPLRelease);
	
    MBP.cbSize=sizeof(MSGBOXPARAMS);
    MBP.hwndOwner=NULL; 
    MBP.hInstance=MainInstance; 
    MBP.lpszText=Testo; 
    MBP.lpszCaption=Text; 
    MBP.dwStyle=MB_USERICON | MB_YESNO; 
    MBP.lpszIcon=MAKEINTRESOURCE(IDCSPL); 
    MBP.dwContextHelpId=NULL;
    MBP.lpfnMsgBoxCallback=NULL; 
    MBP.dwLanguageId=MAKELANGID(LANG_NEUTRAL,SUBLANG_SYS_DEFAULT);

return	MessageBoxIndirect(&MBP);

}
void AboutBox()
{

	char Text[200];
	MSGBOXPARAMS MBP;
	sprintf(Text,"Civilization Scenario Programming Library\n\nVersion %i.%i\nby Angelo Scotto\ne-mail:scotto_a@hotmail.com\nCopyright (C) 2001",CSPLVersion,CSPLRelease);

    MBP.cbSize=sizeof(MSGBOXPARAMS);
    MBP.hwndOwner=NULL; 
    MBP.hInstance=MainInstance; 
    MBP.lpszText=Text; 
    MBP.lpszCaption="About CSPL"; 
    MBP.dwStyle=MB_USERICON | MB_OK; 
    MBP.lpszIcon=MAKEINTRESOURCE(IDCSPL); 
    MBP.dwContextHelpId=NULL;
    MBP.lpfnMsgBoxCallback=NULL; 
    MBP.dwLanguageId=MAKELANGID(LANG_NEUTRAL,SUBLANG_SYS_DEFAULT);

	MessageBoxIndirect(&MBP);
}

void AboutScn()
{
	MSGBOXPARAMS MBP;

    MBP.cbSize=sizeof(MSGBOXPARAMS);
    MBP.hwndOwner=NULL; 
    MBP.hInstance=MainInstance; 
    MBP.lpszText=AuthorString;
    MBP.lpszCaption="About Scenario"; 
    MBP.dwStyle=MB_USERICON | MB_OK; 
    MBP.lpszIcon=MAKEINTRESOURCE(IDCSPL); 
    MBP.dwContextHelpId=NULL;
    MBP.lpfnMsgBoxCallback=NULL; 
    MBP.dwLanguageId=MAKELANGID(LANG_NEUTRAL,SUBLANG_SYS_DEFAULT);

	MessageBoxIndirect(&MBP);
}

