unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ActnList, Menus, ExtCtrls, StdCtrls, Buttons, Spin;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    ActionList1: TActionList;
    aFileNew: TAction;
    aFileSave: TAction;
    aFileExit: TAction;
    File1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    Save1: TMenuItem;
    New1: TMenuItem;
    aGenMap: TAction;
    Help1: TMenuItem;
    About1: TMenuItem;
    aHelpAbout: TAction;
    ScrollBox1: TScrollBox;
    pbMap: TPaintBox;
    sdMap: TSaveDialog;
    btnGenerate: TBitBtn;
    aNormalize: TAction;
    BitBtn1: TBitBtn;
    seNumSeeds: TSpinEdit;
    seMapHeight: TSpinEdit;
    seRand: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Zoom1: TMenuItem;
    Increase1: TMenuItem;
    Decrease1: TMenuItem;
    aZoomIn: TAction;
    aZoomOut: TAction;
    rgMethode: TRadioGroup;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure aFileNewExecute(Sender: TObject);
    procedure aFileSaveExecute(Sender: TObject);
    procedure aFileExitExecute(Sender: TObject);
    procedure aGenMapExecute(Sender: TObject);
    procedure aHelpAboutExecute(Sender: TObject);
    procedure aNormalizeExecute(Sender: TObject);
    procedure pbMapPaint(Sender: TObject);
    procedure aZoomInExecute(Sender: TObject);
    procedure aZoomOutExecute(Sender: TObject);
    procedure seNumSeedsChange(Sender: TObject);
    procedure seMapHeightChange(Sender: TObject);
    procedure seRandChange(Sender: TObject);
  private    { Private declarations }
    procedure CreateIt;
    procedure DestroyIt;
    procedure NewMap;
    procedure SaveMap;
    procedure CloseDown;
    procedure GenerateMap;
    procedure ShowAboutBox;
    procedure NormalizeMap;
    procedure StarNormalizePoint(X,Y:Integer);
    procedure CircleNormalizePoint(X,Y:Integer);
    procedure PaintMap;
    procedure UpdateMapImg;
    procedure ZoomIn;
    procedure ZoomOut;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses AboutUnit;

var
  MaxX      : Integer =  99;
  MaxY      : Integer =  99;
  MapHeight : Integer =  64;
  Rand      : Integer =   1;
  ZoomFact  : Integer =   4;
  NumSeeds  : Integer = 100;
  Datum     : Cardinal;
  MapBitMap:TBitMap;
  Map: array[0..99,0..99] of Cardinal;

  SeedList  : array [0..1000] of TPoint;
{$R *.DFM}

procedure TMainForm.CreateIt;
begin
  MapBitMap:=TBitmap.Create;
  NewMap;
end;{CreateIt}

procedure TMainForm.DestroyIt;
begin
  MapBitMap.Free;
end;{DestroyIt}

procedure TMainForm.NewMap;
var
  X,Y:Cardinal;
begin
  Datum := MapHeight div 2;
  MapBitMap.Width  := 100;
  MapBitMap.Height := 100;
  for x:=0 to MaxX do
    for y:=0 to MaxY do
     Map[x,y]:= Datum;

  UpdateMapImg;
end;{NewMap}

procedure TMainForm.SaveMap;
begin
  if sdMap.Execute then MapBitMap.SaveToFile(sdMap.FileName);
end;{SaveMap}

procedure TMainForm.CloseDown;
begin
  Close;
end;{CloseDown}

procedure TMainForm.GenerateMap;
var
  N:Integer; // Number of peaks
  X,Y:Cardinal;
begin
  NewMap;
  N:=0;
  Randomize;
  while N < NumSeeds do // Create the peaks
  begin
    X:=Random(MaxX);
    Y:=Random(MaxY);
    if Map[X,Y] = Datum then
    begin
      Map[X,Y] := Random(MapHeight-1);
      SeedList[N].X:=X;
      SeedList[N].Y:=Y;
      Inc(N);
    end;{}
  end;{}
  UpdateMapImg;
end;{GenerateMap}

procedure TMainForm.ShowAboutBox;
begin
  AboutForm.ShowModal;
end;{ShowAboutBox}

procedure TMainForm.NormalizeMap;
var
  N,X,Y:Integer;
  IsSeed:Boolean;
begin
  for X:=0 to (MaxX) do
    for Y:=0 to (MaxY) do
      begin
        IsSeed:=False;
        for N:=0 to NumSeeds do
          if (X = SeedList[N].X) and (Y = SeedList[N].Y) then IsSeed:=True;
        if Not IsSeed then
        case rgMethode.ItemIndex of
          0 : StarNormalizePoint(X,Y);
          1 : CircleNormalizePoint(X,Y);
        end;
      end;{}
  UpdateMapImg;
end;

procedure TMainForm.StarNormalizePoint(X,Y:Integer);
// NewAlt = (Alt * R +AltAdj1 + AltAdj2 + AltAdj3 + AltAdj4) / (R+4)
var
  X1,X2,Y1,Y2:Integer;
  R, M, M0,M2,M4, M5,M7:Cardinal;
  v: real;
begin
  case X of
    0 : X1 := MaxX;
  else
    X1:=X-1;
  end;
  if X = (MaxX) then X2:=0 else X2:= X+1 ;
  case Y of
    0 : Y1 := MaxY;
  else
    Y1:=Y-1;
  end;
  if Y = (MaxY) then Y2:=0 else Y2:= Y+1;
  Randomize;
    M0 := Map[X ,Y ];
    M2 := Map[X1,Y ];
    M4 := Map[X ,Y1];
    M5 := Map[X ,Y2];
    M7 := Map[X2,Y ];
    M:= M2 + M4 + M5 + M7;
//  if M <> 0 then
  begin
    R :=  Random(Rand);
    v  := (R * M0 + M ) div (R + 4);
    Map[X,Y] := trunc(v);
  end;
end;{NormalizePoint}

procedure TMainForm.CircleNormalizePoint(X,Y:Integer);
// NewAlt = (Alt * R +AltAdj1 + AltAdj2 + AltAdj3 + AltAdj4) / (R+4)
var
  X1,X2,Y1,Y2:Integer;
  R, M, M0,M1,M2,M3,M4, M5,M6,M7,M8:Cardinal;
  v: real;
begin
  case X of
    0 : X1 := MaxX;
  else
    X1:=X-1;
  end;
  if X = (MaxX) then X2:=0 else X2:= X+1 ;
  case Y of
    0 : Y1 := MaxY;
  else
    Y1:=Y-1;
  end;
  if Y = (MaxY) then Y2:=0 else Y2:= Y+1;
  Randomize;
    M0 := Map[X ,Y ];
    M1 := Map[X1,Y1];
    M2 := Map[X1,Y ];
    M3 := Map[X1,Y2];
    M4 := Map[X ,Y1];
    M5 := Map[X ,Y2];
    M6 := Map[X2,Y1];
    M7 := Map[X2,Y ];
    M8 := Map[X2,Y2];

    M:= M1 + M2 + M3 + M4 + M5 + M6 + M7 + M8;
//  if M <> 0 then
  begin
    R :=  Random(Rand);
    v  := (R * M0 + M ) div (R + 8);
    Map[X,Y] := trunc(v);
  end;
end;{NormalizePoint}

procedure TMainForm.PaintMap;
begin
  pbMap.Canvas.StretchDraw(pbMap.ClientRect,MapBitMap);
end;{PaintMap}

procedure TMainForm.UpdateMapImg;
var
  Col,C,X,Y:Cardinal;
begin
  C:=  $ff div MapHeight;
//  C:=  $ffffff div MapHeight;
  for x:=0 to MaxX do
    for y:=0 to MaxY do
    begin
      Col := (Map[x,y])*C;
      Col := Col shl 8;
      Col := Col + (Map[x,y])*C;
      Col := Col shl 8;
      Col := Col + (Map[x,y])*C;
      MapBitMap.Canvas.Pixels[x,y]:=Col;
    end;
  pbMap.Invalidate;
end;{PaintMap}

procedure TMainForm.ZoomIn;
begin
  if ZoomFact < 15 then
    Inc(ZoomFact);
  pbMap.SetBounds(0,0,ZoomFact*100,ZoomFact*100);
end;{}

procedure TMainForm.ZoomOut;
begin
  if ZoomFact > 1 then
    Dec(ZoomFact);
  pbMap.SetBounds(0,0,ZoomFact*100,ZoomFact*100);
end;{}

(*****************************************************************************)
(*                                                                           *)
(*  Auto added event handlers                                                *)
(*                                                                           *)
(*****************************************************************************)

procedure TMainForm.FormCreate(Sender: TObject);
begin
  CreateIt;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  DestroyIt;
end;

procedure TMainForm.aFileNewExecute(Sender: TObject);
begin  // Start over
  NewMap;
end;

procedure TMainForm.aFileSaveExecute(Sender: TObject);
begin  // Save the Map as a .bmp
  SaveMap;
end;

procedure TMainForm.aFileExitExecute(Sender: TObject);
begin // Exit the program
  CloseDown;
end;

procedure TMainForm.aGenMapExecute(Sender: TObject);
begin // Generate a map
  GenerateMap;
end;

procedure TMainForm.aHelpAboutExecute(Sender: TObject);
begin // Show the AboutBox
  ShowAboutBox;
end;

procedure TMainForm.aNormalizeExecute(Sender: TObject);
begin
  NormalizeMap;
end;

procedure TMainForm.pbMapPaint(Sender: TObject);
begin
  PaintMap;
end;

procedure TMainForm.aZoomInExecute(Sender: TObject);
begin
  ZoomIn;
end;

procedure TMainForm.aZoomOutExecute(Sender: TObject);
begin
  ZoomOut;
end;

procedure TMainForm.seNumSeedsChange(Sender: TObject);
begin  // Change Seed
  NumSeeds :=  seNumSeeds.Value;
end;

procedure TMainForm.seMapHeightChange(Sender: TObject);
begin  // Change Height
  MapHeight := seMapHeight.Value;
end;

procedure TMainForm.seRandChange(Sender: TObject);
begin
  Rand := seRand.Value;
end;

end.
