/*****************************************************************************/
// tcBitstream.cpp
// Douglas Kane 5 OCT 2001
// foster_fc@yahoo.com
// This file is released to the public domain without restriction. I'd
// appreciate credit if this sees any use. Please post or e-mail me code
// updates for any improvements that are made by others.
//
// tcBitstream class code
/*****************************************************************************/
#include "tcBitstream.h"
#include <stdlib.h>
/******************************************************************************/
tcBitstream::tcBitstream(void) {
   mpFile = NULL;
   mnByte = 0;
   mnBytePos = 0;
}
/******************************************************************************/
// file version of constructor, TODO add other versions
tcBitstream::tcBitstream(FILE *apFile) {
   mpFile = apFile;
   mnByte = 0;
   mnBytePos = 0;
}
/******************************************************************************/
// don't use this constructor
tcBitstream::~tcBitstream() {
}
/******************************************************************************/
// Get returns anCount bits fetched in little endian order.
// anCount must be < 32
// If end-of-stream is encountered, the sign bit is set and partial data is
// returned in the 31 least sig bits.
// Bits are fetched in little endian order, e.g. data 581C produces bitstream
// 0001101000111000. Bits start with the least significant bit in the return
// value, e.g. Get(24) on the above stream returns 0x0C58.
int tcBitstream::Get(unsigned int anCount) {
   unsigned char lnMask;
   unsigned int lnPos = 0;
   unsigned int lnCopyCount;
   unsigned int lnLoopCount = 0;
   int lnRet = 0;

   if (anCount > 31) {
      //printf("Error: tcBitstream Get() count exceeded 31 bits.\n");
	  exit(5);
   }
   
   while (lnLoopCount++ < 10) {
      /* if mnBytePos == 0 then load another byte */
      if (mnBytePos == 0) {
         /* if end-of-stream then set the sign bit */
         if(!fread(&mnByte,1,1,mpFile)) {return (0x8000000 | lnRet);}
         mnBytePos = 8;
      }
      
      /* copy up to min(anCount - lnPos , mnBytePos) from byte to output */
      lnCopyCount = __min(anCount - lnPos, mnBytePos);
      lnMask = ~(0xFF << lnCopyCount);
      lnRet |= (mnByte & lnMask) << lnPos;
      lnPos += lnCopyCount;
      mnByte = mnByte >> lnCopyCount;
      mnBytePos -= lnCopyCount;
      /* if lnPos==anCount then return */
      if (lnPos == anCount) {
         return lnRet;
      }
   }

   //printf("Error: Stuck in bit extraction loop.\n");
   exit(7);
   return 2;
}
/*----------------------------------------------------------------------------*/
// BitReverse reverses bits (anCount-1):0 in anData and returns
// bits from 31:anCount in anData are ignored
// e.g. BitReverse(0x111C,4) = 0x0003, BitReverse(0x111C,8) = 0x0038
unsigned int BitReverse(unsigned int anData, unsigned int anCount) {
   unsigned int lnRet = 0;
   unsigned int i;

   for(i=0;i<anCount;i++) {
      lnRet = lnRet << 1;
      lnRet |= (anData & 0x0001);
      anData = anData >> 1;
   } return lnRet;
}
