// Holds one (1) coordinate
#ifndef CPFH_INCLUDED
class Cord
{
public:
	Cord();
	Cord(int x, int y);
	~Cord();
	void Set(int x, int y);
	const Cord operator=(const Cord);
	long operator==(const Cord);
	long operator!=(const Cord);
	const int GetX() const {return x;}  
	const int GetY() const {return y;}
	
private:
	int x;
	int y;
};

//Holds all data for one (1) civ
class CPFciv
{
public:
	CPFciv();
	~CPFciv();
	void Reset();
	void SetFOWCord(unsigned int, const Cord);
	const Cord GetFOWCord(unsigned int) const;
	void SetID(long newID) {ID=newID;}
	const long GetID() const {return ID;}
	void SetStartPOS(Cord newPOS) {StartPOS=newPOS;}
	void SetStartPOS(int x, int y) {StartPOS.Set(x,y);}
	const Cord GetStartPOS() const {return StartPOS;}
	void SetName(char*);
	const char* GetName() const;
	const CPFciv operator=(const CPFciv);
	const GetNumCords() const {return numCords;}
private:
	Cord *FOWCords;
	char Name[40]; //40 = MaxCivNameLenght
	long ID;
	Cord StartPOS;
	unsigned int numCords;
};


#define CPFH_INCLUDED
#endif