/*****************************************************************************/
// tcDecoder.h
// Douglas Kane 5 OCT 2001
// foster_fc@yahoo.com
// This file is released to the public domain without restriction. I'd
// appreciate credit if this sees any use. Please post or e-mail me code
// updates for any improvements that are made by others.
//
// tcDecoder header -- tcDecoder implements PKWARE Data Compression Library
// decompression as released by Ben Rudiak-Gould (jcxz@hotmail.com) on the
// comp.compression newsgroup.
/*****************************************************************************/
#ifndef _TCDECODER_H_
#define _TCDECODER_H_

#include "tcBitstream.h"

#define MAX_DICTIONARY_SIZE 4096

typedef enum _tokentype {
   LITERAL,
   LENGTH_OFFSET,
   END_OF_STREAM,
   ERROR
} teTokenType;

typedef struct _token {
   teTokenType meType;
   unsigned char mnLiteral;
   unsigned int mnLength;
   unsigned int mnOffset;
} tsToken;

class tcDecoder {
public:
   tcDecoder();
   tcDecoder(tcBitstream *apBitstream);
   ~tcDecoder();

   void tcDecoder::Decode(FILE *lpOutFile);

private:
   tcBitstream *mpBitstream;
   unsigned char mnSizeByte; // second header byte

   // sliding dictionary is implemented as a circular buffer within a
   // statically allocated buffer of MAX_DICTIONARY_SIZE
   unsigned int mnDictionarySize; // determined from second header byte
   unsigned int mnCurrentPos; // current position in dictionary
   unsigned char maDictionary[MAX_DICTIONARY_SIZE];
   void GetNextToken(tsToken *apToken);
   int CalcOffset(unsigned char anHighByte, unsigned int anLowOrderBits);
   int DecodeCopyLength(void);
   int DecodeCopyOffset(unsigned int anLowOrderBits);
};
#endif
