#include <windows.h>
#include <windowsx.h>
#include <commdlg.h>
#include <string.h>

#include <fstream.h>
#include "cpf.h"
#include "sav.h"
#include "decompress.h"


int CountCPF(char* FileName);
int ReadCPF(char* FileName, CPFciv*&);
void RemoveComments(char* String);


int WINAPI WinMain(HINSTANCE hinstance, HINSTANCE hprevinstance, LPSTR lpcmdline, int ncmdshow)
{
	char * tmpdir, *tmpsav=0;
	tmpdir=getenv("TEMP");
	if (tmpdir==NULL)
	{
		tmpdir=getenv("TMP");
	}
	if (tmpdir[strlen(tmpdir)-1]=='\\')
		tmpdir[strlen(tmpdir)-1]='\0';
	CPFciv *CPFcivs=0;

	OPENFILENAME OpenFileName; //Fr Common Dialogs

	char szCPFFile[MAX_PATH] = "\0";
	char szSAVin[MAX_PATH] = "\0";
	char szSAVout[MAX_PATH] = "\0";
	int cmdlen=strlen(lpcmdline);
	char stop='\0';
	int decoding=0;
	int stringnumber=0;
	long flags=0;
	char *tmpDecode;
	if (cmdlen!=0)
		tmpDecode = new char[cmdlen];
	else
		tmpDecode =0;


	int j;
	for (int i=0;i<cmdlen;i++)
	{
		if (!decoding)
		{
			if (lpcmdline[i]=='\"')
			{
				//Read until next "
				stop='\"';
				decoding=1;
				j=0;
			}
			else if (lpcmdline[i]=='/')
			{
				//Read next word
				stop=' ';
				decoding=2;
				j=0;
			}
			else if (lpcmdline[i]!=' ')
			{
				//Read next word
				stop=' ';
				decoding=3;
				j=0;
				tmpDecode[j++]=lpcmdline[i];
			}
		}
		else
		{
			if (lpcmdline[i]==stop || lpcmdline[i]==0)
			{
				//Stop this string
				tmpDecode[j]='\0';
				if (decoding!=2)
				{
					switch (stringnumber)
					{
					case 0:
						strcpy(szSAVin,tmpDecode);
						break;
					case 1:
						strcpy(szCPFFile,tmpDecode);
						break;
					case 2:
						strcpy(szSAVout,tmpDecode);
						break;
					}
					stringnumber++;
				}
				else
				{
					//command
					if (stricmp(tmpDecode,"nodone")==0)
						flags|=1;

				}
				//Store it in the right place
				//MessageBox(NULL,tmpDecode,"Test",MB_OK);
				decoding=0;
			}
			else
			{
				tmpDecode[j++]=lpcmdline[i];
			}
		}
	}		
	delete []tmpDecode;

	if (szSAVin[0]=='\0') //Om inte en sparningsfil skickades frga efter fil
	{
		OpenFileName.lStructSize       = sizeof(OPENFILENAME);
		OpenFileName.hwndOwner         = NULL;
		OpenFileName.hInstance         = hinstance;
		OpenFileName.lpstrFilter       = "SAV-files\0*.SAV\0";
		OpenFileName.lpstrCustomFilter = NULL;
		OpenFileName.nMaxCustFilter    = 0;
		OpenFileName.nFilterIndex      = 1;
		OpenFileName.lpstrFile         = szSAVin;
		OpenFileName.nMaxFile          = sizeof(szSAVin);
		OpenFileName.lpstrFileTitle    = NULL;
		OpenFileName.nMaxFileTitle     = 0;
		OpenFileName.lpstrInitialDir   = NULL;
		OpenFileName.lpstrTitle        = "Select a SAV to load";
		OpenFileName.nFileOffset       = 0;
		OpenFileName.nFileExtension    = 0;
		OpenFileName.lpstrDefExt       = "sav";
		OpenFileName.lCustData         = NULL; 
		OpenFileName.lpfnHook 		   = NULL;
		OpenFileName.lpTemplateName    = "";
		OpenFileName.Flags             = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY ;
		if (!GetOpenFileName(&OpenFileName))
			return FALSE;
	}
	
	if (szCPFFile[0]=='\0') //Om inte en CPFfil skickades frga efter fil
	{

		OpenFileName.lStructSize       = sizeof(OPENFILENAME);
		OpenFileName.hwndOwner         = NULL;
		OpenFileName.hInstance         = hinstance;
		OpenFileName.lpstrFilter       = "CPF-files\0*.CPF\0";
		OpenFileName.lpstrCustomFilter = NULL;
		OpenFileName.nMaxCustFilter    = 0;
		OpenFileName.nFilterIndex      = 1;
		OpenFileName.lpstrFile         = szCPFFile;
		OpenFileName.nMaxFile          = sizeof(szCPFFile);
		OpenFileName.lpstrFileTitle    = NULL;
		OpenFileName.nMaxFileTitle     = 0;
		OpenFileName.lpstrInitialDir   = NULL;
		OpenFileName.lpstrTitle        = "Select a Civ Placement File";
		OpenFileName.nFileOffset       = 0;
		OpenFileName.nFileExtension    = 0;
		OpenFileName.lpstrDefExt       = "cpf";
		OpenFileName.lCustData         = NULL; 
		OpenFileName.lpfnHook 		   = NULL;
		OpenFileName.lpTemplateName    = "";
		OpenFileName.Flags             = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY ;
		if (!GetOpenFileName(&OpenFileName))
			return FALSE;
	}
	if (szSAVout[0]=='\0') //Om inte en utdatafil skickades frga efter fil
	{

		OpenFileName.lStructSize       = sizeof(OPENFILENAME);
		OpenFileName.hwndOwner         = NULL;
		OpenFileName.hInstance         = hinstance;
		OpenFileName.lpstrFilter       = "SAV-files\0*.SAV\0";
		OpenFileName.lpstrCustomFilter = NULL;
		OpenFileName.nMaxCustFilter    = 0;
		OpenFileName.nFilterIndex      = 1;
		OpenFileName.lpstrFile         = szSAVout;
		OpenFileName.nMaxFile          = sizeof(szSAVout);
		OpenFileName.lpstrFileTitle    = NULL;
		OpenFileName.nMaxFileTitle     = 0;
		OpenFileName.lpstrInitialDir   = NULL;
		OpenFileName.lpstrTitle        = NULL;
		OpenFileName.nFileOffset       = 0;
		OpenFileName.nFileExtension    = 0;
		OpenFileName.lpstrDefExt       = "sav";
		OpenFileName.lCustData         = NULL; //(LPARAM)&sMyData;
		OpenFileName.lpfnHook 		   = NULL;
		OpenFileName.lpTemplateName    = "";
		OpenFileName.Flags             = OFN_PATHMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
		// Call the common dialog function.
		if (!GetSaveFileName(&OpenFileName))
			return FALSE;
	}
	//Read the CPF first, and modify the SAV while reading
	int NumCivs=ReadCPF(szCPFFile, CPFcivs);
	char *buffer=0, fixbuffer[256], section[5], lastsection[5];//, buff[2];
	long length, numUnits, CurrentLead=0, CurrentTile=-1, CurrentUnit=-1;
	//Variabler fr de 32 LEAD strukturerna
	char civnames[32][40];
	long civID[32];
	long RACEID[32];
	long width, height;
	long firsttile=-1,firstunit=-1;
	long unitlength=-1;
	//long tilelength=0x92;
	long tilelength[2]={-1,-1};
	long tilepart=0;
	TILE *SAVtiles=0;
	UNIT *SAVunits=0;

	section[4]=0;
	ifstream fin(szSAVin,ios::binary);
	fin.read(fixbuffer,4);
	fixbuffer[4]=0;
	long tmpLong, sublength;
	//All strcmp in main replaced with strcoll (tyckes inte spela ngon strre roll, men orkar inte byta tillbaka nu)
	if (strcoll( fixbuffer,"CIV3")!=0)
	{
		fin.close();
		tmpsav=new char[strlen(tmpdir)+15];
		strcpy(tmpsav,tmpdir);
		strcat(tmpsav,"\\CPTtmp.sav");
		Decompress(szSAVin,tmpsav);
		fin.open(tmpsav,ios::binary);
		fin.read(fixbuffer,4);
		fixbuffer[4]=0;
		if (strcoll( fixbuffer,"CIV3")!=0)
		{
			MessageBox(NULL, fixbuffer, "Invalid Type:", MB_OK);
			
			fin.close();
			DeleteFile(tmpsav);
			delete []tmpsav;
			return FALSE;
		}
	}
	
	ofstream fout(szSAVout,ios::binary);
	fout.write(fixbuffer,4);
	fin.read((char*) &tmpLong,4);
	fout.write((char*) &tmpLong,4);
	fin.read(fixbuffer,2);
	fout.write(fixbuffer,2);
	if (tmpLong==0x111a00)
	{
		//1.21f
		fin.read(fixbuffer,4);
		fout.write(fixbuffer,4);

	}
	while(!fin.eof())
	{
		strcpy(lastsection,section);
		fin.read(section,4);
		fout.write(section,4);
		fin.read((char*) &length,4);
		fout.write((char*) &length,4);
		if (strcoll( section,"BIC ")==0)
		{
			fin.read((char*) &sublength,4);
			fout.write((char*) &sublength,4);
			if (length>4)
			{
				delete []buffer;
				buffer =new char[length-4];
				fin.read(buffer, length-4);
				fout.write(buffer, length-4);
			}
			//Ignore the BIC (Not needed when just passing by (maybe later for CivNames, but can use custom Names and ID#))	
			delete []buffer;
			buffer =new char[sublength];
			fin.read(buffer, sublength);
			fout.write(buffer, sublength);
		}
		else if (strcoll( section,"GAME")==0)
		{
			fin.read(fixbuffer,24);
			fout.write(fixbuffer,24);
			fin.read((char*) &numUnits,4);
			fout.write((char*) &numUnits,4);

			SAVunits= new UNIT[numUnits];
			fin.read(fixbuffer,4);
			fout.write(fixbuffer,4);
			fixbuffer[4]=0;
			//Find next section to read (LEAD)
			int i;
			fixbuffer[3]='\0';
			while (strcoll(fixbuffer,"LEAD")!=0)
			{
				for (i=0;i<3;i++)
					fixbuffer[i]=fixbuffer[i+1];
				fin.get(fixbuffer[3]);
				fout.put(fixbuffer[3]);
			}
			//Go back to red/write the section name again
			fout.seekp(-4,ios::cur); 
			fin.seekg(-4,ios::cur);
		}
		else if (strcoll( section,"LEAD")==0)
		{
			fin.read((char*) &civID[CurrentLead],4);
			fout.write((char*) &civID[CurrentLead],4);
			fin.read((char*) &RACEID[CurrentLead],4);
			fout.write((char*) &RACEID[CurrentLead],4);
			delete []buffer;
			buffer=new char[0x10A0];
			fin.read(buffer,0x10A0);
			fout.write(buffer,0x10A0);
			delete []buffer;
			buffer=new char[0x38];
			fin.read(buffer,0x38);
			fout.write(buffer,0x38);
			delete []buffer;
			buffer=new char[0x28];
			fin.read(buffer,0x28);
			fout.write(buffer,0x28);
			strcpy(civnames[CurrentLead],buffer);	
			CurrentLead++;
			int i;
			fixbuffer[4]='\0';
			fixbuffer[3]='\0';
			while (strcoll(fixbuffer,"LEAD")*strcoll(fixbuffer,"WRLD")!=0)
			{
				for (i=0;i<3;i++)
					fixbuffer[i]=fixbuffer[i+1];
				fin.get(fixbuffer[3]);
				fout.put(fixbuffer[3]);
			}
			fout.seekp(-4,ios::cur);
			fin.seekg(-4,ios::cur);

		}
		else if (strcoll( section,"WRLD")==0)
		{
			switch (length)
			{
				case 0xA4:
				{
					fin.read(fixbuffer,4);
					fout.write(fixbuffer,4);
					fin.read((char *) &height,4);
					fout.write((char *) &height,4);
					fin.read(fixbuffer,16);
					fout.write(fixbuffer,16);
					fin.read((char *) &width,4);
					fout.write((char *) &width,4);
					fin.read(fixbuffer,0x88);
					fout.write(fixbuffer,0x88);
					SAVtiles=new TILE[height*width/2];
				}
				break;
				default:
				{
					delete []buffer;
					buffer=new char[length];
					fin.read(buffer,length);
					fout.write(buffer,length);
				}
			}
		}
		else if (strcoll( section,"TILE")==0)
		{
			if (firsttile==-1)
			{
				firsttile=fin.tellg();
			}
			switch (tilepart)
			{
				case 0:
				{
					tilelength[tilepart++]=length;
					CurrentTile++;
					fin.read(fixbuffer,16);
					fout.write(fixbuffer,16);
					fin.get(SAVtiles[CurrentTile].overlay);
					fout.put(SAVtiles[CurrentTile].overlay);
					fin.read(fixbuffer,length-17);
					fout.write(fixbuffer,length-17);
				}
				break;
				case 1:
				{
					tilelength[tilepart--]=length;
					fin.read((char *) &SAVtiles[CurrentTile].map,4);
					fout.write((char *) &SAVtiles[CurrentTile].map,4);
					fin.read((char *) &SAVtiles[CurrentTile].fow,4);
					fout.write((char *) &SAVtiles[CurrentTile].fow,4);
					fin.read((char *) &SAVtiles[CurrentTile].fow2,4);
					fout.write((char *) &SAVtiles[CurrentTile].fow2,4);
					fin.read((char *) &SAVtiles[CurrentTile].fow3,4);
					fout.write((char *) &SAVtiles[CurrentTile].fow3,4);
					fin.read(fixbuffer,length-16);
					fout.write(fixbuffer,length-16);
				}
				break;
			}

		}
		else if (strcoll( section,"CONT")==0)
		{
			//Find first UNIT
			unsigned int i;
			fixbuffer[4]='\0';
			fixbuffer[3]='\0';
			while (strcoll(fixbuffer,"UNIT")!=0)
			{
				for (i=0;i<3;i++)
					fixbuffer[i]=fixbuffer[i+1];
				fin.get(fixbuffer[3]);
				fout.put(fixbuffer[3]);
			}
			fout.seekp(-4,ios::cur);
			fin.seekg(-4,ios::cur);

		}
		else if (strcoll( section,"UNIT")==0)
		{
			if (firstunit==-1)
			{
				firstunit=fin.tellg();
				unitlength=length; //Store the length used for units in this save (should be the same on all units) No check (speed)
			}
			CurrentUnit++;
			if (CurrentUnit>=numUnits)
			{
				MessageBox(NULL, "DATAIO Operating System Error: CITY", "Error (Use C3MT to fix it)", MB_OK);
				return -2;
			}
			fin.read((char *) &SAVunits[CurrentUnit].index,4);
			fout.write((char *) &SAVunits[CurrentUnit].index,4);
			fin.read((char *) &SAVunits[CurrentUnit].pos,8);
			fout.write((char *) &SAVunits[CurrentUnit].pos,8);
			fin.read(fixbuffer,8);
			fout.write(fixbuffer,8);	
			fin.read((char *) &SAVunits[CurrentUnit].civid,4);
			fout.write((char *) &SAVunits[CurrentUnit].civid,4);
			fin.read((char *) &SAVunits[CurrentUnit].raceid,4);
			fout.write((char *) &SAVunits[CurrentUnit].raceid,4);
			delete []buffer;
			buffer=new char[length-28];
			fin.read(buffer,length-28);
			fout.write(buffer,length-28);				
		}
		else
		{
			//Copy the rest of the file
			while(!fin.eof())
			{
				fin.get(fixbuffer[0]);
				if (!fin.eof())
					fout.put(fixbuffer[0]);
			}
		}
	}
	fin.close(); //Close the infile
	if (tmpsav!=NULL)
	{
		DeleteFile(tmpsav);
		delete []tmpsav;
	}		
	//Apply the changes
	long *InGameID=new long[NumCivs];
	BOOL LeadsUsed[32];
	int k;
	for (j=0;j<32;j++)
	{
		LeadsUsed[j]=FALSE;
	}
	
	
	for (i=0;i<NumCivs;i++)
	{
		InGameID[i]=-1;
		for (j=0;j<32 && InGameID[i]==-1;j++)
		{
			if (RACEID[i]!=-1 && LeadsUsed[j]==FALSE)
			{
				if ((strcoll(CPFcivs[i].GetName(),civnames[j]))==0)
				{
					InGameID[i]=civID[j];
					LeadsUsed[j]=TRUE;
				}
			}
		}
	}
	//Add check fo default CivNames (When the BIC is read)
	for (i=0;i<NumCivs;i++)
	{
		for (j=0;j<32 && InGameID[i]==-1;j++)
		{
			if (RACEID[j]!=-1 && LeadsUsed[j]==FALSE)
			{
				if (CPFcivs[i].GetID()==RACEID[j])
				{
					InGameID[i]=civID[j];
					LeadsUsed[j]=TRUE;
				}
			}
		}
	}
	unsigned long ChangedCivs=0;
	for (i=0;i<NumCivs;i++)
	{
		if (InGameID[i]!=-1)
		{
			ChangedCivs|=1<<InGameID[i];
			for (j=0;j<numUnits;j++)
			{
				if (SAVunits[j].civid==InGameID[i])
					SAVunits[j].pos=CPFcivs[i].GetStartPOS();
			}

		}
	}
	for (i=0;i<NumCivs;i++)
	{
		if (InGameID[i]!=-1)
		{
			for (j=0;j<numUnits;j++)
			{
				
				if (SAVunits[j].civid!=InGameID[i] && SAVunits[j].pos==CPFcivs[i].GetStartPOS())
				{
					//Unit collision
					BOOL Moved = FALSE;
					if (SAVunits[j].civid!=0) //Ignore barbarians for now
					{
						for (k=0;k<NumCivs && Moved==FALSE;k++)
						{
							if (InGameID[k]==SAVunits[j].civid)
							{
								SAVunits[j].pos=CPFcivs[k].GetStartPOS();
								Moved=TRUE;
							}
						}
						for (k=0;k<NumCivs && Moved==FALSE;k++)
						{
							if (InGameID[k]==-1)
							{
								//Unused pos
								InGameID[k]=SAVunits[j].civid;
								SAVunits[j].pos=CPFcivs[k].GetStartPOS();
								ChangedCivs|=1<<InGameID[k];
							}
						}
					}	
				}
			}
		}
	}
	//Now for the barbarian collisions...

	for (i=0;i<NumCivs;i++)
	{
		if (InGameID[i]!=-1)
		{
			for (j=0;j<numUnits;j++)
			{
				
				if (SAVunits[j].civid!=InGameID[i] && SAVunits[j].pos==CPFcivs[i].GetStartPOS())
				{
					//Collisions
					BOOL Moved = FALSE;
					if (SAVunits[j].civid==0) //barbariona now (the thers shall be done)
					{
						for (k=0;k<NumCivs && Moved==FALSE;k++)
						{
							if (InGameID[k]==-1)
							{
								//Unused pos
								InGameID[k]=SAVunits[j].civid;
								SAVunits[j].pos=CPFcivs[k].GetStartPOS();
								Moved=TRUE;
							}
						}
						for (k=0;k<NumCivs && Moved==FALSE;k++)
						{
							if (InGameID[k]==0)
							{
								//Unused pos
								SAVunits[j].pos=CPFcivs[k].GetStartPOS();
								Moved=TRUE;
							}
						}
						for (k=0;k<numUnits && Moved==FALSE;k++)
						{
							if (SAVunits[k].civid=0)
							{
								if (SAVunits[k].pos!=SAVunits[j].pos)
								{
									
									SAVunits[j].pos=SAVunits[k].pos;
									Moved=TRUE;
								}
							}
						}
					}					
				}
			}
		}
	}
//FOW
	unsigned long TileID;
	//Reset
	for (i=0;i<width/2*height;i++)
	{
		SAVtiles[i].map&=!ChangedCivs;
		SAVtiles[i].fow&=!ChangedCivs;
		SAVtiles[i].fow2&=!ChangedCivs;
		SAVtiles[i].fow3&=!ChangedCivs;
	}
	for (i=0;i<NumCivs;i++)
	{
		if (InGameID[i]!=-1)
		{
			int x,y;
			TileID=CPFcivs[i].GetStartPOS().GetY() * width / 2 + (int)(((CPFcivs[i].GetStartPOS().GetX() + width) % width) / 2);
			if (InGameID[i]==0)
				SAVtiles[TileID].overlay=0x80;
			else
				SAVtiles[TileID].overlay&=!0x80;
			for (j=0; j<CPFcivs[i].GetNumCords();j++)
			{
				x=CPFcivs[i].GetStartPOS().GetX()+CPFcivs[i].GetFOWCord(j).GetX();
				y=CPFcivs[i].GetStartPOS().GetY()+CPFcivs[i].GetFOWCord(j).GetY();
				if (y>=0 && y<height)
				{
					TileID=y * width / 2 + (int)(((x + width) % width) / 2);
					//Remove barbarian sight just in case
					SAVtiles[TileID].map&=!1;
					SAVtiles[TileID].fow&=!1;
					SAVtiles[TileID].fow2&=!1;
					SAVtiles[TileID].fow3&=!1;
					//Add sight
					SAVtiles[TileID].map|=1<<InGameID[i];
					SAVtiles[TileID].fow|=1<<InGameID[i];				
				}
			}
		}
	}
	//Update Save
	fout.seekp(firsttile+16,ios::beg);
	//tilelength-=20; //speed issue -36+8*2 (lenght+Section)*2
	
	for(CurrentTile=0;CurrentTile<width/2*height;CurrentTile++)
	{
		fout.put(SAVtiles[CurrentTile].overlay);
		fout.seekp(tilelength[0]-9,ios::cur);
		fout.write((char *) &SAVtiles[CurrentTile].map,4);
		fout.write((char *) &SAVtiles[CurrentTile].fow,4);
		fout.write((char *) &SAVtiles[CurrentTile].fow2,4);
		fout.write((char *) &SAVtiles[CurrentTile].fow3,4);
		fout.seekp(tilelength[1]+8,ios::cur);
	}
	fout.seekp(firstunit+4,ios::beg);
	for(CurrentUnit=0;CurrentUnit<numUnits;CurrentUnit++)
	{
		fout.write((char *) &SAVunits[CurrentUnit].pos,8);
		fout.seekp(unitlength,ios::cur);
	}
	fout.close();
	if ((flags & 1)!=1) 
		MessageBox(NULL, "Done!", "Done", MB_OK);
	return 0;
}


//Counts number of sections in the CPF before loading it. To make it easier to handle memory
int CountCPF(char* FileName)
{
	unsigned int CPFCivID=0;

	unsigned int i, j;
	char cmd[40], var[40];
	ifstream fin(FileName);
	char buffer[256]; //Max line
	while(!fin.eof())
	{
		fin.getline(buffer,256);
		RemoveComments(buffer);
		if (buffer[0]=='@')
		{
			j=0;
			for (i=1;i<strlen(buffer) && buffer[i]!=' ';i++)
			{
				if (buffer[i]!=' ')
				{
					
					cmd[j]=buffer[i];
					j++;
				}
			}
			cmd[j]='\0';
			j=0;
			for (i++;i<strlen(buffer) && buffer[i]!=' ';i++)
			{
				if (buffer[i]!=' ')
				{
					
					var[j]=buffer[i];
					j++;
				}
			}	
			var[j]='\0';
			if ((strcmp(cmd,"STOP")*strcmp(cmd,"END"))==0)
			{
				if (strcmp(var,"CIV")==0)
				{
					//Stop CIV
					CPFCivID++;
				}

			}

		}
	}
	fin.close();
	return (CPFCivID);
}
int ReadCPF(char* FileName,CPFciv *&CPFCivs)
{
	int NumCivs=CountCPF(FileName);
	delete []CPFCivs;
	CPFCivs=new CPFciv[NumCivs];
	long *FOW;
	unsigned int FOWmaxwidth=0,FOWheight=0, FOWcount=0;

	FOW=0;
	Cord FOWcenter;
	unsigned int CPFCivID=0;

	unsigned int i, j;
	char cmd[40], var[40], parent[40]="", section[40]="";
	ifstream fin(FileName);
	char buffer[256]; //Max line
	while(!fin.eof())
	{
		fin.getline(buffer,256);
		RemoveComments(buffer);
		if (buffer[0]=='@')
		{
			j=0;
			for (i=1;i<strlen(buffer) && buffer[i]!=' ';i++)
			{
				if (buffer[i]!=' ')
				{

					cmd[j]=buffer[i];
					j++;
				}

			}
			cmd[j]='\0';
			j=0;
			for (i++;i<strlen(buffer) && buffer[i]!=' ';i++)
			{
				if (buffer[i]!=' ')
				{

					var[j]=buffer[i];
					j++;
				}
			}	
			var[j]='\0';
			if ((strcmp(cmd,"START")*strcmp(cmd,"BEGIN"))==0)
			{
				if ((strcmp(var,"FOW")*strcmp(var,"FOW1")*strcmp(var,"FOW0"))==0)
				{
					//Start FOW read
					strcpy(parent,section);
					strcpy(section,"FOW");
					delete []FOW;
					FOW=0;
					FOWmaxwidth=0;
					FOWheight=0;
					FOWcount=0;
				}
				if (strcmp(var,"CIV")==0)
				{
					//Start CIV read (Make sure the Index exists)
					if (CPFCivID>=NumCivs)
					{
					CPFciv *tmp;
					tmp =new CPFciv[CPFCivID+1];
					for (i=0;i< CPFCivID;i++)
					{
						tmp[i]=CPFCivs[i];
						CPFCivs[i].Reset();
					}
					tmp[i].Reset();
					delete []CPFCivs;
					CPFCivs=new CPFciv[CPFCivID+1];
					for (i=0;i<=CPFCivID;i++)
					{
						CPFCivs[i]=tmp[i];
					}
					delete []tmp;
					tmp=0;

					}

					strcpy(section,"CIV");
				}
					
			}
			if ((strcmp(cmd,"STOP")*strcmp(cmd,"END"))==0)
			{
/*				if (strcmp(var,"FOW1")==0)
				{
					//Start FOW decode 1 (original) (Not Ported from C3CT as unused format)
					// However the multiTool still supports it, but I don't think anyone but I knows about it...
				}*/
				if ((strcmp(var,"FOW")*strcmp(var,"FOW0"))==0)
				{
					if  (strcmp(parent,"CIV"))
					{
						MessageBox(NULL, "Error: FOW/CIV", "C3CT-CPP", MB_OK);
					}
					if  (strcmp(section,"FOW"))
					{
						MessageBox(NULL, "Error: FOW", "C3CT-CPP", MB_OK);
					}
					for (i=0;i<FOWheight;i++)
					{
						for(j=0;j<FOWmaxwidth;j++)
						{
							if (FOW[i*FOWmaxwidth+j])
							{
								Cord tmpCord(i+1-FOWcenter.GetY()+j+1-FOWcenter.GetX(),i-FOWcenter.GetY()-j+FOWcenter.GetX());
								CPFCivs[CPFCivID].SetFOWCord(CPFCivs[CPFCivID].GetNumCords(),tmpCord);
							}
						}
					}
					strcpy(section,parent);
					strcpy(parent,"");
				}
				if (strcmp(var,"CIV")==0)
				{
					//Stop CIV
					CPFCivID++;
				}

			}

		}
		else
		{
			//Read file
			if (strcmp(section,"FOW")==0)
			{
				FOWheight++;
				unsigned int len=strlen(buffer), oldmaxwidth=FOWmaxwidth;
				if (len>FOWmaxwidth)
					FOWmaxwidth=len;
				if (FOW!=0)
				{
					long *tmp=new long[FOWheight*FOWmaxwidth];
					for (i=0;i<FOWheight;i++)
					{
						for (j=0;j<FOWmaxwidth;j++)
						{
							tmp[i*FOWmaxwidth+j]=0;
						}				
					}
					for (i=0;i<FOWheight-1;i++)
					{
						for (j=0;j<oldmaxwidth;j++)
						{
							tmp[i*FOWmaxwidth+j]=FOW[i*oldmaxwidth+j];
						}				
					}
					delete []FOW;
					FOW=new long[FOWheight*FOWmaxwidth];
					for (i=0;i<FOWheight;i++)
					{
						for (j=0;j<FOWmaxwidth;j++)
						{
							FOW[i*FOWmaxwidth+j]=tmp[i*FOWmaxwidth+j];
						}				
					}

				}
				else
				{
					FOW=new long[FOWheight*FOWmaxwidth];
					for (i=0;i<FOWheight;i++)
					{
						for (j=0;j<FOWmaxwidth;j++)
						{
							FOW[i*FOWmaxwidth+j]=0;
						}				
					}
				}

				
				for (i=0;i<len;i++)
				{
					switch (buffer[i])
					{
						case 'x':
						case 'X':
						{
							FOW[(FOWheight-1)*FOWmaxwidth+i]=1;
							FOWcount++;
						}
						break;

						case 'P':
						case 'p':
						{
							FOW[(FOWheight-1)*FOWmaxwidth+i]=0;
						}
						break;
						case 'O':
						case 'o':
						{
							FOW[(FOWheight-1)*FOWmaxwidth+i]=2;
							FOWcenter.Set(i+1,FOWheight);
							FOWcount++;
						}
						break;
						case ' ':
						{
							FOW[(FOWheight-1)*FOWmaxwidth+i]=0;
						}
						break;		
					}
				}
			}
			if (strcmp(section,"CIV")==0)
			{
				j=0;
				for (i=0;i<strlen(buffer) && buffer[i]!='=';i++)
				{
					if (buffer[i]!='=')
					{
						
						cmd[j]=buffer[i];
						j++;
					}
				}	
				cmd[j]='\0';
				j=0;
				for (i++;i<strlen(buffer) && j<39;i++)
				{
					if (buffer[i]!='\0' && j<39)
					{
						
						var[j]=buffer[i];
						j++;
					}
				}	
				var[j]='\0';
			
				if (stricmp(cmd,"NAME")==0)
				{
					CPFCivs[CPFCivID].SetName(var);
				}
				else if (stricmp(cmd,"ID")==0)
				{
					CPFCivs[CPFCivID].SetID(atol(var));
				}
				else if (stricmp(cmd,"CORDS")==0)
				{
					int x,y;
					j=0;
					for (i=0;i<strlen(var) && var[i]!=',';i++)
					{
						if (var[i]!='\0' && j<39)
						{
						
							buffer[j]=var[i];
							j++;
						}
					}	
					buffer[j]='\0';
					x=atoi(buffer);
					j=0;
					for (i++;i<strlen(var) && var[i]!=',';i++)
					{
						if (var[i]!='\0' && j<39)
						{
						
							buffer[j]=var[i];
							j++;
						}
					}	
					buffer[j]='\0';
					y=atoi(buffer);
					CPFCivs[CPFCivID].SetStartPOS(x,y);
				}
			}
		}
	}
	fin.close();
	delete []FOW;
	return (CPFCivID);
}

void RemoveComments(char* String)
{
	char * result;
	result=0;
	result=strchr(String, ';');
	if (result!=0)
		result[0]='\0';
}