#include "cpf.h"
#include <string.h>

Cord::Cord()
{
	x=0;
	y=0;
}

Cord::Cord(int initx, int inity)
{
	x=initx;
	y=inity;
}

Cord::~Cord()
{
}

void Cord::Set(int newx, int newy)
{
	x=newx;
	y=newy;
}
const Cord Cord::operator=(const Cord rhs)
{
	if (this==&rhs)
		return *this;
	x=rhs.GetX();
	y=rhs.GetY();
	return *this;
}

long Cord::operator==(const Cord rhs)
{
	if (x==rhs.GetX() && y==rhs.GetY())
		return -1;
	return 0;
}
long Cord::operator!=(const Cord rhs)
{
	if (x==rhs.GetX() && y==rhs.GetY())
		return 0;
	return -1;
}


CPFciv::CPFciv()
{
	numCords=0;
	FOWCords=0;
	strcpy(Name,"");
	StartPOS.Set(-1,-1);
	ID=-1;
}
CPFciv::~CPFciv()
{
	delete []FOWCords;
}

void CPFciv::Reset()
{
	delete []FOWCords;
	numCords=0;
	FOWCords=0;
	strcpy(Name,"");
	StartPOS.Set(-1,-1);
	ID=-1;
}


void CPFciv::SetFOWCord(unsigned int index, const Cord rhs)
{
	unsigned int i;
	if (index+1>numCords)
	{
		Cord *temp;
		temp=new Cord[index+1];
		for (i=0;i<numCords;i++)
		{
			temp[i]=FOWCords[i];
		}
		for (;i<index+1;i++)
		{
			temp[i].Set(0,0);
		}
		delete []FOWCords;
		numCords=index+1;
		FOWCords=new Cord[numCords];
		
		for (i=0;i<numCords;i++)
		{
			FOWCords[i]=temp[i];
		}
		delete []temp;
	}
	FOWCords[index]=rhs;
}

const Cord CPFciv::GetFOWCord(unsigned int index) const
{
	if (index>=numCords)
	{
		Cord tmp(-1,-1);
		return (tmp);
	}
	return(FOWCords[index]);
}

void CPFciv::SetName(char* newName)
{
	strcpy(Name,newName);
}
const char* CPFciv::GetName() const
{
	return Name;
}

const CPFciv CPFciv::operator=(const CPFciv rhs)
{
	if (this==&rhs)
		return *this;
	delete []FOWCords;
	numCords=rhs.GetNumCords();
	if (numCords>0)
		FOWCords=new Cord[numCords];
	else
		FOWCords=0;
	for(unsigned int i=0;i<numCords;i++)
	{
		FOWCords[i]=rhs.GetFOWCord(i);
	}
	StartPOS=rhs.GetStartPOS();
	ID=rhs.GetID();
	strcpy(Name,rhs.GetName());
	return *this;
}
