/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jmkirschberg.games.civ2.Technology;
import jmkirschberg.games.civ2.TribeName;
import jmkirschberg.games.civ2.TribeTechMoney;
import jmkirschberg.games.civ2.Unit;

public class Tribe {
    private TribeName tribeName = new TribeName();
    private TribeTechMoney tribeTechMoney = new TribeTechMoney();
    private Unit[] units;
    private Technology[] techs;
    private int index;
    private String rulesNameLeader;
    private String rulesNameTribe;
    private String rulesNameTribeAdjective;

    public void setIndex(int index) {
        if ((index > 6 || index < 0) && index != -1) {
            throw new AssertionError();
        }
        this.index = index;
    }

    public void setRulesNameLeader(String name) {
        this.rulesNameLeader = name;
    }

    public void setRulesNameTribe(String name) {
        this.rulesNameTribe = name;
    }

    public void setRulesNameTribeAdjective(String name) {
        this.rulesNameTribeAdjective = name;
    }

    public void readTribeName(DataInput input) throws IOException {
        this.tribeName.readExternal(input);
    }

    public void readTribeTechMoney(DataInput input) throws IOException {
        this.tribeTechMoney.readExternal(input);
    }

    public void writeTribeName(DataOutput output) throws IOException {
        this.tribeName.writeExternal(output);
    }

    public void writeTribeTechMoney(DataOutput output) throws IOException {
        this.tribeTechMoney.writeExternal(output);
    }

    public int getTribeNumber() {
        return this.tribeTechMoney.getTribeNumber();
    }

    public boolean isMale() {
        return this.tribeTechMoney.isMale();
    }

    public int getMoney() {
        return this.tribeTechMoney.getMoney();
    }

    public boolean hasEmbassy(int civ1) {
        if (civ1 > 6 || civ1 < 0) {
            throw new AssertionError();
        }
        return this.tribeTechMoney.hasEmbassy(civ1);
    }

    public Technology[] getTechs(Technology[] techs) {
        return this.tribeTechMoney.getTechs(techs);
    }

    public boolean hasTech(Technology tech) {
        return this.tribeTechMoney.hasTech(tech);
    }

    public boolean[] hasEmbassy() {
        boolean[] embassies = new boolean[7];
        int i = 0;
        while (i < 7) {
            embassies[i] = this.tribeTechMoney.hasEmbassy(i);
            ++i;
        }
        return embassies;
    }

    public String getNameTribeAdjective() {
        String temp = this.tribeName.getNameTribeAdjective();
        if (temp.length() == 0) {
            temp = this.rulesNameTribeAdjective;
        }
        return temp;
    }

    public String getNameTribe() {
        String temp = this.tribeName.getNameTribe();
        if (temp.length() == 0) {
            temp = this.rulesNameTribe;
        }
        return temp;
    }

    public String getNameLeader() {
        String temp = this.tribeName.getNameLeader();
        if (temp.length() == 0) {
            temp = this.rulesNameLeader;
        }
        return temp;
    }

    public int getGold() {
        return this.tribeTechMoney.getGold();
    }

    public boolean hasPeace(int i) {
        if (i < 0 || i > 6) {
            throw new AssertionError();
        }
        return this.tribeTechMoney.hasPeace(i);
    }

    public boolean hasAlliance(int i) {
        if (i < 0 || i > 6) {
            throw new AssertionError();
        }
        return this.tribeTechMoney.hasAlliance(i);
    }

    public boolean hasCeaseFire(int i) {
        if (i < 0 || i > 6) {
            throw new AssertionError();
        }
        return this.tribeTechMoney.hasCeaseFire(i);
    }

    public boolean hasContact(int i) {
        if (i > 6 || i < 0) {
            throw new AssertionError();
        }
        return this.tribeTechMoney.hasContact(i);
    }

    public boolean[] getContacts() {
        boolean[] contacts = new boolean[7];
        int i = 0;
        while (i <= 6) {
            contacts[i] = this.tribeTechMoney.hasContact(i);
            ++i;
        }
        return contacts;
    }

    public void setMoney(int money) {
        this.tribeTechMoney.setMoney(money);
    }

    public void addTech(Technology tech) {
        this.tribeTechMoney.addTech(tech);
    }

    public void setPeace(int civ) {
        if (civ < 0 || civ > 6) {
            throw new AssertionError();
        }
        this.tribeTechMoney.setPeace(civ);
    }

    public void setAlliance(int civ) {
        if (civ < 0 || civ > 6) {
            throw new AssertionError();
        }
        this.tribeTechMoney.setAlliance(civ);
    }

    public void setCeaseFire(int civ) {
        if (civ < 0 || civ > 6) {
            throw new AssertionError();
        }
        this.tribeTechMoney.setCeaseFire(civ);
    }

    public void setRevolution() {
        this.tribeTechMoney.setRevolution();
    }
}

