/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import jmkirschberg.games.civ2.NotRulesFormatException;
import jmkirschberg.games.civ2.Technology;

public class Rules {
    private static final int SIZE_LEADERS = 4;
    private static final String STR_CIVILIZE = "@CIVILIZE";
    private static final String STR_LEADERS = "@LEADERS";
    private static final String STR_COMMA = ",";
    private static final String STR_COMMENTARY = ";";
    private static final String STR_COMMENTARY2 = ":";
    private static final String STR_UNITS = "@UNITS";
    private static final String STR_NEW_SECTION = "@";
    private static final String STR_NO = "no";
    private static final char CHAR_COMMA = ',';
    private static final char CHAR_DOT_COMMA = ';';
    private static final int LOOKING_FOR_SECTION = 0;
    private static final int TECHS = 1;
    private static final int LEADERS = 2;
    private static final int UNITS = 3;
    private static final int FIELD_MALE_NAME = 0;
    private static final int FIELD_FEMALE_NAME = 1;
    private static final int FIELD_TRIBE_NAME = 2;
    private static final int FIELD_TRIBE_NAME_ADJECTIVE = 3;
    private static final int POS_MONARCHY = 54;
    private static final int POS_REPUBLIC = 71;
    private static final int POS_DEMOCRACY = 21;
    private static final int POS_COMUNISM = 15;
    private static final int POS_FUNDAMENTALISM = 31;
    private static final int TECH_PRE1 = 3;
    private static final int TECH_PRE2 = 4;
    private Technology[] technologies;
    private String[][] leaders = new String[21][4];
    private String[] unitsName;

    private static String[] getFields(String line) {
        int posEnd = line.indexOf(59);
        line = line.substring(0, posEnd);
        line = line.trim();
        int posComma = line.indexOf(STR_COMMA, 0);
        int commas = 0;
        while (posComma != -1) {
            ++commas;
            posComma = line.indexOf(STR_COMMA, posComma + 1);
        }
        String[] result = new String[commas + 1];
        int posLastComma = 0;
        posComma = line.indexOf(STR_COMMA, 0);
        int i = 0;
        while (i < commas) {
            if (posComma == -1) {
                posComma = line.length();
            }
            if (posLastComma == -1) {
                posLastComma = 0;
            }
            result[i] = line.substring(posLastComma + 1, posComma);
            posLastComma = posComma;
            posComma = line.indexOf(STR_COMMA, posLastComma + 1);
            ++i;
        }
        return result;
    }

    private int checkState(String temp) {
        int state = temp.trim().startsWith(STR_CIVILIZE) ? 1 : (temp.trim().startsWith(STR_LEADERS) ? 2 : (temp.trim().startsWith(STR_UNITS) ? 3 : 0));
        return state;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readExternal(DataInput input) throws IOException, ClassNotFoundException, NotRulesFormatException {
        techRead = false;
        leaderRead = false;
        unitsRead = false;
        counterTech = 0;
        counterCiv = 0;
        techs = new ArrayList<Technology>();
        units = new ArrayList<String>();
        state = 0;
        try lbl-1000:
        // 14 sources

        {
            block9: while (!(techRead && leaderRead && unitsRead)) {
                temp = input.readLine();
                switch (state) {
                    case 0: {
                        state = this.checkState(temp);
                        ** break;
                    }
                    case 1: {
                        if (temp.trim().startsWith("@")) {
                            state = this.checkState(temp);
                            techRead = true;
                            ** break;
                        }
                        if (temp.trim().startsWith(";") || temp.trim().length() == 0 || temp.trim().startsWith(":")) continue block9;
                        result = Rules.getFields(temp);
                        if (result[3].trim().equals("no") && result[4].trim().equals("no")) {
                            ++counterTech;
                            ** break;
                        }
                        techs.add(new Technology(temp.substring(0, temp.indexOf(44)).trim(), counterTech++));
                        ** break;
                    }
                    case 2: {
                        if (temp.trim().startsWith("@")) {
                            state = this.checkState(temp);
                            leaderRead = true;
                            ** break;
                        }
                        if (temp.trim().startsWith(";") || temp.trim().length() == 0 || temp.trim().startsWith(":")) continue block9;
                        counterLoop = 0;
                        counterField = 0;
                        indexStart = 0;
                        while (true) {
                            if (counterField >= 4) {
                                if (++counterCiv != 21) continue block9;
                                leaderRead = true;
                                state = 0;
                                ** break;
                            }
                            indexFinish = temp.indexOf(44, indexStart);
                            if (counterLoop == 0 || counterLoop == 1 || counterLoop == 5 || counterLoop == 6) {
                                this.leaders[counterCiv][counterField++] = temp.substring(indexStart, indexFinish).trim();
                            }
                            indexStart = indexFinish + 1;
                            ++counterLoop;
                        }
                    }
                    case 3: {
                        if (temp.trim().startsWith("@")) {
                            state = this.checkState(temp);
                            unitsRead = true;
                            ** break;
                        }
                        if (temp.trim().startsWith(";") || temp.trim().length() == 0 || temp.trim().startsWith(":")) continue block9;
                        units.add(temp.substring(0, temp.indexOf(44)).trim());
                        continue block9;
                    }
                }
            }
        }
        catch (EOFException e) {
            throw new NotRulesFormatException();
        }
        catch (IOException e) {
            throw e;
        }
        this.technologies = new Technology[techs.size()];
        i = 0;
        while (i < this.technologies.length) {
            this.technologies[i] = (Technology)techs.get(i);
            ++i;
        }
        this.unitsName = new String[units.size()];
        i = 0;
        while (i < this.unitsName.length) {
            this.unitsName[i] = (String)units.get(i);
            ++i;
        }
    }

    public String[] getLeaderString(int index) {
        if (index < 0 || index >= 21) {
            throw new AssertionError();
        }
        return this.leaders[index];
    }

    public String getLeaderMaleName(int index) {
        if (index < 0 || index >= 21) {
            throw new AssertionError();
        }
        return this.leaders[index][0];
    }

    public String getLeaderFemaleName(int index) {
        if (index < 0 || index >= 21) {
            throw new AssertionError();
        }
        return this.leaders[index][1];
    }

    public String getNameTribe(int index) {
        if (index < 0 || index > 21) {
            throw new AssertionError();
        }
        return this.leaders[index][2];
    }

    public String getNameTribeAdjective(int index) {
        if (index < 0 || index > 21) {
            throw new AssertionError();
        }
        return this.leaders[index][3];
    }

    public Technology[] getTechnologies() {
        return this.technologies;
    }

    public String[] getUnitsName() {
        return this.unitsName;
    }

    public static void main(String[] args) {
        System.out.println("Test function for Rules Class - Civ2DIP 2.0");
        System.out.println("Made by Javier Mu\u00f1oz Kirschberg - 2002");
        System.out.println("Please enter the path to RULES.TXT");
        BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
        try {
            String name = input.readLine();
            File file = new File(name);
            Rules rules = new Rules();
            rules.readExternal(new DataInputStream(new FileInputStream(file)));
            System.out.println("The leaders names:");
            int i = 0;
            while (i < 21) {
                String[] temp = rules.getLeaderString(i);
                int j = 0;
                while (j < temp.length) {
                    System.out.println(temp[j]);
                    ++j;
                }
                ++i;
            }
            System.out.println("The techs:");
            Technology[] techs = rules.getTechnologies();
            int i2 = 0;
            while (i2 < techs.length) {
                System.out.println(techs[i2].getName());
                ++i2;
            }
            System.out.println("The units:");
            String[] unitsName = rules.getUnitsName();
            int i3 = 0;
            while (i3 < unitsName.length) {
                System.out.println(unitsName[i3]);
                ++i3;
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found!");
        }
        catch (Exception e) {
            System.out.println("Error!");
            System.out.println(e);
        }
    }

    public static boolean isGovernment(Technology t) {
        return t.getOriginalPos() == 54 || t.getOriginalPos() == 71 || t.getOriginalPos() == 21 || t.getOriginalPos() == 15 || t.getOriginalPos() == 31;
    }

    static {
        SIZE_LEADERS = 4;
        STR_CIVILIZE = STR_CIVILIZE;
        STR_LEADERS = STR_LEADERS;
        STR_COMMA = STR_COMMA;
        STR_COMMENTARY = STR_COMMENTARY;
        STR_COMMENTARY2 = STR_COMMENTARY2;
        STR_UNITS = STR_UNITS;
        STR_NEW_SECTION = STR_NEW_SECTION;
        STR_NO = STR_NO;
        CHAR_COMMA = (char)44;
        CHAR_DOT_COMMA = (char)59;
        LOOKING_FOR_SECTION = 0;
        TECHS = 1;
        LEADERS = 2;
        UNITS = 3;
        FIELD_MALE_NAME = 0;
        FIELD_FEMALE_NAME = 1;
        FIELD_TRIBE_NAME = 2;
        FIELD_TRIBE_NAME_ADJECTIVE = 3;
        POS_MONARCHY = 54;
        POS_REPUBLIC = 71;
        POS_DEMOCRACY = 21;
        POS_COMUNISM = 15;
        POS_FUNDAMENTALISM = 31;
        TECH_PRE1 = 3;
        TECH_PRE2 = 4;
    }
}

