/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jmkirschberg.games.civ2.City;
import jmkirschberg.games.civ2.Coordinate;
import jmkirschberg.games.civ2.Unit;
import jmkirschberg.games.civ2.Util;

public class Map {
    private static final int SIZE_BLOCK2 = 6;
    private static final int SIZE_BLOCK4 = 1024;
    private static final int VISIBILITY = 4;
    private static final int OWNER = 5;
    private static final int UNIT = 1;
    private static final int CITY = 2;
    private static final int IRRIGATION = 4;
    private static final int ROAD = 8;
    private int squares;
    private int width;
    private int height;
    private boolean flat;
    private int seed;
    private int qwidth;
    private int qheight;
    private int[][] block1;
    private int[][] block2;
    private int[] block3;
    private int[] block4;
    public static final int MAX_SQUARES = 10000;
    public static final int MIN_SIZE = 20;
    public static final int MAX_SIZE = 250;
    public static final int MIN_SQUARES = 1000;

    private int toLineal(Coordinate c) {
        if (!Map.checkCoordinate(c)) {
            throw new AssertionError();
        }
        int temp = 0;
        temp += c.getRow() * this.width;
        return temp += c.getColumn() / 2;
    }

    public void revealTerrain(int civ1, int civ2) {
        if (civ1 < 0 || civ2 < 0 || civ1 > 6 || civ2 > 6) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < this.squares) {
            if ((this.block2[i][4] & 1 << civ2 + 1) == 1 << civ2 + 1) {
                this.block2[i][4] = this.block2[i][4] | 1 << civ1 + 1;
            }
            ++i;
        }
    }

    public void revealFeatures(int civ1, int civ2) {
        if (civ1 < 0 || civ2 < 0 || civ1 > 6 || civ2 > 6) {
            throw new AssertionError();
        }
        this.revealTerrain(civ1, civ2);
        int i = 0;
        while (i < this.squares) {
            this.block1[civ1][i] = this.block1[civ1][i] | this.block1[civ2][i];
            ++i;
        }
    }

    public void revealUnit(Unit u, int civ) {
        if (civ < 0 || civ > 6 || !Map.checkCoordinate(u.getCoordinate())) {
            throw new AssertionError();
        }
        int square = this.toLineal(u.getCoordinate());
        this.block1[civ][square] = this.block1[civ][square] | 1;
        u.reveal(civ);
    }

    public void revealUnit(Unit[] u, int civ) {
        int i = 0;
        while (i < u.length) {
            this.revealUnit(u[i], civ);
            ++i;
        }
    }

    public void revealForeignMap(int civ1, int civ2, int civ3) {
        if (civ1 < 0 || civ2 < 0 || civ3 < 0 || civ1 > 6 || civ2 > 6 || civ3 > 6 || civ3 == civ1) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < this.squares) {
            if ((this.block2[i][4] & 1 << civ2 + 1) == 1 << civ2 + 1 && (this.block2[i][5] & 0xF0) >> 4 == civ3 + 1) {
                this.block2[i][4] = this.block2[i][4] | 1 << civ1 + 1;
                this.block1[civ1][i] = this.block1[civ1][i] | this.block1[civ2][i];
            }
            ++i;
        }
    }

    public void revealCity(City city, int civ, int civ2) {
        if (civ < 0 || civ > 6 || !Map.checkCoordinate(city.getCoordinate())) {
            throw new AssertionError();
        }
        int square = this.toLineal(city.getCoordinate());
        this.block1[civ][square] = this.block1[civ2][square];
        if ((this.block2[square][4] & 1 << civ2 + 1) == 1 << civ2 + 1) {
            this.block2[square][4] = this.block2[square][4] | 1 << civ + 1;
        }
        city.reveal(civ);
    }

    public int getSize() {
        return this.squares;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static void main(String[] args) {
    }

    public void readExternal(DataInput source) throws IOException {
        this.width = Util.readUnsignedShort(source) / 2;
        this.height = Util.readUnsignedShort(source);
        this.squares = Util.readUnsignedShort(source);
        this.flat = Util.readUnsignedShort(source) == 1;
        this.seed = Util.readUnsignedShort(source);
        this.qwidth = Util.readUnsignedShort(source);
        this.qheight = Util.readUnsignedShort(source);
        int size_block3 = this.qwidth * this.qheight * 2;
        this.block1 = new int[7][this.squares];
        this.block2 = new int[this.squares][6];
        this.block3 = new int[size_block3];
        this.block4 = new int[1024];
        int i = 0;
        while (i < this.block1.length) {
            int j = 0;
            while (j < this.block1[i].length) {
                this.block1[i][j] = source.readUnsignedByte();
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.block2.length) {
            int j = 0;
            while (j < this.block2[i2].length) {
                this.block2[i2][j] = source.readUnsignedByte();
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.block3.length) {
            this.block3[i3] = source.readUnsignedByte();
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.block4.length) {
            this.block4[i4] = source.readUnsignedByte();
            ++i4;
        }
    }

    public void writeExternal(DataOutput out) throws IOException {
        Util.writeUnsignedShort(out, this.width * 2);
        Util.writeUnsignedShort(out, this.height);
        Util.writeUnsignedShort(out, this.squares);
        if (this.flat) {
            Util.writeUnsignedShort(out, 1);
        } else {
            Util.writeUnsignedShort(out, 0);
        }
        Util.writeUnsignedShort(out, this.seed);
        Util.writeUnsignedShort(out, this.qwidth);
        Util.writeUnsignedShort(out, this.qheight);
        int i = 0;
        while (i < this.block1.length) {
            int j = 0;
            while (j < this.block1[i].length) {
                out.writeByte(this.block1[i][j]);
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.block2.length) {
            int j = 0;
            while (j < this.block2[i2].length) {
                out.writeByte(this.block2[i2][j]);
                ++j;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.block3.length) {
            out.writeByte(this.block3[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.block4.length) {
            out.writeByte(this.block4[i4]);
            ++i4;
        }
    }

    public static boolean checkCoordinate(Coordinate c) {
        int row = c.getRow();
        int column = c.getColumn();
        return column <= 250 && row <= 250 && column * row <= 10000;
    }

    public int[] getHeader() {
        int[] header = new int[]{this.squares, this.width, this.height, this.flat ? 1 : 0, this.seed, this.qwidth, this.qheight};
        return header;
    }

    static {
        SIZE_BLOCK2 = 6;
        SIZE_BLOCK4 = 1024;
        VISIBILITY = 4;
        OWNER = 5;
        UNIT = 1;
        CITY = 2;
        IRRIGATION = 4;
        ROAD = 8;
        MAX_SQUARES = 10000;
        MIN_SIZE = 20;
        MAX_SIZE = 250;
        MIN_SQUARES = 1000;
    }
}

