/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jmkirschberg.games.civ2.Util;

class Coordinate {
    private int row;
    private int column;

    public Coordinate() {
        this(0, 0);
    }

    public Coordinate(int r, int c) {
        this.setCoordinate(r, c);
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public void setCoordinate(int r, int c) {
        if (r < 0 || c < 0) {
            throw new AssertionError();
        }
        this.row = r;
        this.column = c;
    }

    public void setInvalid() {
        this.row = 65535;
        this.column = 65535;
    }

    public void writeExternal(DataOutput s) throws IOException {
        Util.writeUnsignedShort(s, this.column);
        Util.writeUnsignedShort(s, this.row);
    }

    public void writeExternalReverse(DataOutput s) throws IOException {
        Util.writeUnsignedShort(s, this.row);
        Util.writeUnsignedShort(s, this.column);
    }

    public void readExternalReverse(DataInput s) throws IOException {
        int r = Util.readUnsignedShort(s);
        int c = Util.readUnsignedShort(s);
        this.setCoordinate(r, c);
    }

    public void readExternal(DataInput s) throws IOException {
        int c = Util.readUnsignedShort(s);
        int r = Util.readUnsignedShort(s);
        this.setCoordinate(r, c);
    }

    public boolean equals(Coordinate other) {
        return other.row == this.row && other.column == this.column;
    }

    public int distance(Coordinate other) {
        int comp1 = (int)Math.pow(other.row - this.row, 2.0);
        int comp2 = (int)Math.pow(other.column - this.column, 2.0);
        return (int)Math.sqrt(comp1 + comp2);
    }
}

