/*
 * Decompiled with CFR 0.152.
 */
package jmkirschberg.games.civ2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jmkirschberg.games.civ2.Coordinate;
import jmkirschberg.games.civ2.Map;
import jmkirschberg.games.civ2.Util;

public class City {
    private static final int UNKNOW_BYTES = 6;
    private static final int BOOLEAN_BYTES = 3;
    private static final int SPECIALIST = 4;
    private static final int SIZE_NAME = 16;
    private static final int SIZE_FOREIGNS = 7;
    private static final int WORKER_DISTRIBUTION = 3;
    private static final int CITY_IMPROVEMENTS = 5;
    private static final int COMMODITIES = 15;
    private static final int COASTAL = 128;
    private static final int AUTO_BUILD = 16;
    private static final int STEAL_TECH = 8;
    private static final int IMPROVEMENT_SOLD = 4;
    private static final int WE_LOVE_THE_KING_DAY = 2;
    private static final int CIVIL_DISORDER = 1;
    private static final int BUILD_SHIP = 32;
    private static final int OBJECTIVE_X3 = 16;
    private static final int OBJECTIVE_X1 = 4;
    private static final int AUTO_DOMESTIC = 2;
    private static final int AUTO_MILITARY = 1;
    private static final int PALACE_POS = 0;
    private static final int PALACE_VALUE = 2;
    private Coordinate coordinate;
    private boolean coastal;
    private boolean autoBuild;
    private boolean stealTech;
    private boolean improvementSold;
    private boolean weLoveTheKingDay;
    private boolean civilDisorder;
    private boolean buildShip;
    private boolean objectiveX3;
    private boolean objectiveX1;
    private boolean autoDomestic;
    private boolean autoMilitary;
    private int owner;
    private int size;
    private int firstOwner;
    private int turnConquered;
    private int civsFound;
    private int[] foreignSize;
    private int barbarianSize;
    private int[] specialist;
    private int foodOnCity;
    private int shieldsOnCity;
    private int netTradeWithoutRoutes;
    private String name;
    private int[] workerDistribution;
    private int numberSpecialist;
    private int[] cityImprovements;
    private int currentProduction;
    private int numberRoutes;
    private int[] commodities;
    private int science;
    private int tax;
    private int netTrade;
    private int food;
    private int shields;
    private int happyCitiziens;
    private int unhappyCitiziens;
    private int id;
    private int[] unknow = new int[6];
    private int[] booleans = new int[3];

    public City() {
        this.specialist = new int[4];
        this.workerDistribution = new int[3];
        this.cityImprovements = new int[5];
        this.commodities = new int[15];
        this.foreignSize = new int[7];
        this.coordinate = new Coordinate();
    }

    public void setId(int id) {
        if (id > 255) {
            throw new AssertionError();
        }
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public boolean knowsAbout(int i) {
        if (i < 0 || i > 6) {
            throw new AssertionError();
        }
        return (this.civsFound & 2 << i) == 2 << i;
    }

    public int getOwner() {
        return this.owner - 1;
    }

    public void reveal(int civ) {
        if (civ < 0 || civ > 6) {
            throw new AssertionError();
        }
        this.civsFound |= 2 << civ;
        this.foreignSize[civ] = this.size;
    }

    public void setOwner(int civ) {
        if (civ < 0 || civ > 6 || this.isCapital()) {
            throw new AssertionError();
        }
        this.civsFound |= 2 << this.owner;
        this.foreignSize[this.owner - 1] = this.size;
        this.owner = civ + 1;
    }

    public boolean isCapital() {
        return (this.cityImprovements[0] & 2) == 2;
    }

    public boolean exists() {
        return Map.checkCoordinate(this.coordinate);
    }

    public void readExternal(DataInput input) throws IOException {
        int counter = 0;
        int counterBoolean = 0;
        this.coordinate.readExternal(input);
        this.booleans[counterBoolean++] = input.readUnsignedByte();
        this.coastal = (this.booleans[counterBoolean - 1] & 0x80) == 128;
        this.autoBuild = (this.booleans[counterBoolean - 1] & 0x10) == 16;
        this.improvementSold = (this.booleans[counterBoolean - 1] & 4) == 4;
        this.weLoveTheKingDay = (this.booleans[counterBoolean - 1] & 2) == 2;
        this.unknow[counter++] = input.readUnsignedByte();
        this.booleans[counterBoolean++] = input.readUnsignedByte();
        this.buildShip = (this.booleans[counterBoolean - 1] & 0x20) == 32;
        this.booleans[counterBoolean++] = input.readUnsignedByte();
        this.objectiveX3 = (this.booleans[counterBoolean - 1] & 0x10) == 16;
        this.objectiveX1 = (this.booleans[counterBoolean - 1] & 4) == 4;
        this.autoDomestic = (this.booleans[counterBoolean - 1] & 2) == 2;
        boolean bl = this.autoMilitary = (this.booleans[counterBoolean - 1] & 1) == 1;
        if (!this.autoDomestic && !this.autoMilitary) {
            this.autoDomestic = true;
            this.autoMilitary = true;
        }
        this.owner = input.readUnsignedByte();
        this.size = input.readUnsignedByte();
        this.firstOwner = input.readUnsignedByte();
        this.turnConquered = input.readUnsignedByte();
        this.civsFound = input.readUnsignedByte();
        this.barbarianSize = input.readUnsignedByte();
        int i = 0;
        while (i < 7) {
            this.foreignSize[i] = input.readUnsignedByte();
            ++i;
        }
        this.unknow[counter++] = input.readUnsignedByte();
        int i2 = 0;
        while (i2 < this.specialist.length) {
            this.specialist[i2] = input.readUnsignedByte();
            ++i2;
        }
        this.foodOnCity = Util.readUnsignedShort(input);
        this.shieldsOnCity = Util.readUnsignedShort(input);
        this.netTradeWithoutRoutes = Util.readUnsignedShort(input);
        this.name = Util.readASCII(input, 16);
        int i3 = 0;
        while (i3 < 3) {
            this.workerDistribution[i3] = input.readUnsignedByte();
            ++i3;
        }
        this.numberSpecialist = input.readUnsignedByte();
        int i4 = 0;
        while (i4 < 5) {
            this.cityImprovements[i4] = input.readUnsignedByte();
            ++i4;
        }
        this.currentProduction = input.readUnsignedByte();
        this.numberRoutes = input.readUnsignedByte();
        int i5 = 0;
        while (i5 < 15) {
            this.commodities[i5] = input.readUnsignedByte();
            ++i5;
        }
        this.science = Util.readUnsignedShort(input);
        this.tax = Util.readUnsignedShort(input);
        this.netTrade = Util.readUnsignedShort(input);
        this.food = input.readUnsignedByte();
        this.shields = input.readUnsignedByte();
        this.happyCitiziens = input.readUnsignedByte();
        this.unhappyCitiziens = input.readUnsignedByte();
        int i6 = 0;
        while (i6 < 4) {
            this.unknow[counter++] = input.readUnsignedByte();
            ++i6;
        }
    }

    public void writeExternal(DataOutput output) throws IOException {
        int counter = 0;
        int counterBoolean = 0;
        this.coordinate.writeExternal(output);
        output.writeByte(this.booleans[counterBoolean++]);
        output.writeByte(this.unknow[counter++]);
        output.writeByte(this.booleans[counterBoolean++]);
        output.writeByte(this.booleans[counterBoolean++]);
        output.writeByte(this.owner);
        output.writeByte(this.size);
        output.writeByte(this.firstOwner);
        output.writeByte(this.turnConquered);
        output.writeByte(this.civsFound);
        output.writeByte(this.barbarianSize);
        int i = 0;
        while (i < 7) {
            output.writeByte(this.foreignSize[i]);
            ++i;
        }
        output.writeByte(this.unknow[counter++]);
        int i2 = 0;
        while (i2 < this.specialist.length) {
            output.writeByte(this.specialist[i2]);
            ++i2;
        }
        Util.writeUnsignedShort(output, this.foodOnCity);
        Util.writeUnsignedShort(output, this.shieldsOnCity);
        Util.writeUnsignedShort(output, this.netTradeWithoutRoutes);
        Util.writeASCII(output, this.name, 16);
        int i3 = 0;
        while (i3 < 3) {
            output.writeByte(this.workerDistribution[i3]);
            ++i3;
        }
        output.writeByte(this.numberSpecialist);
        int i4 = 0;
        while (i4 < 5) {
            output.writeByte(this.cityImprovements[i4]);
            ++i4;
        }
        output.writeByte(this.currentProduction);
        output.writeByte(this.numberRoutes);
        int i5 = 0;
        while (i5 < 15) {
            output.writeByte(this.commodities[i5]);
            ++i5;
        }
        Util.writeUnsignedShort(output, this.science);
        Util.writeUnsignedShort(output, this.tax);
        Util.writeUnsignedShort(output, this.netTrade);
        output.writeByte(this.food);
        output.writeByte(this.shields);
        output.writeByte(this.happyCitiziens);
        output.writeByte(this.unhappyCitiziens);
        int i6 = 0;
        while (i6 < 4) {
            output.writeByte(this.unknow[counter++]);
            ++i6;
        }
    }

    public String toString() {
        return this.name;
    }

    static {
        UNKNOW_BYTES = 6;
        BOOLEAN_BYTES = 3;
        SPECIALIST = 4;
        SIZE_NAME = 16;
        SIZE_FOREIGNS = 7;
        WORKER_DISTRIBUTION = 3;
        CITY_IMPROVEMENTS = 5;
        COMMODITIES = 15;
        COASTAL = 128;
        AUTO_BUILD = 16;
        STEAL_TECH = 8;
        IMPROVEMENT_SOLD = 4;
        WE_LOVE_THE_KING_DAY = 2;
        CIVIL_DISORDER = 1;
        BUILD_SHIP = 32;
        OBJECTIVE_X3 = 16;
        OBJECTIVE_X1 = 4;
        AUTO_DOMESTIC = 2;
        AUTO_MILITARY = 1;
        PALACE_POS = 0;
        PALACE_VALUE = 2;
    }
}

