/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class TechButton
extends Button
implements ActionListener,
MouseMotionListener,
MouseListener {
    Tech tech;
    int x;
    int y;
    static int height = 30;
    static int width = 100;
    private boolean dragged = false;
    TechWindow window;

    TechButton(Tech tech, int n, int n2) {
        this.tech = tech;
        this.tech.button = this;
        this.setSize(width, height);
        this.setLocation(n, n2);
        this.window = new TechWindow(tech);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addActionListener(this);
    }

    TechButton(Tech tech, int n, int n2, boolean bl) {
        this(tech, n, n2);
        this.setLocation(n, n2, bl);
    }

    public void setLocation(int n, int n2) {
        if (n > BrowserGUI.DEFAULT_WIDTH - width / 2) {
            n = BrowserGUI.DEFAULT_WIDTH - width / 2;
        }
        if (n2 > BrowserGUI.DEFAULT_HEIGHT - height / 2) {
            n2 = BrowserGUI.DEFAULT_HEIGHT - height / 2;
        }
        if (n < -width / 2) {
            n = -width / 2;
        }
        if (n2 < -height / 2) {
            n2 = -height / 2;
        }
        if (this.tech.moved && !this.dragged) {
            n2 = this.tech.ypos;
            n = this.tech.xpos;
        }
        super.setLocation(n, n2);
        this.tech.xpos = n;
        this.tech.ypos = n2;
        this.x = n + width / 2;
        this.y = n2 + height / 2;
    }

    public void setLocation(int n, int n2, boolean bl) {
        if (bl) {
            this.dragged = true;
        }
        this.setLocation(n, n2);
        this.dragged = false;
    }

    public void paint(Graphics graphics) {
        graphics.drawString(this.tech.name, 5, 15);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.dragged) {
            System.out.println("Opened " + this.tech.name);
            this.window.show();
        }
        this.dragged = false;
    }

    public boolean equals(Object object) {
        if (object instanceof TechButton) {
            TechButton techButton = (TechButton)object;
            if (techButton.tech.name.equals(this.tech.name)) {
                return true;
            }
        }
        return false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragged = true;
        this.tech.moved = true;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.setLocation(this.x + n - width, this.y + n2 - height / 2 - height / 2);
        this.getParent().repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragged) {
            System.out.println("Moved " + this.tech.name);
            Main.mg.bg.setSize();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

