/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;

public class Tech {
    String name;
    String civpedia_entry;
    int ID;
    int cost;
    int era;
    int icon;
    int xpos;
    int ypos;
    int num_required = 0;
    int[] required = new int[4];
    byte[] flags = new byte[3];
    boolean era_req;
    Vector enables = new Vector();
    Vector units = new Vector();
    Vector buildings = new Vector();
    Vector obsBuildings = new Vector();
    TechButton button;
    boolean moved = true;

    Tech(DataInputStream dataInputStream) throws Exception {
        dataInputStream.skip(4L);
        this.name = Utils.readString(dataInputStream, 32);
        this.civpedia_entry = Utils.readString(dataInputStream, 32);
        byte[] byArray = new byte[4];
        Utils.readBackwards(dataInputStream, byArray);
        this.cost = Utils.parseBytes(byArray);
        Utils.readBackwards(dataInputStream, byArray);
        this.era = Utils.parseBytes(byArray);
        Utils.readBackwards(dataInputStream, byArray);
        this.icon = Utils.parseBytes(byArray);
        Utils.readBackwards(dataInputStream, byArray);
        this.xpos = Utils.parseBytes(byArray);
        Utils.readBackwards(dataInputStream, byArray);
        this.ypos = Utils.parseBytes(byArray);
        int n = 0;
        while (n < 4) {
            Utils.readBackwards(dataInputStream, byArray);
            this.required[n] = Utils.parseBytes(byArray);
            if (this.required[n] >= 0) {
                ++this.num_required;
            }
            ++n;
        }
        dataInputStream.read(this.flags);
        this.era_req = (this.flags[2] | 2) != 0;
        dataInputStream.skip(1L);
    }

    Tech() {
    }

    void write(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeBytes(this.name);
        Utils.writeBytes(32 - this.name.length(), dataOutputStream);
        dataOutputStream.writeBytes(this.civpedia_entry);
        Utils.writeBytes(32 - this.civpedia_entry.length(), dataOutputStream);
        byte[] byArray = new byte[4];
        Utils.toBytes(this.cost, byArray);
        dataOutputStream.write(byArray);
        dataOutputStream.writeByte(this.era);
        Utils.writeBytes(3, dataOutputStream);
        Utils.toBytes(this.icon, byArray);
        dataOutputStream.write(byArray);
        Utils.toBytes(this.xpos, byArray);
        dataOutputStream.write(byArray);
        Utils.toBytes(this.ypos, byArray);
        dataOutputStream.write(byArray);
        int n = 0;
        while (n < 4) {
            if (this.required[n] < 0) {
                dataOutputStream.writeInt(-1);
            } else {
                Tech tech = BrowserGUI.techs[this.required[n]];
                if (!tech.name.equals(Main.firstTech) && this.required[n] >= 0) {
                    Utils.toBytes(this.required[n], byArray);
                    dataOutputStream.write(byArray);
                } else {
                    dataOutputStream.writeInt(-1);
                }
            }
            ++n;
        }
        dataOutputStream.write(this.flags);
        Utils.writeBytes(1, dataOutputStream);
    }

    public String toString() {
        String string = "Name (ID) : " + this.name + " (#" + this.ID + ")\n";
        string = string + "Civilopedia entry : " + this.civpedia_entry + "\n";
        string = string + "Cost : " + this.cost + "\n";
        string = string + "Total cost : " + this.getTotalCost(new Vector()) + "\n";
        string = string + "\nRequired advances : " + this.num_required + "\n";
        int n = 0;
        while (n < 4) {
            if (this.required[n] >= 0) {
                string = string + "\t" + BrowserGUI.techs[this.required[n]].name + "\n";
            }
            ++n;
        }
        string = string + "\nNew advances : " + this.enables.size() + "\n";
        int n2 = 0;
        while (n2 < this.enables.size()) {
            Tech tech = (Tech)this.enables.elementAt(n2);
            string = string + "\t" + tech.name + "\n";
            ++n2;
        }
        string = string + "\nNew units : " + this.units.size() + "\n";
        int n3 = 0;
        while (n3 < this.units.size()) {
            Unit unit = (Unit)this.units.elementAt(n3);
            string = string + "\t" + unit.toString() + "\n";
            ++n3;
        }
        string = string + "\nNew improvements : " + this.buildings.size() + "\n";
        int n4 = 0;
        while (n4 < this.buildings.size()) {
            Building building = (Building)this.buildings.elementAt(n4);
            string = string + "\t" + building.name + "\n";
            ++n4;
        }
        string = string + "\nObsolete wonders : " + this.obsBuildings.size() + "\n";
        int n5 = 0;
        while (n5 < this.obsBuildings.size()) {
            Building building = (Building)this.obsBuildings.elementAt(n5);
            string = string + "\t" + building.name + "\n";
            ++n5;
        }
        return string;
    }

    int getTotalCost(Vector vector) {
        int n;
        int n2 = this.cost;
        int n3 = 0;
        while (n3 < this.num_required) {
            n = 0;
            int n4 = 0;
            while (n4 < vector.size() && n == 0) {
                int n5 = (Integer)vector.elementAt(n4);
                n = n5 == this.required[n3] ? 1 : 0;
                ++n4;
            }
            if (n == 0) {
                vector.addElement(new Integer(this.required[n3]));
                n2 += BrowserGUI.techs[this.required[n3]].getTotalCost(vector);
            }
            ++n3;
        }
        if (this.num_required == 0 && this.era > 0) {
            n = 0;
            while (n < this.era) {
                n2 += BrowserGUI.getEraCost(n);
                ++n;
            }
        }
        return n2;
    }

    static void setEnabledTechs(Vector vector) {
        int n = vector.size();
        Object[] objectArray = new Object[n];
        vector.copyInto(objectArray);
        Tech[] techArray = new Tech[n];
        int n2 = 0;
        while (n2 < n) {
            techArray[n2] = (Tech)objectArray[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            int n4 = 0;
            while (n4 < 4) {
                if (techArray[n3].required[n4] >= 0) {
                    techArray[techArray[n3].required[n4]].enables.addElement(techArray[n3]);
                    boolean bl = false;
                } else if (n4 == 0 && techArray[n3].era == 0) {
                    techArray[n - 1].enables.addElement(techArray[n3]);
                    techArray[n3].required[n4] = n - 1;
                    techArray[n3].num_required = 1;
                }
                ++n4;
            }
            ++n3;
        }
    }

    static void setEnabledUnits(Vector vector) {
        int n = Main.techs.size();
        Object[] objectArray = new Object[n];
        Main.techs.copyInto(objectArray);
        Tech[] techArray = new Tech[n];
        int n2 = 0;
        while (n2 < n) {
            techArray[n2] = (Tech)objectArray[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            Unit unit = (Unit)vector.elementAt(n3);
            if (unit.techID >= 0) {
                techArray[unit.techID].units.addElement(unit);
            } else {
                unit.techID = n - 1;
                techArray[n - 1].units.addElement(unit);
            }
            ++n3;
        }
    }

    static void setBuildings(Vector vector) {
        int n = Main.techs.size();
        Object[] objectArray = new Object[n];
        Main.techs.copyInto(objectArray);
        Tech[] techArray = new Tech[n];
        int n2 = 0;
        while (n2 < n) {
            techArray[n2] = (Tech)objectArray[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            Building building = (Building)vector.elementAt(n3);
            if (building.reqTech >= 0) {
                techArray[building.reqTech].buildings.addElement(building);
            } else {
                building.reqTech = n - 1;
                techArray[n - 1].buildings.addElement(building);
            }
            if (building.obsTech >= 0) {
                techArray[building.obsTech].obsBuildings.addElement(building);
            }
            ++n3;
        }
    }
}

