/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class BrowserGUI
extends Panel
implements KeyListener {
    private int xstart = 25;
    private int xstep = 110;
    private int ystart = 100;
    private int ystep = (int)((double)TechButton.height * 1.75);
    private int currentEra;
    private int currentTech;
    private int num_techs;
    static Tech[] techs;
    private Vector addedTechs = new Vector();
    private Vector lines = new Vector();
    private int[] yvalues = new int[20];
    int width;
    int height;
    static int DEFAULT_WIDTH;
    static int DEFAULT_HEIGHT;

    BrowserGUI(Vector vector) {
        this.setLayout(null);
        this.addKeyListener(this);
        this.setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
        this.setTechs(vector);
        if (this.num_techs > 0) {
            this.setEra(0);
        }
    }

    public Component add(Component component) {
        Component component2 = super.add(component);
        if (component instanceof TechButton) {
            component.addKeyListener(this);
        }
        return component2;
    }

    void setTechs(Vector vector) {
        this.num_techs = vector.size();
        techs = new Tech[this.num_techs];
        int n = 0;
        while (n < this.num_techs) {
            BrowserGUI.techs[n] = (Tech)vector.elementAt(n);
            ++n;
        }
    }

    void setEra(int n) {
        this.removeAll();
        this.setLocation(0, 0);
        this.addedTechs.removeAllElements();
        this.lines.removeAllElements();
        int n2 = 0;
        while (n2 < this.num_techs) {
            if (BrowserGUI.techs[n2].era == n) {
                TechButton techButton;
                Tech tech = techs[n2];
                TechButton techButton2 = new TechButton(tech, this.xstart, this.yvalues[0]);
                this.add(techButton2);
                this.addedTechs.addElement(techButton2);
                System.out.println("Added " + tech.name);
                int n3 = 0;
                while (n3 < tech.num_required) {
                    TechButton techButton3 = new TechButton(techs[tech.required[n3]], 0, 0);
                    if (this.addedTechs.contains(techButton3)) {
                        int n4 = this.addedTechs.indexOf(techButton3);
                        techButton = (TechButton)this.addedTechs.elementAt(n4);
                        this.lines.addElement(new Line(techButton2, techButton));
                    }
                    ++n3;
                }
                int n5 = 0;
                while (n5 < tech.enables.size()) {
                    Tech tech2 = (Tech)tech.enables.elementAt(n5);
                    techButton = new TechButton(tech2, 0, 0);
                    if (this.addedTechs.contains(techButton)) {
                        int n6 = this.addedTechs.indexOf(techButton);
                        TechButton techButton4 = (TechButton)this.addedTechs.elementAt(n6);
                        this.lines.addElement(new Line(techButton4, techButton2));
                    }
                    ++n5;
                }
            }
            ++n2;
        }
        this.currentEra = n;
    }

    void arrangeTechs() {
        int n = this.currentEra;
        this.removeAll();
        this.setLocation(0, 0);
        this.addedTechs.removeAllElements();
        this.lines.removeAllElements();
        this.yvalues = new int[20];
        int n2 = 0;
        while (n2 < this.yvalues.length) {
            this.yvalues[n2] = this.ystart;
            ++n2;
        }
        this.currentEra = n;
        Vector<Tech> vector = new Vector<Tech>();
        int n3 = 0;
        while (n3 < this.num_techs) {
            if (BrowserGUI.techs[n3].era == n && BrowserGUI.techs[n3].required[0] < 0) {
                vector.addElement(techs[n3]);
            }
            ++n3;
        }
        int n4 = 500 / this.ystep / vector.size();
        if (n4 == 0) {
            n4 = 1;
        }
        int n5 = 0;
        while (n5 < vector.size()) {
            Tech tech = (Tech)vector.elementAt(n5);
            TechButton techButton = new TechButton(tech, this.xstart, this.yvalues[0], true);
            this.add(techButton);
            this.addedTechs.addElement(techButton);
            System.out.println("Added " + tech.name);
            if (tech.enables.size() > 0) {
                this.addTechs(1, techButton);
            }
            this.yvalues[0] = this.yvalues[0] + this.ystep * n4;
            ++n5;
        }
        this.setSize();
    }

    public void setSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.addedTechs.size()) {
            TechButton techButton = (TechButton)this.addedTechs.elementAt(n3);
            if (techButton.x > n) {
                n = techButton.x;
            }
            if (techButton.y > n2) {
                n2 = techButton.y;
            }
            ++n3;
        }
        this.width = n + TechButton.width / 2 + this.xstart;
        this.height = n2 + TechButton.height / 2 + this.ystart;
        if (this.width > this.getSize().width) {
            this.width = this.getSize().width;
        }
        if (this.height > this.getSize().height) {
            this.height = this.getSize().height;
        }
        Main.mg.adjustScrollbars();
    }

    private void addTechs(int n, TechButton techButton) {
        Tech tech = techButton.tech;
        int n2 = this.xstart + n * this.xstep;
        int n3 = 0;
        while (n3 < tech.enables.size()) {
            Tech tech2 = (Tech)tech.enables.elementAt(n3);
            int n4 = this.yvalues[n];
            while (techButton.y > this.yvalues[n] + 1 * this.ystep) {
                int n5 = n;
                this.yvalues[n5] = this.yvalues[n5] + this.ystep;
            }
            TechButton techButton2 = new TechButton(tech2, n2, this.yvalues[n]);
            int n6 = this.addedTechs.indexOf(techButton2);
            TechButton techButton3 = null;
            if (n6 >= 0) {
                techButton3 = (TechButton)this.addedTechs.elementAt(n6);
                if (techButton3.x < n2) {
                    techButton3.setLocation(n2, this.yvalues[n], true);
                    int n7 = n;
                    this.yvalues[n7] = this.yvalues[n7] + this.ystep;
                    System.out.println("x-Moved " + techButton3.tech.name + "[" + tech.name + "]");
                }
                if (techButton3.y < n4) {
                    // empty if block
                }
            }
            if (this.addedTechs.indexOf(techButton2) < 0) {
                techButton2.setLocation(n2, this.yvalues[n], true);
                this.add(techButton2);
                this.addedTechs.addElement(techButton2);
                this.addTechs(n + 1, techButton2);
                this.lines.addElement(new Line(techButton2, techButton));
                int n8 = n;
                this.yvalues[n8] = this.yvalues[n8] + this.ystep;
            } else {
                System.out.println("Skipping " + tech2.name + "[" + tech.name + "]");
                this.lines.addElement(new Line(techButton3, techButton));
            }
            ++n3;
        }
    }

    static int getEraCost(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < techs.length) {
            if (BrowserGUI.techs[n3].era == n && BrowserGUI.techs[n3].era_req) {
                n2 += BrowserGUI.techs[n3].cost;
            }
            ++n3;
        }
        return n2;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.width, this.height);
        graphics.setColor(Color.black);
        int n = 0;
        while (n < this.addedTechs.size()) {
            TechButton techButton = (TechButton)this.addedTechs.elementAt(n);
            techButton.repaint();
            ++n;
        }
        int n2 = 0;
        while (n2 < this.lines.size()) {
            Line line = (Line)this.lines.elementAt(n2);
            line.paint(graphics);
            ++n2;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            int n = Integer.parseInt(new String(new char[]{keyEvent.getKeyChar()}));
            if (n >= 1 && n <= Main.eras.size()) {
                this.setEra(n - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    static {
        DEFAULT_WIDTH = 2000;
        DEFAULT_HEIGHT = 1500;
    }
}

