/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class MainGUI
extends Frame
implements AdjustmentListener,
ComponentListener {
    private Panel center;
    private Scrollbar hor;
    private Scrollbar ver;
    private MGMenu menu;
    BrowserGUI bg;
    HelpFrame help;
    AboutDialog about;

    MainGUI() {
        super("Civ 3 tech browser - " + Main.file);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.addComponentListener(this);
        this.menu = new MGMenu();
        this.setMenuBar(this.menu);
        this.help = new HelpFrame();
        this.about = new AboutDialog(this);
        this.bg = new BrowserGUI(Main.techs);
        this.addKeyListener(this.bg);
        this.hor = new Scrollbar(0);
        this.ver = new Scrollbar(1);
        this.hor.setBlockIncrement(100);
        this.ver.setBlockIncrement(100);
        this.hor.setUnitIncrement(10);
        this.ver.setUnitIncrement(10);
        this.hor.setMaximum(0);
        this.ver.setMaximum(0);
        this.hor.addAdjustmentListener(this);
        this.ver.addAdjustmentListener(this);
        this.center = new Panel(null);
        this.center.add(this.bg);
        this.add("Center", this.center);
        this.add("South", this.hor);
        this.add("East", this.ver);
        ((Component)this).setSize(800, 600);
        this.show();
    }

    void arrangeTechs() {
        if (Main.techs.size() > 0) {
            this.bg.arrangeTechs();
            this.bg.repaint();
        }
    }

    void setEra(int n) {
        this.bg.setEra(n);
        this.bg.repaint();
    }

    void adjustScrollbars() {
        this.ver.setValues(this.ver.getValue(), this.center.getSize().height, 0, this.bg.height);
        this.hor.setValues(this.hor.getValue(), this.center.getSize().width, 0, this.bg.width);
        this.bg.setLocation(-this.hor.getValue(), -this.ver.getValue());
    }

    void setFile(String string) {
        try {
            Main.file = string;
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            if (!Main.checkFile(dataInputStream)) {
                throw new Exception("That is not a valid bic-file");
            }
            if (!Main.loadBuildings(dataInputStream)) {
                throw new Exception("Couldn't read buildings from file");
            }
            if (!Main.loadEras(dataInputStream)) {
                throw new Exception("Couldn't read eras from file");
            }
            if (!Main.loadUnits(dataInputStream)) {
                throw new Exception("Couldn't read units from file");
            }
            if (!Main.loadTechs(dataInputStream)) {
                throw new Exception("Couldn't read advances from file");
            }
            dataInputStream.close();
            this.menu.setEras();
            Tech.setEnabledUnits(Main.units);
            Tech.setBuildings(Main.buildings);
            this.bg.setTechs(Main.techs);
            this.bg.setEra(0);
            this.bg.repaint();
            this.setTitle("Civ 3 tech browser - " + string);
            System.out.println("TECH at:" + Main.techPos);
            System.out.println("Remainder :" + Main.remainder);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void saveToFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            Main.saveTechs(dataOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.bg.setLocation(-this.hor.getValue(), -this.ver.getValue());
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.adjustScrollbars();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

