/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.util.Vector;

public class Main {
    static MainGUI mg;
    static String file;
    static Vector techs;
    static Vector units;
    static Vector buildings;
    static Vector eras;
    static byte[] current;
    static byte[] techFind;
    static byte[] unitFind;
    static byte[] buildingFind;
    static int techPos;
    static int remainder;
    static String firstTech;
    static String lastTech;

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            // empty if block
        }
        if (stringArray.length == 1) {
            file = stringArray[0];
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            Main.loadBuildings(dataInputStream);
            Main.loadEras(dataInputStream);
            Main.loadUnits(dataInputStream);
            Main.loadTechs(dataInputStream);
            dataInputStream.close();
            Tech.setEnabledUnits(units);
            Tech.setBuildings(buildings);
        }
        mg = new MainGUI();
    }

    public static boolean checkFile(DataInputStream dataInputStream) {
        try {
            byte[] byArray = new byte[3];
            int n = 0;
            while (n < 3) {
                byArray[n] = dataInputStream.readByte();
                System.out.println(byArray[n]);
                ++n;
            }
            dataInputStream.readByte();
            techPos += 4;
            String string = new String(byArray);
            System.out.println(string);
            return string.equals("BIC");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean loadTechs(DataInputStream dataInputStream) {
        try {
            Tech tech;
            int n;
            techs = new Vector();
            boolean bl = false;
            while (!bl) {
                n = 0;
                while (n < 4) {
                    Main.current[n] = dataInputStream.readByte();
                    ++n;
                    ++techPos;
                }
                bl = Utils.compare(techFind, current);
            }
            techPos -= 4;
            n = dataInputStream.readByte();
            dataInputStream.skip(3L);
            int n2 = 0;
            while (n2 < n) {
                tech = new Tech(dataInputStream);
                tech.ID = n2++;
                techs.addElement(tech);
            }
            tech = new Tech();
            tech.name = firstTech;
            tech.civpedia_entry = "None";
            tech.ID = techs.size();
            tech.required[0] = -1;
            tech.required[1] = -1;
            tech.required[2] = -1;
            tech.required[3] = -1;
            techs.addElement(tech);
            Tech.setEnabledTechs(techs);
            remainder = dataInputStream.available();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean loadUnits(DataInputStream dataInputStream) throws Exception {
        try {
            int n;
            units = new Vector();
            boolean bl = false;
            while (!bl) {
                n = 0;
                while (n < 4) {
                    Main.current[n] = dataInputStream.readByte();
                    ++n;
                    ++techPos;
                }
                bl = Utils.compare(unitFind, current);
            }
            n = dataInputStream.readByte();
            dataInputStream.skip(3L);
            techPos += 4;
            int n2 = 0;
            while (n2 < n) {
                techPos += 156;
                techPos += 4;
                Unit unit = new Unit(dataInputStream);
                units.addElement(unit);
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean loadBuildings(DataInputStream dataInputStream) {
        try {
            int n;
            buildings = new Vector();
            boolean bl = false;
            while (!bl) {
                n = 0;
                while (n < 4) {
                    Main.current[n] = dataInputStream.readByte();
                    ++n;
                    ++techPos;
                }
                bl = Utils.compare(buildingFind, current);
            }
            n = dataInputStream.readByte();
            dataInputStream.skip(3L);
            techPos += 4;
            int n2 = 0;
            while (n2 < n) {
                techPos += 252;
                techPos += 4;
                Building building = new Building(dataInputStream);
                buildings.addElement(building);
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean loadEras(DataInputStream dataInputStream) {
        try {
            int n;
            eras = new Vector();
            boolean bl = false;
            while (!bl) {
                n = 0;
                while (n < 4) {
                    Main.current[n] = dataInputStream.readByte();
                    ++n;
                    ++techPos;
                }
                bl = Utils.compare("ERAS".getBytes(), current);
            }
            n = dataInputStream.readByte();
            dataInputStream.skip(3L);
            techPos += 4;
            int n2 = 0;
            while (n2 < n) {
                dataInputStream.skip(4L);
                String string = Utils.readString(dataInputStream, 64);
                dataInputStream.skip(196L);
                eras.addElement(string);
                techPos += 264;
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static void saveTechs(DataOutputStream dataOutputStream) throws Exception {
        FileInputStream fileInputStream = new FileInputStream(file);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        int n = techPos;
        byte[] byArray = new byte[techPos];
        dataInputStream.readFully(byArray);
        dataInputStream.skip(4L);
        n += 4;
        int n2 = dataInputStream.readByte();
        dataInputStream.skip(3L);
        n += 4;
        byte[] byArray2 = new byte[4];
        Utils.readBackwards(dataInputStream, byArray2);
        int n3 = Utils.parseBytes(byArray2);
        n += 4;
        dataInputStream.skip(n3);
        n += n3;
        int n4 = 1;
        while (n4 < n2) {
            dataInputStream.skip(n3 + 4);
            n += n3 + 4;
            ++n4;
        }
        System.out.println("Tech ended at pos:" + n);
        byte[] byArray3 = new byte[remainder];
        dataInputStream.readFully(byArray3);
        dataOutputStream.write(byArray);
        dataOutputStream.writeBytes("TECH");
        dataOutputStream.writeByte(techs.size() - 1);
        Utils.writeBytes(3, dataOutputStream);
        byArray2 = new byte[4];
        int n5 = 0;
        while (n5 < techs.size() - 1) {
            Utils.toBytes(104, byArray2);
            dataOutputStream.write(byArray2);
            Tech tech = (Tech)techs.elementAt(n5);
            tech.write(dataOutputStream);
            ++n5;
        }
        dataOutputStream.write(byArray3);
    }

    static {
        file = "";
        techs = new Vector();
        units = new Vector();
        buildings = new Vector();
        eras = new Vector();
        current = new byte[4];
        techFind = "TECH".getBytes();
        unitFind = "PRTO".getBytes();
        buildingFind = "BLDG".getBytes();
        techPos = 0;
        remainder = 0;
        firstTech = "Start";
        lastTech = "End";
    }
}

