package ctp2.goods;

import java.io.*;
import ctp2.tools.*;
/**
 * Insert the type's description here.
 * Creation date: (06-12-01 22:23:43)
 * @author: Administrator
 */
public class GoodsParser {
  private final static java.lang.String GOODSTXTPATH =
    "/ctp2_data/default/gamedata/goods.txt";
  private static GoodsContainer goodsContainer;
  /**
   * GoodsParser constructor (never used).
   */
  private GoodsParser() {
    super();
  }
  /**
  * makes a new goods and sets its name to the 
  * given string, then returns the building to sender.
  * Creation date: (24-11-01 19:11:18)
  * @param nameToken java.lang.String
  */
  private static Good parseGoodNameToken(String nameToken) {
    Verbose.message(
      "GoodsParser: parseGoodToken: making new Good with the name: "
        + nameToken);
    Good g = new Good();
    g.setName(nameToken);
    return g;
  }
  /**
  * This method starts the parsing of Goods.txt 
  * and returns a container with the result
  * after the parsing ends.
  * Creation date: (27-11-01 22:36:37)
  * @return ctp2.unit.GoodsContainer
  * @param rootPath java.lang.String
  */
  public static GoodsContainer parseGoods(String rootPath) {
    goodsContainer = new GoodsContainer(); // new GoodsContainer made
    StreamTokenizer s = readFile(rootPath + GOODSTXTPATH); // file grabbed
    String t = readNextToken(s); // getting the very first token from file
    while (t != "EOF") { // repeats until End Of File
      Verbose.message("GoodsParser: parseGoods: Starting a new good.");
      Good g = parseGoodNameToken(t); // make a new Good and set the name
      s = parseGoodTokens(g, s); // parse all the Goods attributes
      t = readNextToken(s); // get the next token for EOF testing and so the next name is ready for parsing
    }
    Verbose.message("BuildingParser: parseBuildings: EOF reached: terminating parser");
    return goodsContainer; // full GoodsContainer returned to sender
  }
/**
 * Insert the method's description here.
 * Creation date: (06-12-01 22:42:17)
 * @return java.io.StreamTokenizer
 * @param b ctp2.goods.Good
 * @param s java.io.StreamTokenizer
 */
private static StreamTokenizer parseGoodTokens(Good g, StreamTokenizer s) {
  String t = new String("");
  while (true) {
    t = readNextToken(s);
    Verbose.message("GoodsParser: parseGoodTokens: to be processed: " + t);
    if (t.equals("{")) { // start of every Good
      Verbose.message("GoodsParser: parseGoodTokens: { reached.");
      continue;
    }
    // start contents here
	else if (t.equals("Sound")) {
		g.setSound(readNextToken(s));
		continue;
	}
	else if (t.equals("Icon")) {
		g.setIcon(readNextToken(s));
		continue;
	}
	else if (t.equals("SpriteID")) {
		g.setSpriteID(readNextIntToken(s));
		continue;
	}
	else if (t.equals("Gold")) {
		g.setGold(readNextIntToken(s));
		continue;
	}
	else if (t.equals("Probability")) {
		g.setProbability(readNextDoubleToken(s));
		continue;
	}
	else if (t.equals("GLHidden")) {
		g.setGlHidden(true);
		continue;
	}
	else if (t.equals("NoIndex")) {
		g.setNoIndex(true);
		continue;
	}
    // end contents here
    else if (t.equals("}")) { // stop makin this Good at the right time
      Verbose.message("GoodsParser: parseGoodTokens: Good done, adding to container");
      goodsContainer.addGood(g); // add the Good to container
      break;
    }
    else if (t.equals("EOF")) { // stops if end of file is reached
      Verbose.message("GoodsParser: parseGoodTokens: EOF");
      break;
    }
    else {
      Verbose.message("GoodsParser: parseGoodTokens: "+t+" is not an expected token");
      continue;
    }
  }
  return s;
}
  /**
   * this method initiates the filreading with the relavant 
   * parameters and returns a stream ready to use.
   * Creation date: (27-11-01 22:28:47)
   */
  private static StreamTokenizer readFile(String path) {
    Verbose.message("readFile: Starting filereader");
    try {
      File f = new File(path);
      StreamTokenizer ind =
        new StreamTokenizer(
          new BufferedReader(new InputStreamReader(new FileInputStream(f))));
      ind.commentChar('#');
      ind.wordChars(':', '}');
      ind.eolIsSignificant(false);
      ind.lowerCaseMode(false);
      ind.parseNumbers();
      ind.slashSlashComments(true);
      ind.slashStarComments(true);
      return ind;
    }
    catch (FileNotFoundException e) {
      Verbose.message("readFile: file was not found " + e.getMessage());
      return null;
    }
  }
  /**
   * reads and returns the next token.
   * should only be called if a double is expected.
   * Creation date: (21-11-01 17:40:08)
   */
  private static double readNextDoubleToken(StreamTokenizer aStream) {
    try {
      Verbose.message("readNextDoubleToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_NUMBER) {
        Verbose.message(
          "readNextDoubleToken: " + aStream.nval + " returned");
        return aStream.nval;
      }
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("readNextDoubleToken: EOF reached");
        return 0.0;
      }
      else {
        Verbose.message(
          "readNextDoubleToken: dont know what happened "
            + aStream.sval
            + " "
            + aStream.nval);
        return 0.0;
      }
    }
    catch (IOException e) {
      Verbose.message(
        "readNextDoubleToken: IO didn't do well " + e.getMessage());
      return 0.0;
    }
  }
  /**
   * reads and returns the next token.
   * should only be used if an int is expected.
   * Creation date: (21-11-01 17:40:08)
   */
  private static int readNextIntToken(StreamTokenizer aStream) {
    try {
      Verbose.message("readNextIntToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_NUMBER) {
        Double d = new Double(aStream.nval);
        Verbose.message("readNextIntToken: " + d.intValue() + " returned");
        return d.intValue();
      }
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("readNextIntToken: EOF reached");
        return 0;
      }
      else {
        Verbose.message(
          "readNextIntToken: dont know what happened "
            + aStream.sval
            + " "
            + aStream.nval);
        return 0;
      }
    }
    catch (IOException e) {
      Verbose.message(
        "readNextIntToken: IO didn't do well " + e.getMessage());
      return 0;
    }
  }
  /**
   * reads and returns the next token.
   * should be used if a String is expected
   * or if you dont know what is expected.
   * Creation date: (21-11-01 17:40:08)
   */
  private static java.lang.String readNextToken(StreamTokenizer aStream) {
    try {
      Verbose.message("readNextToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_WORD) {
        Verbose.message("readNextToken: " + aStream.sval + " returned");
        return aStream.sval;
      }
      //else 
      //if (aStream.ttype == aStream.TT_NUMBER) {
      //  Double d = new Double(aStream.nval);
      //  Verbose.message("AdvanceParser: readNextIntToken: " + d.intValue() + " returned");
      //  return d.intValue();
      //}
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("readNextToken: EOF reached");
        return "EOF";
      }
      else if (aStream.sval == null) {
        Verbose.message("readNextToken: this " + aStream.sval + " is done");
        aStream.nextToken();
        return aStream.sval;
      }
      else {
        Verbose.message(
          "readNextToken: dont know what happened "
            + aStream.sval
            + " "
            + aStream.nval);
        return null;
      }
    }
    catch (IOException e) {
      Verbose.message(
        "readNextToken: IO didn't do well " + e.getMessage());
      return null;
    }
  }
}
