package ctp2.terrain;

import java.io.*;
import ctp2.tools.*;
/**
 * Insert the type's description here.
 * Creation date: (19-12-01 16:34:45)
 * @author: Administrator
 */
public class TerrainParser {
	private static TerrainContainer terrainContainer;
	private final static java.lang.String TERRAINTXTPATH =
    "/ctp2_data/default/gamedata/terrain.txt";
/**
 * TerrainParser constructor (never used).
 */
private TerrainParser() {
	super();
}
/**
 * This method starts the parsing of Terrain.txt 
 * and returns a TerrainContainer with the result
 * after the parsing ends.
 * Creation date: (19-12-01 16:37:59)
 * @return ctp2.terrain.TerrainContainer
 * @param java.lang.String rootPath
 */
public static TerrainContainer parseTerrain(java.lang.String rootPath) {
    terrainContainer = new TerrainContainer(); // new TerrainContainer made
    StreamTokenizer s = readFile(rootPath + TERRAINTXTPATH); // file grabbed
    String t = readNextToken(s); // getting the very first token from file
    while (t != "EOF") { // repeats until End Of File
      Verbose.message("TerrainParser: parseTerrain: Starting a new Terrain.");
      Terrain b = parseTerrainNameToken(t); // make a new Terrain and set the name
      s = parseTerrainTokens(b, s); // parse all the buildings attributes
      t = readNextToken(s); // get the next token for EOF testing and so the next name is ready for parsing
    }
    Verbose.message("TerrainParser: parseTerrain: EOF reached: terminating parser");
    return terrainContainer; // full TerrainContainer returned to sender
}
/**
 * Insert the method's description here.
 * Creation date: (19-12-01 17:27:59)
 */
private static StreamTokenizer parseTerrainEnv(Env e, StreamTokenizer s) {
  String t = new String("");
  while (true) {
    t = readNextToken(s);
    Verbose.message("TerrainParser: parseTerrainEnv: to be processed: " + t);
    if (t.equals("{")) { // start of every TerrainEnv 
      Verbose.message("TerrainParser: parseTerrainEnv: { reached.");
      continue;
    }
    else if (t.equals("Defense")) {
	    e.setDefense(readNextDoubleToken(s));
	    continue;
    }
	else if (t.equals("Score")) {
	    e.setScore(readNextIntToken(s));
	    continue;
    }else if (t.equals("Food")) {
	    e.setFood(readNextIntToken(s));
	    continue;
    }else if (t.equals("Shield")) {
	    e.setShield(readNextIntToken(s));
	    continue;
    }else if (t.equals("Gold")) {
	    e.setGold(readNextIntToken(s));
	    continue;
    }else if (t.equals("Movement")) {
	    e.setMovement(readNextIntToken(s));
	    continue;
    }else if (t.equals("Freight")) {
	    e.setFreight(readNextIntToken(s));
	    continue;
    }else if (t.equals("DeadFood")) {
	    e.setDeadFood(readNextIntToken(s));
	    continue;
    }else if (t.equals("DeadShield")) {
	    e.setDeadShield(readNextIntToken(s));
	    continue;
    }else if (t.equals("DeadGold")) {
	    e.setDeadGold(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("}")) { // stop makin this TerrainEnv at the right time
      Verbose.message("TerrainParser: parseTerrainEnv: Env done");
      //terrainContainer.addTerrain(b); // add the Terrain to container
      break;
    }
    else if (t.equals("EOF")) { // stops if end of file is reached
      Verbose.message("TerrainParser: parseTerrainEnv: EOF");
      break;
    }
    else {
      Verbose.message("TerrainParser: parseTerrainEnv: "+t+" is not an expected token");
      continue;
    }
  }
  return s;
}
  /**
  * makes a new building and sets its name to the 
  * given string, then returns the building to sender.
  * Creation date: (24-11-01 19:11:18)
  * @param nameToken java.lang.String
  */
  private static Terrain parseTerrainNameToken(String nameToken) {
    Verbose.message(
      "TerrainParser: parseNameToken: making new Terrain with the name: "
        + nameToken);
    Terrain b = new Terrain();
    b.setName(nameToken);
    return b;
  }
/**
 * Insert the method's description here.
 * Creation date: (06-12-01 22:42:17)
 * @return java.io.StreamTokenizer
 * @param b ctp2.terrain.Terrain
 * @param s java.io.StreamTokenizer
 */
private static StreamTokenizer parseTerrainTokens(Terrain b, StreamTokenizer s) {
  String t = new String("");
  while (true) {
    t = readNextToken(s);
    Verbose.message("TerrainParser: parseTerrainTokens: to be processed: " + t);
    if (t.equals("{")) { // start of every Terrain 
      Verbose.message("TerrainParser: parseTerrainTokens: { reached.");
      continue;
    }
    // start contents here
    else if (t.equals("TilesetIndex")) {
	    b.setTilesetIndex(readNextIntToken(s));
	    continue;
    }else if (t.equals("Icon")) {
	    b.setIcon(readNextToken(s));
	    continue;
    }else if (t.equals("InternalType:")) {
	    b.setInternalType(readNextToken(s));
	    continue;
    }else if (t.equals("CanDie")) {
	    b.setCanDie(true);
	    continue;
    }else if (t.equals("GLHidden")) {
	    b.setGlHidden(true);
	    continue;
    }else if (t.equals("NoIndex")) {
	    b.setNoIndex(true);
	    continue;
    }else if (t.equals("AddAdvance")) {
	    b.setAddAdvance(readNextToken(s));
	    continue;
    }else if (t.equals("TransformAdd")) {
	    readNextToken(s); //dump {
	    Transform trans = new Transform();
	    while(true) {
		    t = readNextToken(s);
		    if (t.equals("Time")) {
				trans.setTime(readNextIntToken(s));
				continue;
		    }
		    else if (t.equals("Materials")) {
				trans.setMaterials(readNextIntToken(s));
				continue;
		    }
		    else if (t.equals("}")) {
				break;
		    }
		    else {
			    Verbose.message("TrasformAdd: illigal token "+t+", Ending loop");
			    break;
		    }
	    }
	    b.setTransformAdd(trans);
    }
    else if (t.equals("RemoveAdvance")) {
	    b.setRemoveAdvance(readNextToken(s));
	    continue;
    }
    else if (t.equals("TransformRemove")) {
	    readNextToken(s); //dump "{"
	    Transform trans = new Transform();
	    while(true) {
		    t = readNextToken(s);
		    if (t.equals("Time")) {
				trans.setTime(readNextIntToken(s));
				continue;
		    }
		    else if (t.equals("Materials")) {
				trans.setMaterials(readNextIntToken(s));
				continue;
		    }
		    else if (t.equals("}")) {
				break;
		    }
		    else {
			    Verbose.message("TrasformRemove: illigal token. ending loop");
			    break;
		    }
	    }
	    b.setTransformRemove(trans);
    }
    else if (t.equals("EnvBase")) {
	    Env baseEnv = new Env();
	    s = parseTerrainEnv(baseEnv, s);
	    b.setEnvBase(baseEnv);
	    continue;
    }
    else if (t.equals("EnvCity")) {
	    Env cityEnv = new Env();
	    s = parseTerrainEnv(cityEnv, s);
	    b.setEnvCity(cityEnv);
	    continue;
    }
    else if (t.equals("EnvRiver")) {
	    Env riverEnv = new Env();
	    s = parseTerrainEnv(riverEnv, s);
	    b.setEnvRiver(riverEnv);
	    continue;
    }
    else if (t.equals("Resources")) {
	    b.addResources(readNextToken(s));
	    continue;
    }
    else if (t.equals("MovementType:")) {
	    b.addMovementType(readNextToken(s));
	    continue;
    }
    // end contents here
    else if (t.equals("}")) { // stop makin this Terrain at the right time
      Verbose.message("TerrainParser: parseTerrainTokens: Terrain done, adding to container");
      terrainContainer.addTerrain(b); // add the Terrain to container
      break;
    }
    else if (t.equals("EOF")) { // stops if end of file is reached
      Verbose.message("TerrainParser: parseTerrainTokens: EOF");
      break;
    }
    else {
      Verbose.message("TerrainParser: parseTerrainTokens: "+t+" is not an expected token");
      continue;
    }
  }
  return s;
}
  /**
   * this method initiates the filreading with the relavant 
   * parameters and returns a stream ready to use.
   * Creation date: (27-11-01 22:28:47)
   */
  private static StreamTokenizer readFile(String path) {
    Verbose.message("readFile: Starting filereader");
    try {
      File f = new File(path);
      StreamTokenizer ind =
        new StreamTokenizer(
          new BufferedReader(new InputStreamReader(new FileInputStream(f))));
      ind.commentChar('#');
      ind.wordChars(':', '}');
      ind.eolIsSignificant(false);
      ind.lowerCaseMode(false);
      ind.parseNumbers();
      ind.slashSlashComments(true);
      ind.slashStarComments(true);
      return ind;
    }
    catch (FileNotFoundException e) {
      Verbose.message("readFile: file was not found " + e.getMessage());
      return null;
    }
  }
  /**
   * reads and returns the next token.
   * should only be called if a double is expected.
   * Creation date: (21-11-01 17:40:08)
   */
  private static double readNextDoubleToken(StreamTokenizer aStream) {
    try {
      Verbose.message("readNextDoubleToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_NUMBER) {
        Verbose.message(
          "readNextDoubleToken: " + aStream.nval + " returned");
        return aStream.nval;
      }
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("readNextDoubleToken: EOF reached");
        return 0.0;
      }
      else {
        Verbose.message(
          "readNextDoubleToken: dont know what happened "
            + aStream.sval
            + " "
            + aStream.nval);
        return 0.0;
      }
    }
    catch (IOException e) {
      Verbose.message(
        "readNextDoubleToken: IO didn't do well " + e.getMessage());
      return 0.0;
    }
  }
  /**
   * reads and returns the next token.
   * should only be used if an int is expected.
   * Creation date: (21-11-01 17:40:08)
   */
  private static int readNextIntToken(StreamTokenizer aStream) {
    try {
      Verbose.message("readNextIntToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_NUMBER) {
        Double d = new Double(aStream.nval);
        Verbose.message("readNextIntToken: " + d.intValue() + " returned");
        return d.intValue();
      }
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("readNextIntToken: EOF reached");
        return 0;
      }
      else {
        Verbose.message(
          "readNextIntToken: dont know what happened "
            + aStream.sval
            + " "
            + aStream.nval);
        return 0;
      }
    }
    catch (IOException e) {
      Verbose.message(
        "readNextIntToken: IO didn't do well " + e.getMessage());
      return 0;
    }
  }
  /**
   * reads and returns the next token.
   * should be used if a String is expected
   * or if you dont know what is expected.
   * Creation date: (21-11-01 17:40:08)
   */
  private static java.lang.String readNextToken(StreamTokenizer aStream) {
    try {
      Verbose.message("readNextToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_WORD) {
        Verbose.message("readNextToken: " + aStream.sval + " returned");
        return aStream.sval;
      }
      //else 
      //if (aStream.ttype == aStream.TT_NUMBER) {
      //  Double d = new Double(aStream.nval);
      //  Verbose.message("AdvanceParser: readNextIntToken: " + d.intValue() + " returned");
      //  return d.intValue();
      //}
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("readNextToken: EOF reached");
        return "EOF";
      }
      else if (aStream.sval == null) {
        Verbose.message("readNextToken: this " + aStream.sval + " is done");
        aStream.nextToken();
        return aStream.sval;
      }
      else {
        Verbose.message(
          "readNextToken: dont know what happened "
            + aStream.sval
            + " "
            + aStream.nval);
        return null;
      }
    }
    catch (IOException e) {
      Verbose.message(
        "readNextToken: IO didn't do well " + e.getMessage());
      return null;
    }
  }
}
