package ctp2.wonder;

import java.io.*;
import ctp2.tools.*;
/**
 * Insert the type's description here.
 * Creation date: (08-12-01 13:16:33)
 * @author: Administrator
 */
public class WonderParser {
	private static WonderContainer wonderContainer;
	private final static java.lang.String WONDERTXTPATH = "/ctp2_data/default/gamedata/wonder.txt";
/**
 * WonderParser constructor comment.
 */
private WonderParser() {
	super();
}
  /**
  * makes a new Wonder and sets its name to the 
  * given string, then returns the Wonder to sender.
  * Creation date: (24-11-01 19:11:18)
  * @param nameToken java.lang.String
  */
  private static Wonder parseNameToken(String nameToken) {
    Verbose.message(
      "WonderParser: parseNameToken: making new building with the name: "
        + nameToken);
    Wonder w = new Wonder();
    w.setName(nameToken);
    return w;
  }
/**
 * Insert the method's description here.
 * Creation date: (09-12-01 19:54:25)
 * @return ctp2.wonder.WonderContainer
 * @param rootPath java.lang.String
 */
public static WonderContainer parseWonders(String rootPath) {
	wonderContainer = new WonderContainer();
	StreamTokenizer s = readFile(rootPath+WONDERTXTPATH);
	String t = readNextToken(s);
	while (t != "EOF") {
		Verbose.message("WonderParser: parseWonders: Starting a new Wonder.");
		Wonder w = parseNameToken(t);
		s = parseWonderTokens(w, s);
		t = readNextToken(s);
	}
	Verbose.message("WonderParser: parseWonders: EOF reached: terminating parser");
	return wonderContainer;
}
/**
 * Insert the method's description here.
 * Creation date: (06-12-01 22:42:17)
 * @return java.io.StreamTokenizer
 * @param b ctp2.wonder.Wonder
 * @param s java.io.StreamTokenizer
 */
private static StreamTokenizer parseWonderTokens(Wonder w, StreamTokenizer s) {
  String t = new String("");
  while (true) {
    t = readNextToken(s);
    Verbose.message("WonderParser: parseWonderTokens: to be processed: " + t);
    if (t.equals("{")) { // start of every Wonder 
      Verbose.message("WonderParser: parseWonderTokens: { reached.");
      continue;
    }
    // start contents here
    else if (t.equals("DefaultIcon")) {
	    w.setDefaultIcon(readNextToken(s));
	    continue;
    }else if (t.equals("Description")) {
	    w.setDescription(readNextToken(s));
	    continue;
    }else if (t.equals("Movie")) {
	    w.setMovie(readNextToken(s));
	    continue;
    }else if (t.equals("EnableAdvance")) {
	    w.setEnableAdvance(readNextToken(s));
	    continue;
    }else if (t.equals("ObsoleteAdvance")) {
	    w.setObsoleteAdvance(readNextToken(s));
	    continue;
    }else if (t.equals("BuildingEverywhere")) {
	    w.setBuildingEverywhere(readNextToken(s));
	    continue;
    }
    else if (t.equals("ProductionCost")) {
	    w.setProductionCost(readNextIntToken(s));
	    continue;
    }else if (t.equals("IncKnowledgePercent")) {
	    w.setIncKnowledgePercent(readNextIntToken(s));
	    continue;
    }else if (t.equals("DecCrimePercent")) {
	    w.setDecCrimePercent(readNextIntToken(s));
	    continue;
    }else if (t.equals("GoldPerInternationalTradeRoute")) {
	    w.setGoldPerInternationalTradeRoute(readNextIntToken(s));
	    continue;
    }else if (t.equals("GoldPerWaterTradeRoute")) {
	    w.setGoldPerWaterTradeRoute(readNextIntToken(s));
	    continue;
    }else if (t.equals("IncreaseBoatMovement")) {
	    w.setIncreaseBoatMovement(readNextIntToken(s));
	    continue;
    }else if (t.equals("TemporaryFullHappiness")) {
	    w.setTemporaryFullHappiness(readNextIntToken(s));
	    continue;
    }else if (t.equals("IncreaseRegard")) {
	    w.setIncreaseRegard(readNextIntToken(s));
	    continue;
    }else if (t.equals("IncreaseScientists")) {
	    w.setIncreaseScientists(readNextIntToken(s));
	    continue;
    }else if (t.equals("IncreaseHp")) {
	    w.setIncreaseHp(readNextIntToken(s));
	    continue;
    }else if (t.equals("IncreaseProduction")) {
	    w.setIncreaseProduction(readNextIntToken(s));
	    continue;
    }else if (t.equals("ReduceReadinessCost")) {
	    w.setReduceReadinessCost(readNextIntToken(s));
	    continue;
    }else if (t.equals("IncHappinessEmpire")) {
	    w.setIncHappinessEmpire(readNextIntToken(s));
	    continue;
    }else if (t.equals("GoldPerTelevision")) {
	    w.setGoldPerTelevision(readNextIntToken(s));
	    continue;
    }else if (t.equals("IncreaseBrokerages")) {
	    w.setIncreaseBrokerages(readNextIntToken(s));
	    continue;
    }else if (t.equals("IncreaseFoodAllCities")) {
	    w.setIncreaseFoodAllCities(readNextIntToken(s));
	    continue;
    }else if (t.equals("BonusGold")) {
	    w.setBonusGold(readNextIntToken(s));
	    continue;
    }else if (t.equals("DecEmpireSize")) {
	    w.setDecEmpireSize(readNextIntToken(s));
	    continue;
    }else if (t.equals("PollutersToParks")) {
	    w.setPollutersToParks(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("RevoltingCitiesJoinPlayer")) {
	    w.setRevoltingCitiesJoinPlayer(true);
	    continue;
    }else if (t.equals("FreeSlaves")) {
	    w.setFreeSlaves(true);
	    continue;
    }else if (t.equals("EmbassiesEverywhereEvenAtWar")) {
	    w.setEmbassiesEverywhereEvenAtWar(true);
	    continue;
    }else if (t.equals("GlobalRadar")) {
	    w.setGlobalRadar(true);
	    continue;
    }else if (t.equals("ProtectFromBarbarians")) {
	    w.setProtectFromBarbarians(true);
	    continue;
    }else if (t.equals("ReformCities")) {
	    w.setReformCities(true);
	    continue;
    }else if (t.equals("PreventConversion")) {
	    w.setPreventConversion(true);
	    continue;
    }else if (t.equals("EliminateNukes")) {
	    w.setEliminateNukes(true);
	    continue;
    }else if (t.equals("SpiesEverywhere")) {
	    w.setSpiesEverywhere(true);
	    continue;
    }else if (t.equals("EnableParkRangers")) {
	    w.setEnableParkRangers(true);
	    continue;
    }else if (t.equals("CloseEmbassies")) {
	    w.setCloseEmbassies(true);
	    continue;
    }else if (t.equals("StartGaiaController")) {
	    w.setStartGaiaController(true);
	    continue;
    }else if (t.equals("GLHidden")) {
	    w.setGlHidden(true);
	    continue;
    }else if (t.equals("NoIndex")) {
	    w.setNoIndex(true);
	    continue;
    }
    // end contents here
    else if (t.equals("}")) { // stop makin this Wonder at the right time
      Verbose.message("WonderParser: parseWonderTokens: Wonder done, adding to container");
      wonderContainer.addWonder(w); // add the Wonder to container
      break;
    }
    else if (t.equals("EOF")) { // stops if end of file is reached
      Verbose.message("WonderParser: parseWonderTokens: EOF");
      break;
    }
    else {
      Verbose.message("WonderParser: parseWonderTokens: "+t+" is not an expected token");
      continue;
    }
  }
  return s;
}
  /**
   * this method initiates the filreading with the relavant 
   * parameters and returns a stream ready to use.
   * Creation date: (27-11-01 22:28:47)
   */
  private static StreamTokenizer readFile(String path) {
    Verbose.message("WonderParser: readFile: Starting filereader");
    try {
      File f = new File(path);
      StreamTokenizer ind =
        new StreamTokenizer(
          new BufferedReader(new InputStreamReader(new FileInputStream(f))));
      ind.commentChar('#');
      ind.wordChars(':', '}');
      ind.eolIsSignificant(false);
      ind.lowerCaseMode(false);
      ind.parseNumbers();
      ind.slashSlashComments(true);
      ind.slashStarComments(true);
      return ind;
    }
    catch (FileNotFoundException e) {
      Verbose.message("WonderParser: readFile: file was not found " + e.getMessage());
      return null;
    }
  }
  /**
   * reads and returns the next token.
   * should only be used if an int is expected.
   * Creation date: (21-11-01 17:40:08)
   */
  private static int readNextIntToken(StreamTokenizer aStream) {
    try {
      Verbose.message("WonderParser: readNextIntToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_NUMBER) {
        Double d = new Double(aStream.nval);
        Verbose.message("WonderParser: readNextIntToken: " + d.intValue() + " returned");
        return d.intValue();
      }
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("WonderParser: readNextIntToken: EOF reached");
        return 0;
      }
      else {
        Verbose.message(
          "WonderParser: readNextIntToken: dont know what happened "
            + aStream.sval
            + " "
            + aStream.nval);
        return 0;
      }
    }
    catch (IOException e) {
      Verbose.message(
        "WonderParser: readNextIntToken: IO didn't do well " + e.getMessage());
      return 0;
    }
  }
  /**
   * reads and returns the next token.
   * should be used if a String is expected
   * or if you dont know what is expected.
   * Creation date: (21-11-01 17:40:08)
   */
  private static java.lang.String readNextToken(StreamTokenizer aStream) {
    try {
      Verbose.message("WonderParser: readNextToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_WORD) {
        Verbose.message("WonderParser: readNextToken: " + aStream.sval + " returned");
        return aStream.sval;
      }
      //else 
      //if (aStream.ttype == aStream.TT_NUMBER) {
      //  Double d = new Double(aStream.nval);
      //  Verbose.message("AdvanceParser: readNextIntToken: " + d.intValue() + " returned");
      //  return d.intValue();
      //}
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("WonderParser: readNextToken: EOF reached");
        return "EOF";
      }
      else if (aStream.sval == null) {
        Verbose.message("WonderParser: readNextToken: this " + aStream.sval + " is done");
        aStream.nextToken();
        return aStream.sval;
      }
      else {
        Verbose.message(
          "WonderParser: readNextToken: dont know what happened "
            + aStream.sval
            + " "
            + aStream.nval);
        return null;
      }
    }
    catch (IOException e) {
      Verbose.message(
        "WonderParser: readNextToken: IO didn't do well " + e.getMessage());
      return null;
    }
  }
}
