package ctp2.building;

import java.io.*;
import ctp2.tools.*;
/**
 * Insert the type's description here.
 * Creation date: (06-12-01 22:23:43)
 * @author: Administrator
 */
public class BuildingParser {
  private final static java.lang.String BUILDINGSTXTPATH =
    "/ctp2_data/default/gamedata/buildings.txt";
  private static BuildingContainer buildingContainer;
  /**
   * BuildingParser constructor (never used).
   */
  private BuildingParser() {
    super();
  }
  /**
  * makes a new building and sets its name to the 
  * given string, then returns the building to sender.
  * Creation date: (24-11-01 19:11:18)
  * @param nameToken java.lang.String
  */
  private static Building parseNameToken(String nameToken) {
    Verbose.message(
      "BuildingParser: parseNameToken: making new building with the name: "
        + nameToken);
    Building b = new Building();
    b.setName(nameToken);
    return b;
  }
  /**
   * this method initiates the filreading with the relavant 
   * parameters and returns a stream ready to use.
   * Creation date: (27-11-01 22:28:47)
   */
  private static StreamTokenizer readFile(String path) {
    Verbose.message("BuildingParser: readFile: Starting filereader");
    try {
      File f = new File(path);
      StreamTokenizer ind =
        new StreamTokenizer(
          new BufferedReader(new InputStreamReader(new FileInputStream(f))));
      ind.commentChar('#');
      ind.wordChars(':', '}');
      ind.eolIsSignificant(false);
      ind.lowerCaseMode(false);
      ind.parseNumbers();
      ind.slashSlashComments(true);
      ind.slashStarComments(true);
      return ind;
    }
    catch (FileNotFoundException e) {
      Verbose.message("BuildingParser: readFile: file was not found " + e.getMessage());
      return null;
    }
  }
  /**
   * reads and returns the next token.
   * should only be called if a double is expected.
   * Creation date: (21-11-01 17:40:08)
   */
  private static double readNextDoubleToken(StreamTokenizer aStream) {
    try {
      Verbose.message("BuildingParser: readNextDoubleToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_NUMBER) {
        Verbose.message(
          "BuildingParser: readNextDoubleToken: " + aStream.nval + " returned");
        return aStream.nval;
      }
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("BuildingParser: readNextDoubleToken: EOF reached");
        return 0.0;
      }
      else {
        Verbose.message(
          "BuildingParser: readNextDoubleToken: dont know what happened "
            + aStream.sval
            + " "
            + aStream.nval);
        return 0.0;
      }
    }
    catch (IOException e) {
      Verbose.message(
        "BuildingParser: readNextDoubleToken: IO didn't do well " + e.getMessage());
      return 0.0;
    }
  }
  /**
   * reads and returns the next token.
   * should only be used if an int is expected.
   * Creation date: (21-11-01 17:40:08)
   */
  private static int readNextIntToken(StreamTokenizer aStream) {
    try {
      Verbose.message("BuildingParser: readNextIntToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_NUMBER) {
        Double d = new Double(aStream.nval);
        Verbose.message("BuildingParser: readNextIntToken: " + d.intValue() + " returned");
        return d.intValue();
      }
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("BuildingParser: readNextIntToken: EOF reached");
        return 0;
      }
      else {
        Verbose.message(
          "BuildingParser: readNextIntToken: dont know what happened "
            + aStream.sval
            + " "
            + aStream.nval);
        return 0;
      }
    }
    catch (IOException e) {
      Verbose.message(
        "BuildingParser: readNextIntToken: IO didn't do well " + e.getMessage());
      return 0;
    }
  }
  /**
   * reads and returns the next token.
   * should be used if a String is expected
   * or if you dont know what is expected.
   * Creation date: (21-11-01 17:40:08)
   */
  private static java.lang.String readNextToken(StreamTokenizer aStream) {
    try {
      Verbose.message("BuildingParser: readNextToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_WORD) {
        Verbose.message("BuildingParser: readNextToken: " + aStream.sval + " returned");
        return aStream.sval;
      }
      //else 
      //if (aStream.ttype == aStream.TT_NUMBER) {
      //  Double d = new Double(aStream.nval);
      //  Verbose.message("AdvanceParser: readNextIntToken: " + d.intValue() + " returned");
      //  return d.intValue();
      //}
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("BuildingParser: readNextToken: EOF reached");
        return "EOF";
      }
      else if (aStream.sval == null) {
        Verbose.message("BuildingParser: readNextToken: this " + aStream.sval + " is done");
        aStream.nextToken();
        return aStream.sval;
      }
      else {
        Verbose.message(
          "BuildingParser: readNextToken: dont know what happened "
            + aStream.sval
            + " "
            + aStream.nval);
        return null;
      }
    }
    catch (IOException e) {
      Verbose.message(
        "BuildingParser: readNextToken: IO didn't do well " + e.getMessage());
      return null;
    }
  }
  /**
  * This method starts the parsing of Units.txt 
  * and returns the container with the result
  * after the parsing ends.
  * Creation date: (27-11-01 22:36:37)
  * @return ctp2.unit.UnitContainer
  * @param rootPath java.lang.String
  */
  public static BuildingContainer parseBuildings(String rootPath) {
    buildingContainer = new BuildingContainer(); // new BuildingContainer made
    StreamTokenizer s = readFile(rootPath + BUILDINGSTXTPATH); // file grabbed
    String t = readNextToken(s); // getting the very first token from file
    while (t != "EOF") { // repeats until End Of File
      Verbose.message("BuildingParser: parseBuildings: Starting a new building.");
      Building b = parseNameToken(t); // make a new building and set the name
      s = parseBuildingTokens(b, s); // parse all the buildings attributes
      t = readNextToken(s); // get the next token for EOF testing and so the next name is ready for parsing
    }
    Verbose.message("BuildingParser: parseBuildings: EOF reached: terminating parser");
    return buildingContainer; // full BuildingContainer returned to sender
  }

/**
 * Insert the method's description here.
 * Creation date: (06-12-01 22:42:17)
 * @return java.io.StreamTokenizer
 * @param b ctp2.building.Building
 * @param s java.io.StreamTokenizer
 */
private static StreamTokenizer parseBuildingTokens(Building b, StreamTokenizer s) {
  String t = new String("");
  while (true) {
    t = readNextToken(s);
    Verbose.message("BuildingParser: parseBuildingTokens: to be processed: " + t);
    if (t.equals("{")) { // start of every building 
      Verbose.message("BuildingParser: parseBuildingTokens: { reached.");
      continue;
    }
    // start contents here
    else if (t.equals("DefaultIcon")) {
	    t = readNextToken(s);
	    b.setDefaultIcon(t);
	    continue;
    }
    else if (t.equals("Description")) {
	    t = readNextToken(s);
	    b.setDescription(t);
	    continue;
    }
    else if (t.equals("EnableAdvance")) {
	    t = readNextToken(s);
	    b.setEnableAdvance(t);
	    continue;
    }
    else if (t.equals("PrerequisiteBuilding")) {
	    t = readNextToken(s);
	    b.addPrerequisiteBuilding(t);
	    continue;
    }
    else if (t.equals("ProductionCost")) {
	    b.setProductionCost(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("Upkeep")) {
	    b.setUpkeep(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("RaiseOvercrowdingLevel")) {
	    b.setRaiseOvercrowdingLevel(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("RaiseMaxPopulation")) {
	    b.setRaiseMaxPopulation(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("HappyInc")) {
	    b.setHappyInc(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("OffenseBonusLand")) {
	    b.setOffenseBonusLand(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("OffenseBonusWater")) {
	    b.setOffenseBonusWater(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("OffenseBonusAir")) {
	    b.setOffenseBonusAir(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("DefendersPercent")) {
	    b.setDefendersPercent(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("FoodVat")) {
	    b.setFoodVat(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("StarvationProtection")) {
	    b.setStarvationProtection(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("GoldPerCitizen")) {
	    b.setGoldPerCitizen(readNextIntToken(s));
	    continue;
    }
    else if (t.equals("SciencePercent")) {
	    b.setSciencePercent(readNextDoubleToken(s));
	    continue;
    }
    else if (t.equals("CommercePercent")) {
	    b.setCommercePercent(readNextDoubleToken(s));
	    continue;
    }
    else if (t.equals("LowerCrime")) {
	    b.setLowerCrime(readNextDoubleToken(s));
	    continue;
    }
    else if (t.equals("PreventConversion")) {
	    b.setPreventConversion(readNextDoubleToken(s));
	    continue;
    }
    else if (t.equals("PreventSlavery")) {
	    b.setPreventSlavery(readNextDoubleToken(s));
	    continue;
    }
    else if (t.equals("PopulationPollutionPercent")) {
	    b.setPopulationPollutionPercent(readNextDoubleToken(s));
	    continue;
    }
    else if (t.equals("ProductionPollutionPercent")) {
	    b.setProductionPollutionPercent(readNextDoubleToken(s));
	    continue;
    }
    else if (t.equals("ProductionPercent")) {
	    b.setProductionPercent(readNextDoubleToken(s));
	    continue;
    }
    else if (t.equals("FoodPercent")) {
	    b.setFoodPercent(readNextDoubleToken(s));
	    continue;
    }
    else if (t.equals("ProtectFromBioAgents")) {
	    b.setProtectFromBioAgents(readNextDoubleToken(s));
	    continue;
    }else if (t.equals("ProtectFromNanoVirus")) {
	    b.setProtectFromNanoVirus(readNextDoubleToken(s));
	    continue;
    }else if (t.equals("LowerPeaceMovement")) {
	    b.setLowerPeaceMovement(readNextDoubleToken(s));
	    continue;
    }else if (t.equals("Airport")) {
	    b.setAirport(true);
	    continue;
    }else if (t.equals("CantBuildInSea")) {
	    b.setCantBuildInSea(true);
	    continue;
    }else if (t.equals("ProtectFromNukes")) {
	    b.setProtectFromNukes(true);
	    continue;
    }else if (t.equals("IsReligious")) {
	    b.setReligious(true);
	    continue;
    }else if (t.equals("Cathedral")) {
	    b.setCathedral(true);
	    continue;
    }else if (t.equals("CoastalBuilding")) {
	    b.setCoastalBuilding(true);
	    continue;
    }else if (t.equals("Brokerage")) {
	    b.setBrokerage(true);
	    continue;
    }else if (t.equals("CityWalls")) {
	    b.setCityWalls(true);
	    continue;
    }else if (t.equals("AllowGrunts")) {
	    b.setAllowGrunts(true);
	    continue;
    }else if (t.equals("ForceField")) {
	    b.setForceField(true);
	    continue;
    }else if (t.equals("Television")) {
	    b.setTelevision(true);
	    continue;
    }else if (t.equals("NuclearPlant")) {
	    b.setNuclearPlant(true);
	    continue;
    }else if (t.equals("DoubleTelevangelists")) {
	    b.setDoubleTelevangelists(true);
	    continue;
    }else if (t.equals("GLHidden")) {
	    b.setGlHidden(true);
	    continue;
    }else if (t.equals("NoIndex")) {
	    b.setNoIndex(true);
	    continue;
    }
    // end contents here
    else if (t.equals("}")) { // stop makin this building at the right time
      Verbose.message("BuildingParser: parseBuildingTokens: building done, adding to container");
      buildingContainer.addBuilding(b); // add the building to container
      break;
    }
    else if (t.equals("EOF")) { // stops if end of file is reached
      Verbose.message("BuildingParser: parseBuildingTokens: EOF");
      break;
    }
    else {
      Verbose.message("BuildingParser: parseBuildingTokens: "+t+" is not an expected token");
      continue;
    }
  }
  return s;
}
}