package ctp2.unit;

import java.io.*;
import ctp2.tools.*;
/**
 * This class parses the Units.txt file.
 * Creation date: (26-11-01 14:56:42)
 * @author: Klaus Kaan
 */
public class UnitParser {
	private static UnitContainer unitContainer;
	private final static java.lang.String UNITTXTPATH = "/ctp2_data/default/gamedata/units.txt";
	private static java.lang.String unitActionName = new java.lang.String();
/**
 * UnitParser constructor is never used, therefore its private.
 */
private UnitParser() {
	super();
}
/**
 * makes a new unit and sets its name to the 
 * given string, then returns the unit to sender.
 * Creation date: (24-11-01 19:11:18)
 * @param nameToken java.lang.String
 */
private static Unit parseNameToken(String nameToken) {
	Verbose.message("UnitParser: parseNameToken: making new unit with the name: "+nameToken);
	Unit u = new Unit();
	u.setName(nameToken);
	return u;
}
/**
 * This method parses the inner declerations of UnitActions.
 * Creation date: (24-11-01 19:12:24)
 * @param innerToken java.lang.String
 */
private static StreamTokenizer parseUnitActions(Unit u, StreamTokenizer s) {
  String t = new String("");
  UnitAction a = new UnitAction();
  a.setName(unitActionName);
  while (true) {
    t = readNextToken(s);
    Verbose.message("UnitParser: parseUnitActions: to be processed: " + t);
    if (t.equals("{")) {
      Verbose.message(
        "UnitParser: parseUnitActions: { reached (should never happen)");
      continue;
    }
    else if (t.equals("Sound")) {
      a.setSound(readNextToken(s));
      continue;
    }
    else if (t.equals("Effect")) {
      a.setEffect(readNextToken(s));
      continue;
    }
    else if (t.equals("Chance")) {
      a.setChance(readNextDoubleToken(s));
      continue;
    }
    else if (t.equals("EliteChance")) {
      a.setEliteChance(readNextDoubleToken(s));
      continue;
    }
    else if (t.equals("DeathChance")) {
      a.setDeathChance(readNextDoubleToken(s));
      continue;
    }
    else if (t.equals("MaxCargo")) {
      a.setMaxCargo(readNextIntToken(s));
      continue;
    }
    else if (t.equals("Load")) {
      a.setLoad(readNextToken(s));
      continue;
    }
    else if (t.equals("Unload")) {
      a.setUnload(readNextToken(s));
      continue;
    }
    else if (t.equals("Timer")) {
      a.setTimer(readNextIntToken(s));
      continue;
    }
    else if (t.equals("Amount")) {
      a.setAmount(readNextIntToken(s));
      continue;
    }
    else if (t.equals("EscapeChance")) {
      a.setEscapeChance(readNextDoubleToken(s));
      continue;
    }
    else if (t.equals("RandomChance")) {
      a.setRandomChance(readNextDoubleToken(s));
      continue;
    }
    else if (t.equals("SpecificChance")) {
      a.setSpecificChance(readNextDoubleToken(s));
      continue;
    }
    else if (t.equals("}")) {
      //Verbose.message("unitaction } reached, adding is next");
      Verbose.message("UnitParser: parseUnitActions: trying to add "+a.getName()+" to "+u.getName());
      u.addUnitAction(a);
      //Verbose.message("action added to unit, returning stream to caller");
      return s;
    }
    else if (t.equals("EOF")) {
      Verbose.message("UnitParser: parseUnitActions: EOF");
      return s;
    }
    else {
      Verbose.message(
        "UnitParser: parseUnitActions: this is not to the parsers taste: " + t);
      return s;
    }
  }
}
/**
 * This method starts the parsing of Units.txt 
 * and returns the container with the result
 * after the parsing ends.
 * Creation date: (27-11-01 22:36:37)
 * @return ctp2.unit.UnitContainer
 * @param rootPath java.lang.String
 */
public static UnitContainer parseUnits(String rootPath) {
	unitContainer = new UnitContainer();  // new UnitContainer made
	StreamTokenizer s = readFile(rootPath+UNITTXTPATH); // file grabbed
	String t = readNextToken(s); // getting the very first token from file
	while (t != "EOF"){ // repeats until End Of File
		Verbose.message("UnitParser: parseUnits: Starting a new unit.");
		Unit u = parseNameToken(t); // make a new unit and set the name of the unit
		t = readNextToken(s); // get the first "{" out of the way so parseUnitTokens wont get confused
		s = parseUnitTokens(u, s); // parse all the units attributes
		t = readNextToken(s); // get the next token for EOF testing and so the next name is ready for parsing
	}
	Verbose.message("UnitParser: parseUnits: EOF reached: terminating parser");
	return unitContainer; // full UnitContainer returned to sender
}
/**
 * this method parses the main tokens.
 * Creation date: (24-11-01 19:12:24)
 * @param innerToken java.lang.String
 */
private static StreamTokenizer parseUnitTokens(Unit u, StreamTokenizer s) {
  String t = new String("");
  while (true) {
    t = readNextToken(s);
    Verbose.message("UnitParser: parseUnitTokens: to be processed: " + t);
    if (t.equals("{")) { // starts the parsing of unitaction
      s = parseUnitActions(u, s);
      continue;
    }
    // start insert contents
    else if (t.equals("Description")) {
      u.setDescription(readNextToken(s));
      continue;
    }
    else if (t.equals("DefaultIcon")) {
      u.setDefaultIcon(readNextToken(s));
      continue;
    }
    else if (t.equals("DefaultSprite")) {
      u.setDefaultSprite(readNextToken(s));
      continue;
    }
    else if (t.equals("Category")) {
      u.setCategory(readNextToken(s));
      continue;
    }
    else if (t.equals("Attack")) {
      u.setAttack(readNextIntToken(s));
      continue;
    }
    else if (t.equals("Defense")) {
      u.setDefense(readNextIntToken(s));
      continue;
    }
    else if (t.equals("ZBRangeAttack")) {
      u.setZBRangeAttack(readNextIntToken(s));
      continue;
    }
    else if (t.equals("Firepower")) {
      u.setFirepower(readNextIntToken(s));
      continue;
    }
    else if (t.equals("Armor")) {
      u.setArmor(readNextIntToken(s));
      continue;
    }
    else if (t.equals("MaxHP")) {
      u.setMaxHP(readNextIntToken(s));
      continue;
    }
    else if (t.equals("ShieldCost")) {
      u.setShieldCost(readNextIntToken(s));
      continue;
    }
    else if (t.equals("PowerPoints")) {
      u.setPowerPoints(readNextIntToken(s));
      continue;
    }
    else if (t.equals("ShieldHunger")) {
      u.setShieldHunger(readNextIntToken(s));
      continue;
    }
    else if (t.equals("FoodHunger")) {
      u.setFoodHunger(readNextIntToken(s));
      continue;
    }
    else if (t.equals("MaxMovePoints")) {
      u.setMaxMovePoints(readNextIntToken(s));
      continue;
    }
    else if (t.equals("VisionRange")) {
      u.setVisionRange(readNextIntToken(s));
      continue;
    }
    else if (t.equals("EnableAdvance")) {
      u.setEnableAdvance(readNextToken(s));
      continue;
    }
    else if (t.equals("ObsoleteAdvance")) {
      u.addObsoleteAdvance(readNextToken(s));
      continue;
    }
    else if (t.equals("GovernmentType")) {
      u.setGovernmentType(readNextToken(s));
      continue;
    }
    else if (t.equals("BombRounds")) {
      u.setBombRounds(readNextIntToken(s));
      continue;
    }
    else if (t.equals("BombardRange")) {
      u.setBombardRange(readNextIntToken(s));
      continue;
    }
    else if (t.equals("CanCounterBombard")) {
      u.setCanCounterBombard(true);
      continue;
    }
    else if (t.equals("ActiveDefenseRange")) {
      u.setActiveDefenseRange(readNextIntToken(s));
      continue;
    }
    else if (t.equals("ActiveDefenseOnlyWhenCarryingEnablers")) {
      u.setActiveDefenseOnlyWhenCarryingEnablers(true);
      continue;
    }
    else if (t.equals("EnableCarrierDefenses")) {
      u.setEnableCarrierDefenses(true);
      continue;
    }
    else if (t.equals("LossMoveToDmgNone")) {
      u.setLossMoveToDmgNone(true);
      continue;
    }
    else if (t.equals("NoFuelThenCrash")) {
      u.setNoFuelThenCrash(true);
      continue;
    }
    else if (t.equals("MaxFuel")) {
      u.setMaxFuel(readNextIntToken(s));
      continue;
    }
    else if (t.equals("HasPopAndCanBuild")) {
      u.setHasPopAndCanBuild(true);
      continue;
    }
    else if (t.equals("CantBuild")) {
      u.setCantBuild(true);
      continue;
    }
    else if (t.equals("CityGrowthCoefficient")) {
      u.setCityGrowthCoefficient(readNextDoubleToken(s));
      continue;
    }
    else if (t.equals("NoIndex")) {
      u.setNoIndex(true);
      continue;
    }
    else if (t.equals("GLHidden")) {
      u.setGLHidden(true);
      continue;
    }
    else if (t.equals("IsTrader")) {
      u.setIsTrader(true);
      continue;
    }
    else if (t.equals("CanEntrench")) {
      u.setCanEntrench(true);
      continue;
    }
    else if (t.equals("CanExpel")) {
      u.setCanExpel(true);
      continue;
    }
    else if (t.equals("CanPillage")) {
      u.setCanPillage(true);
      continue;
    }
    else if (t.equals("CanPirate")) {
      u.setCanPirate(true);
      continue;
    }
    else if (t.equals("IgnoreZOC")) {
      u.setIgnoreZOC(true);
      continue;
    }
    else if (t.equals("NoZoc")) {
      u.setNoZoc(true);
      continue;
    }
    else if (t.equals("SettleCityType")) {
      u.setSettleCityType(readNextToken(s));
      continue;
    }
    else if (t.equals("SettleSize")) {
      u.setSettleSize(readNextIntToken(s));
      continue;
    }
    else if (t.equals("CanBeachAssault")) {
      u.setCanBeachAssault(true);
      continue;
    }
    else if (t.equals("CanSue")) {
      u.setCanSue(true);
      continue;
    }
    else if (t.equals("CanBeSued")) {
      u.setCanBeSued(true);
      continue;
    }
    else if (t.equals("CanBeExpelled")) {
      u.setCanBeExpelled(true);
      continue;
    }
    else if (t.equals("CantCaptureCity")) {
      u.setCantCaptureCity(true);
      continue;
    }
    else if (t.equals("SpaceLaunch")) {
      u.setSpaceLaunch(readNextIntToken(s));
      continue;
    }
    else if (t.equals("VictoryEnslavement")) {
      u.setVictoryEnslavement(true);
      continue;
    }
    else if (t.equals("EstablishEmbassy")) {
      u.setEstablishEmbassy(true);
      continue;
    }
    else if (t.equals("ThrowParty")) {
      u.setThrowParty(true);
      continue;
    }
    else if (t.equals("SingleUse")) {
      u.setSingleUse(true);
      continue;
    }
    else if (t.equals("NeedsNoSupport")) {
      u.setNeedsNoSupport(true);
      continue;
    }
    else if (t.equals("NoSlaves")) {
      u.setNoSlaves(true);
      continue;
    }
    else if (t.equals("IsSpecialForces")) {
      u.setIsSpecialForces(true);
      continue;
    }
    else if (t.equals("DefendAgainstSpies")) {
      u.setDefendAgainstSpies(readNextDoubleToken(s));
      continue;
    }
    else if (t.equals("IsTelevangelist")) {
      u.setIsTelevangelist(true);
      continue;
    }
    else if (t.equals("Civilian")) {
      u.setCivilian(true);
      continue;
    }
    else if (t.equals("ExertsMartialLaw")) {
      u.setExertsMartialLaw(true);
      continue;
    }
    else if (t.equals("DeathEffectsHappy")) {
      u.setDeathEffectsHappy(true);
      continue;
    }
    else if (t.equals("BuildingRemovesAPop")) {
      u.setBuildingRemovesAPop(true);
      continue;
    }
    else if (t.equals("OnlyBuildOne")) {
      u.setOnlyBuildOne(true);
      continue;
    }
    else if (t.equals("BonusAgainstMounted")) {
      u.setBonusAgainstMounted(true);
      continue;
    }
    else if (t.equals("MountedBonus")) {
      u.setMountedBonus(readNextDoubleToken(s));
      continue;
    }
    else if (t.equals("IsSubmarine")) {
      u.setIsSubmarine(true);
      continue;
    }
    else if (t.equals("Advertise")) {
      u.setAdvertise(true);
      continue;
    }
    else if (t.equals("IsFlanker")) {
      u.setIsFlanker(true);
      continue;
    }
    else if (t.equals("IsMounted")) {
      u.setIsMounted(true);
      continue;
    }
    else if (t.equals("WoodenShip")) {
      u.setWoodenShip(true);
      continue;
    }
    else if (t.equals("AttackWoodenShipBonus")) {
      u.setAttackWoodenShipBonus(true);
      continue;
    }
    else if (t.equals("WoodenShipBonus")) {
      u.setWoodenShipBonus(readNextDoubleToken(s));
      continue;
    }
    else if (t.equals("Paratrooper")) {
      u.setParatrooper(true);
      continue;
    }
    else if (t.equals("ParatrooperTransport")) {
      u.setParatrooperTransport(true);
      continue;
    }
    else if (t.equals("Explodes")) {
      u.setExplodes(true);
      continue;
    }
    else if (t.equals("SoundSelect1")) {
      u.setSoundSelect1(readNextToken(s));
      continue;
    }
    else if (t.equals("SoundSelect2")) {
      u.setSoundSelect2(readNextToken(s));
      continue;
    }
    else if (t.equals("SoundMove")) {
      u.setSoundMove(readNextToken(s));
      continue;
    }
    else if (t.equals("SoundAcknowledge")) {
      u.setSoundAcknowledge(readNextToken(s));
      continue;
    }
    else if (t.equals("SoundCantMove")) {
      u.setSoundCantMove(readNextToken(s));
      continue;
    }
    else if (t.equals("SoundAttack")) {
      u.setSoundAttack(readNextToken(s));
      continue;
    }
    else if (t.equals("SoundWork")) {
      u.setSoundWork(readNextToken(s));
      continue;
    }
    else if (t.equals("SoundVictory")) {
      u.setSoundVictory(readNextToken(s));
      continue;
    }
    else if (t.equals("SoundDeath")) {
      u.setSoundDeath(readNextToken(s));
      continue;
    }
    else if (t.equals("SettleBuilding")) {
      u.addSettleBuilding(readNextToken(s));
      continue;
    }
    else if (t.equals("CanAttack:")) {
      t = readNextToken(s);
      if (t.equals("Air")) {
        u.setCanAttackAir(true);
      }
      else if (t.equals("Land")) {
        u.setCanAttackLand(true);
      }
      else if (t.equals("Mountain")) {
        u.setCanAttackMountain(true);
      }
      else if (t.equals("Sea")) {
        u.setCanAttackSea(true);
      }
      else if (t.equals("Underwater")) {
        u.setCanAttackUnderwater(true);
      }
      else if (t.equals("ShallowWater")) {
        u.setCanAttackUnderwater(true);
      }
      else {
        Verbose.message(
          "UnitParser: parseUnitTokens: CanAttack: " + t + " is unknown.");
      }
      continue;
    }
    else if (t.equals("CanBombard:")) {
      t = readNextToken(s);
      if (t.equals("Air")) {
        u.setCanBombardAir(true);
      }
      else if (t.equals("Land")) {
        u.setCanBombardLand(true);
      }
      else if (t.equals("Mountain")) {
        u.setCanBombardMountain(true);
      }
      else if (t.equals("Water")) {
        u.setCanBombardWater(true);
      }
      else {
        Verbose.message(
          "UnitParser: parseUnitTokens: CanBombard: " + t + " is unknown.");
      }
      continue;
    }
    else if (t.equals("CanCarry:")) {
      t = readNextToken(s);
      if (t.equals("SmallLand")) {
        u.setCanCarrySmallLand(true);
      }
      else if (t.equals("MedLand")) {
        u.setCanCarryMedLand(true);
      }
      else if (t.equals("SmallAir")) {
        u.setCanCarrySmallAir(true);
      }
      else if (t.equals("MedAir")) {
        u.setCanCarryMedAir(true);
      }
      else {
        Verbose.message("UnitParser: parseUnitTokens: CanCarry: " + t + " is unknown.");
      }
      continue;
    }
    else if (t.equals("CanSee:")) {
      t = readNextToken(s);
      if (t.equals("Standard")) {
        u.setCanSeeStandard(true);
      }
      else if (t.equals("Stealth")) {
        u.setCanSeeStealth(true);
      }
      else if (t.equals("Underwater")) {
        u.setCanSeeUnderwater(true);
      }
      else {
        Verbose.message("UnitParser: parseUnitTokens: CanSee: " + t + " is unknown.");
      }
      continue;
    }
    else if (t.equals("Defend:")) {
      t = readNextToken(s);
      if (t.equals("Air")) {
        u.setDefendAir(true);
      }
      else {
        Verbose.message("UnitParser: parseUnitTokens: Defend: " + t + " is unknown.");
      }
      continue;
    }
    else if (t.equals("MovementType:")) {
      t = readNextToken(s);
      if (t.equals("Air")) {
        u.setMovementTypeAir(true);
      }
      else if (t.equals("Land")) {
        u.setMovementTypeLand(true);
      }
      else if (t.equals("Mountain")) {
        u.setMovementTypeMountain(true);
      }
      else if (t.equals("Sea")) {
        u.setMovementTypeSea(true);
      }
      else if (t.equals("ShallowWater")) {
        u.setMovementTypeShallowWater(true);
      }
      else if (t.equals("Trade")) {
        u.setMovementTypeTrade(true);
      }
      else {
        Verbose.message(
          "UnitParser: parseUnitTokens: MovementType: " + t + " is unknown.");
      }
      continue;
    }
    else if (t.equals("Settle:")) {
      t = readNextToken(s);
      if (t.equals("Mountain")) {
        u.setSettleMountain(true);
      }
      else if (t.equals("Land")) {
        u.setSettleLand(true);
      }
      else if (t.equals("Water")) {
        u.setSettleWater(true);
      }
      else {
        Verbose.message("UnitParser: parseUnitTokens: Settle: " + t + " is unknown.");
      }
      continue;
    }
    else if (t.equals("Size:")) {
      t = readNextToken(s);
      if (t.equals("Small")) {
        u.setSizeSmall(true);
      }
      else if (t.equals("Medium")) {
        u.setSizeMedium(true);
      }
      else if (t.equals("Large")) {
        u.setSizeLarge(true);
      }
      else {
        Verbose.message("UnitParser: parseUnitTokens: Size: " + t + " is unknown.");
      }
      continue;
    }
    else if (t.equals("VisionClass:")) {
      t = readNextToken(s);
      if (t.equals("Standard")) {
        u.setVisionClassStandard(true);
      }
      else if (t.equals("Stealth")) {
        u.setVisionClassStealth(true);
      }
      else if (t.equals("Underwater")) {
        u.setVisionClassUnderwater(true);
      }
      else {
        Verbose.message(
          "UnitParser: parseUnitTokens: VisionClass: " + t + " is unknown.");
      }
      continue;
    }
    // end insert contents
    else if (t.equals("}")) { // stop makin this unit at the right time
      Verbose.message("UnitParser: parseUnitTokens: unit done, adding to container");
      unitContainer.addUnit(u); // add the unit to container
      break;
    }
    else if (t.equals("EOF")) { // stops if end of file is reached
      Verbose.message("UnitParser: parseUnitTokens: EOF");
      break;
    }
    else {
      unitActionName = t;
      Verbose.message(
        "UnitParser: parseUnitTokens: "
          + t
          + " is not a normal token, this might be a UnitAction name, saving!");
    }
  }
  return s;
}
/**
 * this method initiates the filreading with the relavant 
 * parameters and returns a stream ready to use.
 * Creation date: (27-11-01 22:28:47)
 */
private static StreamTokenizer readFile(String path) {
  Verbose.message("UnitParser: readFile: Starting filereader");
  try {
    File f = new File(path);
    StreamTokenizer ind = new StreamTokenizer(new BufferedReader(new InputStreamReader(new FileInputStream(f))));
    ind.commentChar('#');
    ind.wordChars(':', '}');
    ind.eolIsSignificant(false);
    ind.lowerCaseMode(false);
    ind.parseNumbers();
    ind.slashSlashComments(true);
    ind.slashStarComments(true);
    return ind;
  }
  catch (FileNotFoundException e) {
    Verbose.message("UnitParser: readFile: file was not found " + e.getMessage());
    return null;
  }
}
/**
 * reads and returns the next token.
 * should only be called if a double is expected.
 * Creation date: (21-11-01 17:40:08)
 */
private static double readNextDoubleToken(StreamTokenizer aStream) {
  try {
    Verbose.message("UnitParser: readNextDoubleToken: Reading next token");
    aStream.nextToken();
    if (aStream.ttype == aStream.TT_NUMBER) {
      Verbose.message("UnitParser: readNextDoubleToken: " + aStream.nval + " returned");
      return aStream.nval;
    }
    else if (aStream.ttype == aStream.TT_EOF) {
      Verbose.message("UnitParser: readNextDoubleToken: EOF reached");
      return 0.0;
    }
    else {
	    Verbose.message("UnitParser: readNextDoubleToken: dont know what happened "+aStream.sval+" "+aStream.nval);
      return 0.0;
    }
  }
  catch (IOException e) {
    Verbose.message("UnitParser: readNextDoubleToken: IO didn't do well " + e.getMessage());
    return 0.0;
  }
}
/**
 * reads and returns the next token.
 * should only be used if an int is expected.
 * Creation date: (21-11-01 17:40:08)
 */
private static int readNextIntToken(StreamTokenizer aStream) {
  try {
    Verbose.message("UnitParser: readNextIntToken: Reading next token");
    aStream.nextToken();
    if (aStream.ttype == aStream.TT_NUMBER) {
      Double d = new Double(aStream.nval);
      Verbose.message("UnitParser: readNextIntToken: " + d.intValue() + " returned");
      return d.intValue();
    }
    else if (aStream.ttype == aStream.TT_EOF) {
      Verbose.message("UnitParser: readNextIntToken: EOF reached");
      return 0;
    }
    else {
	    Verbose.message("UnitParser: readNextIntToken: dont know what happened "+aStream.sval+" "+aStream.nval);
      return 0;
    }
  }
  catch (IOException e) {
    Verbose.message("UnitParser: readNextIntToken: IO didn't do well " + e.getMessage());
    return 0;
  }
}
/**
 * reads and returns the next token.
 * should be used if a String is expected
 * or if you dont know what is expected.
 * Creation date: (21-11-01 17:40:08)
 */
private static java.lang.String readNextToken(StreamTokenizer aStream) {
  try {
    Verbose.message("UnitParser: readNextToken: Reading next token");
    aStream.nextToken();
    if (aStream.ttype == aStream.TT_WORD) {
      Verbose.message("UnitParser: readNextToken: " + aStream.sval + " returned");
      return aStream.sval;
    }
    //else 
    //if (aStream.ttype == aStream.TT_NUMBER) {
    //  Double d = new Double(aStream.nval);
    //  Verbose.message("AdvanceParser: readNextIntToken: " + d.intValue() + " returned");
    //  return d.intValue();
    //}
    else if (aStream.ttype == aStream.TT_EOF) {
      Verbose.message("UnitParser: readNextToken: EOF reached");
      return "EOF";
    }
    else if (aStream.sval == null) {
	    Verbose.message("UnitParser: readNextToken: this "+aStream.sval+" is done");
	    aStream.nextToken();
	    return aStream.sval;
    }
    else {
	    Verbose.message("UnitParser: readNextToken: dont know what happened "+aStream.sval+" "+aStream.nval);
      return null;
    }
  }
  catch (IOException e) {
    Verbose.message("UnitParser: readNextToken: IO didn't do well " + e.getMessage());
    return null;
  }
}
}
