package ctp2.unit;

/**
 * This class is a containerclass for holding Units.
 * Creation date: (26-11-01 14:56:23)
 * @author: Klaus Kaan
 */
public class UnitContainer {
	private java.util.ArrayList unitList;
/**
 * UnitContainer constructor.
 */
public UnitContainer() {
	super();
	unitList = new java.util.ArrayList();
}
/**
 * adds a Unit Object to the container.
 * Creation date: (26-11-01 15:03:00)
 * @param aUnit ctp2.unit.Unit
 */
public void addUnit(Unit aUnit) {
	unitList.add(aUnit);
	ctp2.tools.Verbose.message("UnitContainer: addUnit: unit added to container.");
	}
/**
 * Search and returns the Unit Object that matches the given name.
 * Creation date: (26-11-01 15:03:53)
 * @param unitName java.lang.String
 */
public Unit getUnit(String unitName) {
  Unit u = null;
  boolean found = false;
  for (int i = 0;
    (i < unitList.size()) && (unitList.isEmpty() == false) && (found != true);
    i++) {
    try {
      u = (Unit) (unitList.get(i));
      ctp2.tools.Verbose.message("UnitContainer: getUnit: searching "+u.getName()+" to match "+unitName+".");
      if (u.getName().equals(unitName)) {
        found = true;
      }
      else if (found != true) {
        u = null;
      }
    }
    catch (IndexOutOfBoundsException e) {
      ctp2.tools.Verbose.message(
        "UnitContainer: getUnit: IndexOutOfBoundsException " + e.getMessage());
    }
  }
  return u;
}
}
