package ctp2.advance;

import java.io.*;
import ctp2.tools.*;
import java.lang.*;

/**
 * Parses the file advance.txt
 * To do: Rename some vars and methods to make more sence.
 * Creation date: (17-11-01 20:00:16)
 * @author: Klaus Kaan
 */
public class AdvanceParser {
  private static final java.lang.String ADVANCETXTPATH = "/ctp2_data/default/gamedata/advance.txt";
  private static AdvanceContainer advanceContainer;
  /**
   * AdvancesParser constructor is private cause its never used.
   */
  private AdvanceParser() {
    super();
    Verbose.message("AdvanceParser: new AdvaceParser made");

  }
  /**
   * This is where it all happens.
   * Creation date: (24-11-01 15:39:49)
   */
  public static AdvanceContainer parseAdvances(String aStartPath) {
    advanceContainer = new AdvanceContainer();
    String fullPath = aStartPath + ADVANCETXTPATH;
    StreamTokenizer in = readFile(fullPath);
    String t = readNextToken(in);
    while (t != "EOF") {
      Advance a = parseNameToken(t);
      in = parseAdvanceTokens(a, in);
      t = readNextToken(in);
    }
    Verbose.message("AdvanceParser: parseTokens: EOF reached: terminating parser");
    return advanceContainer;
  }
  /**
   * Parses all advance data that is inside { } 
   * Creation date: (24-11-01 19:12:24)
   * @param innerToken java.lang.String
   */
  private static StreamTokenizer parseAdvanceTokens(Advance a, StreamTokenizer s) {
    String t = new String("");
    while (true) {
      t = readNextToken(s);
      Verbose.message("AdvanceParser: parseInnerTokens: to be processed: " + t);
      if (t.equals("{")) {
        Verbose.message("AdvanceParser: parseInnerTokens: { reached");
        continue;
      }
      else if (t.equals("Prerequisites")) {
        a.addPrerequisite(readNextToken(s));
        continue;
      }
      else if (t.equals("Cost")) {
        a.setCost(readNextIntToken(s));
        continue;
      }
      else if (t.equals("Icon")) {
        a.setIcon(readNextToken(s));
        continue;
      }
      else if (t.equals("Branch")) {
        a.setBranch(readNextIntToken(s));
        continue;
      }
      else if (t.equals("Age")) {
        a.setAge(readNextToken(s));
        continue;
      }
      else if (t.equals("KeyAdvanceAdvice")) {
        a.setKeyAdvanceAdvice(readNextToken(s));
        continue;
      }
      else if (t.equals("TriggerFeat")) {
        a.setTriggerFeat(readNextToken(s));
        continue;
      }
      else if (t.equals("PollutionSizeModifier")) {
        a.setPollutionSizeModifier(readNextIntToken(s));
        continue;
      }
      else if (t.equals("PollutionProductionModifier")) {
        a.setPollutionProductionModifier(readNextIntToken(s));
        continue;
      }
      else if (t.equals("Capitalization")) {
        a.setCapitalization(true);
        continue;
      }
      else if (t.equals("MagLev")) {
        a.setMaglev(true);
        continue;
      }
      else if (t.equals("Infrastructure")) {
        a.setInfrastructure(true);
        continue;
      }
      else if (t.equals("PlantNuke")) {
        a.setPlantNuke(true);
        continue;
      }
      else if (t.equals("DeepOcean")) {
        a.setDeepOcean(true);
        continue;
      }
      else if (t.equals("Railroads")) {
        a.setRailroads(true);
        continue;
      }
      else if (t.equals("GLHidden")) {
        a.setGlHidden(true);
        continue;
      }
      else if (t.equals("Transform")) {
        a.setTransform(true);
        continue;
      }
      else if (t.equals("Roads")) {
        a.setRoads(true);
        continue;
      }
      else if (t.equals("}")) {
        advanceContainer.addAdvance(a);
        break;
      }
      else if (t.equals("EOF")) {
        Verbose.message("AdvanceParser: parseInnerTokens: EOF");
        break;
      }
      else {
        Verbose.message(
          "AdvanceParser: parseInnerTokens: this is not to the parsers taste: " + t);
      }
    }
    return s;
  }
  /**
   * Parses the name of the advance and makes a new Advance object.
   * Creation date: (24-11-01 19:11:18)
   * @param nameToken java.lang.String
   */
  private static Advance parseNameToken(String nameToken) {
    Advance a = new Advance();
    a.setName(nameToken);
    return a;
  }
  /**
   * starts the reading of the specified file.
   * Creation date: (21-11-01 17:40:08)
   */
  private static StreamTokenizer readFile(String path) {
    Verbose.message("AdvanceParser: readFile: Starting filereader");
    try {
      File f = new File(path);
      StreamTokenizer ind =
        new StreamTokenizer(
          new BufferedReader(new InputStreamReader(new FileInputStream(f))));
      ind.commentChar('#');
      ind.wordChars('A', '}');
      ind.eolIsSignificant(false);
      ind.lowerCaseMode(false);
      ind.parseNumbers();
      ind.slashSlashComments(true);
      ind.slashStarComments(true);
      return ind;
    }
    catch (FileNotFoundException e) {
      Verbose.message(
        "AdvanceParser: readFile: file was not found " + e.getMessage());
      return null;
    }
  }
  /**
   * If the next token is an int then use this method.
   * Creation date: (21-11-01 17:40:08)
   */
  private static int readNextIntToken(StreamTokenizer aStream) {
    try {
      Verbose.message("AdvanceParser: readNextIntToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_NUMBER) {
        Double d = new Double(aStream.nval);
        Verbose.message(
          "AdvanceParser: readNextIntToken: " + d.intValue() + " returned");
        return d.intValue();
      }
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("AdvanceParser: readNextIntToken: EOF reached");
        return 0;
      }
      return 0;
    }
    catch (IOException e) {
      Verbose.message(
        "AdvanceParser: readNextIntToken: IO didn't do well " + e.getMessage());
      return 0;
    }
  }
  /**
   * returns the next token from the file as a string.
   * Creation date: (21-11-01 17:40:08)
   */
  private static java.lang.String readNextToken(StreamTokenizer aStream) {
    try {
      Verbose.message("AdvanceParser: readNextToken: Reading next token");
      aStream.nextToken();
      if (aStream.ttype == aStream.TT_WORD) {
        Verbose.message("AdvanceParser: readNextToken: " + aStream.sval + " returned");
        return aStream.sval;
      }
      else if (aStream.ttype == aStream.TT_NUMBER) {
        Verbose.message("AdvanceParser: readNextToken: " + aStream.nval + " returned");
        return Double.toString(aStream.nval);
      }
      else if (aStream.ttype == aStream.TT_EOF) {
        Verbose.message("AdvanceParser: readNextToken: EOF reached");
        return "EOF";
      }
      return null;
    }
    catch (IOException e) {
      Verbose.message(
        "AdvanceParser: readNextToken: IO didn't do well " + e.getMessage());
      return null;
    }
  }
}
