package ctp2.advance;

import ctp2.tools.*;
/**
 * This is the container that holds all Advances.
 * Creation date: (17-11-01 20:00:48)
 * @author: Klaus Kaan
 */
public class AdvanceContainer {
  private java.util.ArrayList advanceList;
  /**
   * AdvancesContainer constructor.
   */
  public AdvanceContainer() {
    super();
    advanceList = new java.util.ArrayList();
    Verbose.message("AdvanceContainer: new container made");
  }
  /**
   * This adds an advance to the container.
   * Creation date: (21-11-01 17:41:47)
   */
  public void addAdvance(Advance a) {
    advanceList.add(a);
    Verbose.message("Container: advance " + a.getName() + " added");
  }
  /**
   * this finds and returns an advance given the advance name.
   * Creation date: (24-11-01 21:08:05)
   * @return ctp2.advance.Advance
   * @param advName java.lang.String
   */
  public Advance getAdvance(String advName) {
    Advance a = null;
    boolean found = false;
    for (int i = 0;
      (i < advanceList.size()) && (advanceList.isEmpty() == false) && (found != true);
      i++) {
      try {
        a = (Advance) (advanceList.get(i));
        if (a.getName().equals(advName)) {
          found = true;
        }
        else if (found != true) {
          a = null;
        }
      }
      catch (IndexOutOfBoundsException e) {
        Verbose.message(
          "AdvanceContainer: getAdvance: IndexOutOfBoundsException " + e.getMessage());
      }
    }
    return a;
  }
}