package ctp2.advance;

import ctp2.tools.*;
/**
 * An Object of this Class represents one advance
 * Creation date: (17-11-01 17:30:52)
 * @author: Klaus Kaan
 */
public class Advance {
  private java.lang.String name;
  private int cost;
  private java.lang.String icon;
  private int branch;
  private java.lang.String age;
  private java.lang.String keyAdvanceAdvice;
  private java.lang.String triggerFeat;
  private int pollutionSizeModifier;
  private int pollutionProductionModifier;
  private boolean capitalization;
  private boolean maglev;
  private boolean infrastructure;
  private boolean plantNuke;
  private boolean deepOcean;
  private boolean railroads;
  private boolean glHidden;
  private boolean transform;
  private boolean roads;
  private java.util.ArrayList preRequisites;

  /**
   * Advances constructor.
   * calls the superclass constructor,
   * then makes a new ArrayList to store prerequisites in.
   */
  public Advance() {
    super();
    Verbose.message("Advance: new advance made");
    preRequisites = new java.util.ArrayList();
  }
  /**
   * adds a prerequisite advance for the advance.
   * the input is the name string in Advance.
   * More than one can be added.
   * Creation date: (23-11-01 20:17:52)
   * @param preReq java.lang.String
   */
  public void addPrerequisite(String preReq) {
    this.preRequisites.add(preReq);
    Verbose.message("Advance: " + preReq + " added as prerequisite");
  }
  /**
   * returns what age the advance belongs to.
   * Creation date: (17-11-01 17:40:07)
   * @return java.lang.String
   */
  public java.lang.String getAge() {
    Verbose.message("Advance: " + age + " returned");
    return age;
  }
  /**
   * returns what branch the advance belongs to.
   * Please note that this attribute has no known uses
   * and all default advances has this set to zero.
   * Creation date: (17-11-01 17:36:16)
   * @return java.lang.String
   */
  public int getBranch() {
    Verbose.message("Advance: Branch " + branch + " returned");
    return branch;
  }
  /**
   * returns true if the advance enables the building of Capitalization.
   * Creation date: (17-11-01 17:44:22)
   * @return java.lang.Boolean
   */
  public boolean getCapitalization() {
    Verbose.message("Advance: Capitalization " + capitalization + " returned");
    return capitalization;
  }
  /**
   * returns the advance's cost to research.
   * Creation date: (17-11-01 17:35:07)
   * @return int
   */
  public int getCost() {
    Verbose.message("Advance: Cost " + cost + " returned");
    return cost;
  }
  /**
   * returns a string with the desciptor of what icon 
   * should be used with this advance. Note: the actual 
   * name of the icon file must be found in another file.
   * Creation date: (17-11-01 17:35:30)
   * @return java.lang.String
   */
  public java.lang.String getIcon() {
    Verbose.message("Advance: Icon " + icon + " returned");
    return icon;
  }
  /**
   * returns the string name of the KeyAdvanceAdvice
   * Creation date: (17-11-01 17:40:34)
   * @return java.lang.String
   */
  public java.lang.String getKeyAdvanceAdvice() {
    Verbose.message(
      "Advance: key advance advice " + keyAdvanceAdvice + " returned");
    return keyAdvanceAdvice;
  }
  /**
   * returns the name of this advance.
   * Creation date: (17-11-01 17:32:31)
   * @return java.lang.String
   */
  public java.lang.String getName() {
    Verbose.message("Advance: " + name + " returned");
    return name;
  }
  /**
   * returns the pollution production modifier for this advance.
   * Creation date: (17-11-01 17:43:57)
   * @return int
   */
  public int getPollutionProductionModifier() {
    Verbose.message(
      "Advance: PollutionProductionModifier "
        + pollutionProductionModifier
        + " returned");
    return pollutionProductionModifier;
  }
  /**
   * returns the pollution size modifier for this advance.
   * Creation date: (17-11-01 17:43:34)
   * @return int
   */
  public int getPollutionSizeModifier() {
    Verbose.message(
      "Advance: PollutionSizeModifier " + pollutionSizeModifier + " returned");
    return pollutionSizeModifier;
  }
  /**
   * returns an ListIterator containing the names of 
   * this advance's prerequisites.
   * Creation date: (23-11-01 10:37:56)
   * @return java.util.ArrayList
   */
  public java.util.ListIterator getPreRequisitesIterator() {
    return preRequisites.listIterator();
  }
  /**
   * returns the name of a feat that is 
   * triggered by the discovery of this advance.
   * Creation date: (17-11-01 17:42:58)
   * @return java.lang.String
   */
  public java.lang.String getTriggerFeat() {
    Verbose.message("Advance: feat trigger " + triggerFeat + " returned");
    return triggerFeat;
  }
  /**
   * returns true if this advance allows 
   * ships to move in deep ocean.
   * Creation date: (17-11-01 17:46:24)
   * @return boolean
   */
  public boolean isDeepOcean() {
    Verbose.message("Advance: deep ocean " + deepOcean + " returned");
    return deepOcean;
  }
  /**
   * returns true if this advance should 
   * not show up in the great library.
   * Creation date: (17-11-01 17:46:59)
   * @return boolean
   */
  public boolean isGlHidden() {
    Verbose.message("Advance: GLHidden " + glHidden + " returned");
    return glHidden;
  }
  /**
   * return true if this advance allows 
   * for the building of infrastructure.
   * Creation date: (17-11-01 17:45:04)
   * @return boolean
   */
  public boolean isInfrastructure() {
    Verbose.message("Advance: infrastructure " + infrastructure + " returned");
    return infrastructure;
  }
  /**
   * returns true if this advance allows
   * for the building of maglev tracs.
   * Creation date: (17-11-01 17:44:39)
   * @return boolean
   */
  public boolean isMaglev() {
    Verbose.message("Advance: maglev " + maglev + " returned");
    return maglev;
  }
  /**
   * returns true if this advance allows
   * the planting of nukes by the units 
   * that has the ability.
   * Creation date: (17-11-01 17:45:48)
   * @return boolean
   */
  public boolean isPlantNuke() {
    Verbose.message("Advance: plant nuke " + plantNuke + " returned");
    return plantNuke;
  }
  /**
   * returns true if this advance allows
   * for the building of railroad.
   * Creation date: (17-11-01 17:46:39)
   * @return boolean
   */
  public boolean isRailroads() {
    Verbose.message("Advance: railroads " + railroads + " returned");
    return railroads;
  }
  /**
   * returns true if this advance allows
   * for the building of road.
   * Creation date: (17-11-01 17:47:43)
   * @return boolean
   */
  public boolean isRoads() {
    Verbose.message("Advance: roads " + roads + " returned");
    return roads;
  }
  /**
   * i havent got a clue.
   * Creation date: (17-11-01 17:47:26)
   * @return boolean
   */
  public boolean isTransform() {
    Verbose.message("Advance: transform " + transform + " returned");
    return transform;
  }
  /**
   * Insert the method's description here.
   * Creation date: (27-11-01 21:48:04)
   */
  void newMethod() {
  }
  /**
   * modifies the advance's age to the given age.
   * Creation date: (17-11-01 17:40:07)
   * @param newAge java.lang.String
   */
  public void setAge(java.lang.String newAge) {
    Verbose.message("Advance: age set to " + newAge);
    age = newAge;
  }
  /**
   * modifies the advance's branch to the given branch.
   * Creation date: (17-11-01 17:36:16)
   * @param newBranch java.lang.String
   */
  public void setBranch(int newBranch) {
    Verbose.message("Advance: branch set to " + newBranch);
    branch = newBranch;
  }
  /**
   * sets the capitalization attribute to the given value.
   * Creation date: (17-11-01 17:44:22)
   * @param newCapitalization boolean
   */
  public void setCapitalization(boolean newCapitalization) {
    Verbose.message("Advance: Capitalization set to " + newCapitalization);
    capitalization = newCapitalization;
  }
  /**
   * sets the advance's cost to the given value.
   * Creation date: (17-11-01 17:35:07)
   * @param newCost int
   */
  public void setCost(int newCost) {
    Verbose.message("Advance: cost set to " + newCost);
    cost = newCost;
  }
  /**
   * sets the deepocean attribute to the given value.
   * Creation date: (17-11-01 17:46:24)
   * @param newDeepOcean boolean
   */
  public void setDeepOcean(boolean newDeepOcean) {
    Verbose.message("Advance: deep ocean set to " + newDeepOcean);
    deepOcean = newDeepOcean;
  }
  /**
   * sets the glhidden attribute to the given value.
   * Creation date: (17-11-01 17:46:59)
   * @param newGlHidden boolean
   */
  public void setGlHidden(boolean newGlHidden) {
    Verbose.message("Advance: glHidden set to " + newGlHidden);
    glHidden = newGlHidden;
  }
  /**
   * sets a name for the advances icon.
   * Creation date: (17-11-01 17:35:30)
   * @param newIcon java.lang.String
   */
  public void setIcon(java.lang.String newIcon) {
    Verbose.message("Advance: icon set to " + newIcon);
    icon = newIcon;
  }
  /**
   * sets the infrastructure attribute to the given value.
   * Creation date: (17-11-01 17:45:04)
   * @param newInfrastructure boolean
   */
  public void setInfrastructure(boolean newInfrastructure) {
    Verbose.message("Advance: infrastructure set to " + newInfrastructure);
    infrastructure = newInfrastructure;
  }
  /**
   * sets the advance advice to the given name.
   * Creation date: (17-11-01 17:40:34)
   * @param newKeyAdvanceAdvice java.lang.String
   */
  public void setKeyAdvanceAdvice(java.lang.String newKeyAdvanceAdvice) {
    Verbose.message("Advance: key advance advice set to " + newKeyAdvanceAdvice);
    keyAdvanceAdvice = newKeyAdvanceAdvice;
  }
  /**
   * sets the maglev attribute to the given value.
   * Creation date: (17-11-01 17:44:39)
   * @param newMaglev boolean
   */
  public void setMaglev(boolean newMaglev) {
    Verbose.message("Advance: maglev set to " + newMaglev);
    maglev = newMaglev;
  }
  /**
   * sets the advance's name to the given name.
   * Creation date: (17-11-01 17:32:31)
   * @param newName java.lang.String
   */
  public void setName(java.lang.String newName) {
    Verbose.message("Advance: name set to " + newName);
    name = newName;
  }
  /**
   * sets the plantNuke attribute to the given value.
   * Creation date: (17-11-01 17:45:48)
   * @param newPlantNuke boolean
   */
  public void setPlantNuke(boolean newPlantNuke) {
    Verbose.message("Advance: plant nuke set to " + newPlantNuke);
    plantNuke = newPlantNuke;
  }
  /**
   * sets the pollutionProductionModifier attribute to the given value.
   * Creation date: (17-11-01 17:43:57)
   * @param newPollutionProductionModifier int
   */
  public void setPollutionProductionModifier(int newPollutionProductionModifier) {
    Verbose.message(
      "Advance: pollution production modifier set to "
        + newPollutionProductionModifier);
    pollutionProductionModifier = newPollutionProductionModifier;
  }
  /**
   * sets the pollutionSizeModifier attribute to the given value.
   * Creation date: (17-11-01 17:43:34)
   * @param newPollutionSizeModifier int
   */
  public void setPollutionSizeModifier(int newPollutionSizeModifier) {
    Verbose.message(
      "Advance: pollution size modifier set to " + newPollutionSizeModifier);
    pollutionSizeModifier = newPollutionSizeModifier;
  }
  /**
   * sets the railroads attribute to the given value.
   * Creation date: (17-11-01 17:46:39)
   * @param newRailroads boolean
   */
  public void setRailroads(boolean newRailroads) {
    Verbose.message("Advance: railroads set to " + newRailroads);
    railroads = newRailroads;
  }
  /**
   * sets the roads attribute to the given value.
   * Creation date: (17-11-01 17:47:43)
   * @param newRoads boolean
   */
  public void setRoads(boolean newRoads) {
    Verbose.message("Advance: roads set to " + newRoads);
    roads = newRoads;
  }
  /**
   * sets the transform attribute to the given value.
   * Creation date: (17-11-01 17:47:26)
   * @param newTransform boolean
   */
  public void setTransform(boolean newTransform) {
    Verbose.message("Advance: transform set to " + newTransform);
    transform = newTransform;
  }
  /**
   * sets the name of the feat to be triggered
   * Creation date: (17-11-01 17:42:58)
   * @param newTriggerFeat java.lang.String
   */
  public void setTriggerFeat(java.lang.String newTriggerFeat) {
    Verbose.message("Advance: feat trigger set to " + newTriggerFeat);
    triggerFeat = newTriggerFeat;
  }
}