@ECHO OFF
REM CIVILIZATIONII SCENARIO RULES-SWAPPING BATCH FILE
REM Created by Jorrit Vermeiren, jorrit_v@hotmail.com
REM
REM Any use of this file is encouraged as long as
REM I'm credited.

IF NOT EXIST %0\..\Komnenai.scn GOTO error1
SET scenpath=%0\..

:paramcheck
IF "%1"=="/?" GOTO help
IF "%1"=="" GOTO change4to1
GOTO start


:start
IF NOT EXIST %scenpath%\rules\rules1.txt GOTO change1to2
IF NOT EXIST %scenpath%\rules\rules2.txt GOTO change2to3
IF NOT EXIST %scenpath%\rules\rules3.txt GOTO change3to4
IF NOT EXIST %scenpath%\rules\rules4.txt GOTO change4to1


:change1to2
IF NOT EXIST %scenpath%\rules.txt GOTO error3
IF NOT EXIST %scenpath%\rules\rules2.txt GOTO error3
MOVE %scenpath%\rules.txt %scenpath%\rules\rules1.txt
MOVE %scenpath%\rules\rules2.txt %scenpath%\rules.txt
GOTO success


:change2to3
IF NOT EXIST %scenpath%\rules.txt GOTO error3
IF NOT EXIST %scenpath%\rules\rules3.txt GOTO error3
MOVE %scenpath%\rules.txt %scenpath%\rules\rules2.txt
MOVE %scenpath%\rules\rules3.txt %scenpath%\rules.txt
GOTO success


:change3to4
IF NOT EXIST %scenpath%\rules.txt GOTO error3
IF NOT EXIST %scenpath%\rules\rules4.txt GOTO error3
MOVE %scenpath%\rules.txt %scenpath%\rules\rules3.txt
MOVE %scenpath%\rules\rules4.txt %scenpath%\rules.txt
GOTO success


:change4to1
IF NOT EXIST %scenpath%\rules.txt GOTO error3
IF NOT EXIST %scenpath%\rules\rules1.txt GOTO back
IF NOT EXIST %scenpath%\rules\rules4.txt MOVE %scenpath%\rules.txt %scenpath%\rules\rules4.txt
IF NOT EXIST %scenpath%\rules\rules3.txt MOVE %scenpath%\rules.txt %scenpath%\rules\rules3.txt
IF NOT EXIST %scenpath%\rules\rules2.txt MOVE %scenpath%\rules.txt %scenpath%\rules\rules2.txt
MOVE %scenpath%\rules\rules1.txt %scenpath%\rules.txt
GOTO back


:success
CLS
ECHO The rule files have been swapped successfully!
ECHO Reload your savegame to continue the scenario.
ECHO.
GOTO end


:back
CLS
ECHO The rules files have been put back to their original locations.
ECHO.
GOTO end


:error1
ECHO The scenario file could not be found. Please make sure this batch
ECHO file is located in the same directory as the scenario.
ECHO.
GOTO end


:error3
ECHO One of the required rules files could not be found! Please make
ECHO sure all files are in place.
ECHO.
GOTO end


:help
ECHO This file updates the rules for a savegame of a Civilization II Scenario
ECHO that uses multiple rules files.
ECHO Run this batch file without any arguments to reset the rules files.
ECHO.
ECHO RULESWAP [drive1:][path1]savegame
ECHO.
ECHO [drive1:][path1]savegame
ECHO			The name of your current savegame. The drive and path
ECHO			specifications are only required when this batch file isn't
ECHO			in the same directory of the savegame.
ECHO.
ECHO EXAMPLES:
ECHO evntswap caesar.sav
ECHO evntswap F:\Civ2\hannibal.sav
ECHO.
ECHO HINT: simply drag your savegame over this batch file in Windows Explorer to
ECHO avoid having to go to DOS.
GOTO end


:end
SET scenpath=
