#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=PitBoss_121.ico
#AutoIt3Wrapper_outfile=PitbossLauncher.exe
#AutoIt3Wrapper_Res_Comment=Pitboss Launcher
#AutoIt3Wrapper_Res_Description=Pitboss Launcher
#AutoIt3Wrapper_Res_Fileversion=2.5.1.0
#AutoIt3Wrapper_Res_LegalCopyright=Copyright 2007 Greg Laabs, Modified by Moby2kBug
#AutoIt3Wrapper_Res_Language=1033
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****

; AutoIt Version: 3.0
; Language:       English
; Platform:       WinXP
; Author:         Greg Laabs

#include <Date.au3>
#include <Array.au3>
#include <GuiConstants.au3>
#Include <Misc.au3>

#region AutoIt Options
Opt("MustDeclareVars",1)
Opt("MouseCoordMode",2) ;Relative coords to the client area of the active window
Opt("TrayAutoPause",0) ;Do not pause when trayicon is clicked
Opt("TrayMenuMode",1) ;No default menu on tray icon
Opt("TrayOnEventMode",1) ;Use OnEvent mode for tray menus
#endregion AutoIt Options

#region Constants
Const $INIFILENAME = "PitbossLauncher.ini"
Const $LOGFILENAME = "PitbossLauncher.log"
Const $Version = "2.5.1.0"

Const $COORD_MULTIPLAYER = 0
Const $COORD_DIRECTIP = 1
Const $COORD_PLAYERNAME = 2
Const $COORD_SERVERADDRESS = 3
Const $COORD_SERVERPASSWORD = 4
Const $COORD_CONNECTBUTTON = 5
Const $COORD_LEADER1 = 6
Const $COORD_LEADER2 = 7
Const $COORD_LEADER3 = 8
Const $COORD_LEADER4 = 9
Const $COORD_LEADER5 = 10
Const $COORD_LEADER6 = 11
Const $COORD_LEADER7 = 12
Const $COORD_LEADER8 = 13
Const $COORD_LEADER9 = 14
Const $COORD_LEADER10 = 15
Const $COORD_LEADER11 = 16
Const $COORD_LEADER12 = 17
Const $COORD_LEADER13 = 18
Const $COORD_LEADER14 = 19
Const $COORD_LEADER15 = 20
Const $COORD_LEADERDOWNBUTTON = 21
Const $COORD_OKBUTTON = 22
Const $COORD_PLAYERPASSWORD = 23
Const $COORD_PASSWORDOKBUTTON = 24
Const $COORD_MODIFIEDASSETSBUTTON = 25

Const $RESOLUTION_1024768 = 0
Const $RESOLUTION_1280960 = 1
Const $RESOLUTION_12801024 = 2
Const $RESOLUTION_1440900 = 3
Const $RESOLUTION_16801050 = 4
#endregion Constants

#region IniVars
Global $iniDefaultProfile = "default"
Global $iniPathToExe = "C:\Program Files\Firaxis Games\Sid Meier's Civilization 4\Civilization4.exe"
Global $iniWarlordsExe = ""
Global $iniBTSExe = ""
Global $iniLogLevel = 1
Global $iniAutoLogin = 0
Global $iniCivWindowTitle = "Civilization IV"
Global $iniWarlordsWindowTitle = "Civ IV: Warlords"
Global $iniBTSWindowTitle = "Civ IV: Beyond The Sword"
Global $iniNOCDWindowTitle = "Cannot locate the CD-ROM"
Global $iniSecondsToLoad = 10
Global $iniSecondsToConnect = 8

Global $iniServerAddress
Global $iniRememberGamePassword
Global $iniGamePassword
Global $iniRememberPlayerPassword
Global $iniPlayerPassword
Global $iniPlayerNum
Global $iniPlayerName
Global $iniMod
Global $iniExeOverride
#endregion

#region Globals
Global $LogFile
Global $MultipleProfiles
Global $ActiveProfile
#endregion

#region CommandLineVariables
Global $CLProfile = ""
Global $CLAutoLaunch = 0
#endregion

#region GUI Globals
Global $MainWindow
Global $ComboLeaderNumber, $InputGamePassword, $CheckboxRememberGamePassword, $InputPlayerPassword, $CheckboxRememberPlayerPassword
Global $InputServerAddress, $ButtonGo, $LabelServerAddress, $LabelGamePassword, $LabelPlayerPassword, $LabelLeaderNumber, $LabelDiscloser
Global $InputPlayerName, $LabelPlayerName, $CheckboxAutoLogin, $ButtonSettings, $LabelMod, $ComboMod
Global $ButtonShortcut

Global $ListProfiles, $ButtonProfilesNew, $ButtonProfilesCopy, $ButtonProfilesRemove, $ButtonProfilesRename
GLobal $GroupProfiles

Global $TrayMenuItemExit
#endregion

#region String Globals
Global $LOC_MainWindowTitle = "Pitboss Launcher "&$Version
Global $LOC_ServerAddress = "Server Address:"
Global $LOC_PlayerName = "Player Name:"
Global $LOC_GamePassword = "Game Password:"
Global $LOC_Remember = "Remember?"
Global $LOC_GamePasswordTooltip = "Check this box to have Pitboss Launcher remember your Game Password"
Global $LOC_PlayerPassword = "Player Password:"
Global $LOC_PlayerPasswordTooltip = "Check this box to have Pitboss Launcher remember your Player Password"
Global $LOC_LeaderNumber = "Leader Number:"
Global $LOC_LeaderNumberTooltip = "When connecting to the Pitboss server, what position is your leader in the list?"
Global $LOC_GoOnLaunch = "Go on Launch"
Global $LOC_GoOnLaunchTooltip = "If this box is checked, Civ 4 will immediately launch when PitbossLauncher is run, and this GUI will not appear"
Global $LOC_ShortcutButton = "Create Shortcut"
Global $LOC_ShortcutButtonTooltip = "Create a shortcut that will automatically launch this profile"
Global $LOC_Go = "Go!"
Global $LOC_Settings = "Settings"
Global $LOC_ProfilesTitle = "Profiles"
Global $LOC_New = "New"
Global $LOC_Rename = "Rename"
Global $LOC_Copy = "Copy"
Global $LOC_Remove = "Remove"
Global $LOC_EnterNameTitle = "Enter a name"
Global $LOC_EnterNameBody = "Please enter a name"

Global $LOC_TrayTipTitle = "Pitboss Launcher"
Global $LOC_TrayTipLaunch = "Launching Civilization 4. Please be patient and do not move the mouse until the process is finished. If there are any problems, press ESC to abort the script."
Global $LOC_TrayTipNOCD = "Detected 'Insert CD' window. Aborting."

Global $LOC_TrayMenuExit = "Exit"
#endregion

#region GUIFunctions ;FUNCTIONS
;***************
; GUI FUNCTIONS
;***************
Func PitbossLauncher()
	Init()

	Dim $msg, $profilename
	
	If ($iniAutoLogin = 1 OR $CLAutoLaunch = 1) AND _IsPressed(10) == 0 Then
		; Auto Launch is turned on, so start the process. The GUI will never be shown.
		Go()
	EndIf
	
	PitbossLog( "Generating GUI...", 3)
	$MainWindow = GuiCreate($LOC_MainWindowTitle, 520, 250,-1, -1)

	$LabelServerAddress = GuiCtrlCreateLabel($LOC_ServerAddress, 10, 12, 90, 20)
	$InputServerAddress = GuiCtrlCreateInput($iniServerAddress, 100, 10, 190, 20)
	$LabelPlayerName = GuiCtrlCreateLabel($LOC_PlayerName, 10, 42, 90, 20)
	$InputPlayerName = GuiCtrlCreateInput($iniPlayerName, 100, 40, 190, 20)
	$LabelGamePassword = GuiCtrlCreateLabel($LOC_GamePassword, 10, 72, 90, 20)
	$InputGamePassword = GuiCtrlCreateInput($iniGamePassword, 100, 70, 100, 20, $ES_PASSWORD)
	$CheckboxRememberGamePassword = GuiCtrlCreateCheckbox($LOC_Remember, 210, 70, 80, 20)
	GUICtrlSetTip ( $CheckboxRememberGamePassword, $LOC_GamePasswordTooltip )
	If $iniRememberGamePassword = 1 Then GUICtrlSetState($CheckboxRememberGamePassword,$GUI_CHECKED)
	$LabelPlayerPassword = GuiCtrlCreateLabel($LOC_PlayerPassword, 10, 102, 90, 20)
	$InputPlayerPassword = GuiCtrlCreateInput($iniPlayerPassword, 100, 100, 100, 20, $ES_PASSWORD)
	$CheckboxRememberPlayerPassword = GuiCtrlCreateCheckbox($LOC_Remember, 210, 100, 80, 20)
	GUICtrlSetTip ( $CheckboxRememberPlayerPassword, $LOC_PlayerPasswordTooltip )
	If $iniRememberPlayerPassword = 1 Then GUICtrlSetState($CheckboxRememberPlayerPassword,$GUI_CHECKED)
	$LabelLeaderNumber = GuiCtrlCreateLabel($LOC_LeaderNumber, 10, 132, 90, 20)
	$ComboLeaderNumber = GuiCtrlCreateCombo("1", 100, 130, 40, 20)
	GUICtrlSetTip ( $ComboLeaderNumber, $LOC_LeaderNumberTooltip )
	GUICtrlSetData($ComboLeaderNumber,"2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32",$iniPlayerNum)
	$LabelMod = GuiCtrlCreateLabel("Mod:", 10, 162, 50, 20)
	$ComboMod = GuiCtrlCreateCombo("None", 100, 160, 190, 20)
	DetectMods()
	$CheckboxAutoLogin = GuiCtrlCreateCheckbox($LOC_GoOnLaunch, 10, 190, 90, 20)
	GUICtrlSetTip ( $CheckboxAutoLogin, $LOC_GoOnLaunchTooltip )
	If $iniAutoLogin = 1 Then GUICtrlSetState($CheckboxAutoLogin,$GUI_CHECKED)
	$ButtonGo = GuiCtrlCreateButton($LOC_Go, 10, 220, 80, 22)
	$ButtonSettings = GuiCtrlCreateButton($LOC_Settings, 200, 220, 90, 22, $WS_DISABLED)
	$LabelDiscloser = GuiCtrlCreateLabel(" 2007 Greg Laabs, Modified by Moby2kBug", 300, 225, 215, 20)
	
	;PROFILES
	$GroupProfiles = GUICtrlCreateGroup ( $LOC_ProfilesTitle, 300, 5, 215, 205)
	$ListProfiles = GuiCtrlCreateList("", 310, 25, 100, 195)
	$ButtonProfilesNew = GuiCtrlCreateButton($LOC_New, 415, 25, 90, 22)
	$ButtonProfilesRename = GuiCtrlCreateButton($LOC_Rename, 415, 55, 90, 22)
	$ButtonProfilesCopy = GuiCtrlCreateButton($LOC_Copy, 415, 85, 90, 22)
	$ButtonProfilesRemove = GuiCtrlCreateButton($LOC_Remove, 415, 115, 90, 22)
	
	$ButtonShortcut = GuiCtrlCreateButton($LOC_ShortcutButton, 415, 175, 90, 22)
	GUICtrlSetTip ( $ButtonShortcut, $LOC_ShortcutButtonTooltip )
	
	UpdateProfilesList()
	
	PitbossLog( "GUI Event: Finished creating controls", 3)

	GuiSetState()
	While 1
		$msg = GuiGetMsg(1)
		Select
			Case $msg[0] = $GUI_EVENT_CLOSE AND $msg[1] = $MainWindow
				UpdateVarsFromGUI()
				PitbossLog( "GUI Event: Closed: "& $msg[0], 2)
				ExitLoop
			Case $msg[0] = $InputServerAddress OR $msg[0] = $InputPlayerName OR $msg[0] = $ComboLeaderNumber OR $msg[0] = $CheckboxAutoLogin Or $msg[0] = $ComboMod
				ContinueCase
			Case $msg[0] = $InputGamePassword OR $msg[0] = $CheckboxRememberGamePassword OR $msg[0] = $InputPlayerPassword OR $msg[0] = $CheckboxRememberPlayerPassword
				PitbossLog( "GUI Event: Input changed: " & $msg[0] ,3)
				UpdateVarsFromGUI()
			Case $msg[0] = $ButtonGo
				PitbossLog( "GUI Event: Go Button Pressed: "& $msg[0], 2)
				UpdateVarsFromGUI()
				GUIDelete($MainWindow)
				Go()
				ExitLoop
			Case $msg[0] = $ButtonShortcut
				Dim $ShortcutFullPath = @DesktopDir&"\Pitboss Launcher - "&$ActiveProfile&".lnk"
				FileCreateShortcut(@ScriptFullPath,$ShortcutFullPath,@DesktopDir,""""&$ActiveProfile&"""","Connect to Pitboss game: "&$ActiveProfile)
				PitbossLog( "GUI Event: Create Shortcut Button Pressed: "& $msg[0], 2)
				MsgBox(8192+64,"Shortcut Created","A shortcut has been created on your desktop that will directly launch the """&$ActiveProfile&""" profile.")
			Case Else
		EndSelect
		
		Select ; **** PROFILE EVENTS
			Case $msg[0] = $ButtonProfilesNew
				PitbossLog( "GUI Event: New Profile Clicked: " & $msg[0] ,2)
				$profilename = GetNewProfileName()
				If $profilename <> -1 Then
					NewProfile($profilename)
					UpdateProfilesList()
				EndIf
			Case $msg[0] = $ButtonProfilesRename
				PitbossLog( "GUI Event: Rename Profile Clicked: " & $msg[0] ,2)
				$profilename = GetNewProfileName()
				If $profilename <> -1 Then
					RenameProfile(GUICtrlRead($ListProfiles),$profilename)
					UpdateProfilesList()
				EndIf
			Case $msg[0] = $ButtonProfilesCopy
				PitbossLog( "GUI Event: Copy Profile Clicked: " & $msg[0] ,2)
				$profilename = GetNewProfileName()
				If $profilename <> -1 Then
					DuplicateProfile(GUICtrlRead($ListProfiles),$profilename)
					UpdateProfilesList()
				EndIf
			Case $msg[0] = $ButtonProfilesRemove
				PitbossLog( "GUI Event: Delete Profile Clicked: " & $msg[0] ,2)
				DeleteProfile(GUICtrlRead($ListProfiles))
				UpdateProfilesList()
			Case $msg[0] = $ListProfiles
				If GUICtrlRead($ListProfiles) Then
					PitbossLog( "GUI Event: Profile Changed: " & $msg[0] ,2)
					ActivateProfile(GUICtrlRead($ListProfiles))
					UpdateGUIFromVars()
				Else
					;Souldn't ever happen
				EndIf
			Case Else
		EndSelect
	WEnd

	ExitScript("GUI Closed")
EndFunc

#cs
Func ProfilesGUI()
	PitbossLog("ProfilesGUI()",3)
	$ProfilesWindow = GuiCreate($LOC_ProfilesTitle, 220, 210,-1, -1 , BITOR($DS_MODALFRAME,$WS_CAPTION, $WS_POPUP),-1,$MainWindow)

	$ListProfiles = GuiCtrlCreateList("", 10, 10, 100, 190)
	$ButtonProfilesOK = GuiCtrlCreateButton($LOC_OK, 120, 10, 90, 22)
	$ButtonProfilesNew = GuiCtrlCreateButton($LOC_New, 120, 60, 90, 22)
	$ButtonProfilesRename = GuiCtrlCreateButton($LOC_Rename, 120, 90, 90, 22)
	$ButtonProfilesCopy = GuiCtrlCreateButton($LOC_Copy, 120, 120, 90, 22)
	$ButtonProfilesRemove = GuiCtrlCreateButton($LOC_Remove, 120, 150, 90, 22)
	;$CheckboxProfilesDefault = GuiCtrlCreateCheckbox("Default", 120, 180, 90, 22)
	
	UpdateProfilesList()

	GuiSetState()
EndFunc
#ce

Func GetNewProfileName()
	Dim $name
	$name = InputBox($LOC_EnterNameTitle,$LOC_EnterNameBody,""," M",190,115)
	if @error Then
		Return -1
	Else
		Return $name
	EndIf
EndFunc

Func UpdateProfilesList()
	PitbossLog("UpdateProfilesList()",3)
	
	Dim $SectionNames, $numProfiles, $BackupProfile
	
	$numProfiles = 0
	
	GUICtrlSetData($ListProfiles,"")

	$BackupProfile = ""
	$SectionNames = IniReadSectionNames ( @ScriptDir & "\" & $INIFILENAME )
	If @error OR $SectionNames[0] = 0 Then
		PitbossLog("ERROR: UNABLE TO GET PROFILES LIST FOR GUI",1)
	Else
		For $i = 1 To $SectionNames[0]
			If $SectionNames[$i] <> "global" Then
				If $BackupProfile = "" Then $BackupProfile = $SectionNames[$i]
				
				If $SectionNames[$i] = $ActiveProfile Then
					GUICtrlSetData($ListProfiles,$SectionNames[$i]&"|",$SectionNames[$i])
				Else
					GUICtrlSetData($ListProfiles,$SectionNames[$i]&"|")
				EndIf
				$numProfiles = $numProfiles + 1
			EndIf
		Next
	EndIf
	
	If $numProfiles > 1 Then
		GUICtrlSetState($ButtonProfilesRemove,$GUI_ENABLE)
	Else
		GUICtrlSetState($ButtonProfilesRemove,$GUI_DISABLE)
	EndIf
	
	If GUICtrlRead($ListProfiles) Then
		ActivateProfile(GUICtrlRead($ListProfiles))
	Else
		ActivateProfile($BackupProfile)
	EndIf
	
	UpdateGUIFromVars()
EndFunc

Func DetectMods()
	Local $Mods = GetModList()
	Local $i
	
	GUICtrlSetData($ComboMod,"")
	For $i=0 To UBound($Mods)-1
		If $iniMod = $Mods[$i] Then
			GUICtrlSetData($ComboMod,$Mods[$i]&"|",$Mods[$i])
		Else
			GUICtrlSetData($ComboMod,$Mods[$i]&"|")
		EndIf
	Next
EndFunc
#endregion

#region FlowFunctions
;**********************
; FLOW FUNCTIONS
;**********************
Func Go()
	Dim $test, $size, $pos, $MyResolution, $i, $runcmd, $warlords, $exe, $windowtitle, $mod, $bMod
	
	HotKeySet ( "{ESC}" , "Abort" )
	
	If StringLeft($iniMod,11) = "(Warlords) " Then
		$mod = StringTrimLeft($iniMod,11)
		$exe = $iniWarlordsExe
		$windowtitle = $iniWarlordsWindowTitle
	ElseIf StringLeft($iniMod,6) = "(BtS) " Then
		$mod = StringTrimLeft($iniMod,6)
		$exe = $iniBTSExe
		$windowtitle = $iniBTSWindowTitle
	Else
		$mod = $iniMod
		$exe = $iniPathToExe
		
		$windowtitle = $iniCivWindowTitle
	EndIf
	
	If Not $iniExeOverride = "" AND FileExists($iniExeOverride) Then
		$exe = $iniExeOverride
	EndIf
	
	if $mod = "None" or $mod = "" or $mod = "0" Then
		$bMod = False
		$runcmd = $exe
	Else
		$bMod = True
		$runcmd = $exe & " mod="""&$mod&""""
	EndIf
	
	;(Moby) Move mousecursor on top left edge, just to be sure
	MouseMove(10, 10, 0)
	
	Run($runcmd)
	
	TraySetState ( 1 )
	TraySetToolTip ( $LOC_MainWindowTitle )
	$TrayMenuItemExit = TrayCreateItem ( $LOC_TrayMenuExit )
	TrayItemSetOnEvent ( $TrayMenuItemExit, "Abort" )
	TrayTip($LOC_TrayTipTitle,$LOC_TrayTipLaunch,10)

	While 1
		Sleep(250)
		if WinActive($windowtitle) Then
			$size = WinGetClientSize($windowtitle)
			If $size[0] = 480 AND $size[1] = 280 Then
				;Found the loading window
				;PitbossLog("Loading window found!",3)
			ElseIf $size[0] = 276 AND $size[1] = 94 Then
				;Found the "Fullscreen?" window
				;PitbossLog("'Fullscreen?' window found!",3)
			Else
				PitbossLog("Found a Civ4 window with size: "&$size[0]&"x"&$size[1],1)
				ExitLoop
			EndIf
		EndIf
		
		if WinActive($iniNOCDWindowTitle) Then
			TrayTip($LOC_TrayTipTitle,$LOC_TrayTipNOCD,10)
			Sleep(7000)
			ExitScript("Must insert CD")
		EndIf
	WEnd
	
	PitbossLog("Waiting "&$iniSecondsToLoad&" seconds for game to fully load.",3)
	Sleep($iniSecondsToLoad*1000)
	
	If $bMod Then
		PitbossLog("No need to skip movies because this is a mod and has no movies",3)
	Else
		PitbossLog("Clicking 5 times to skip all the movies.",3)
		For $i=1 To 5
			MouseClick("left",$size[0]/2,$size[1]/4)
			Sleep(500)
		Next
	EndIf
	
	PitbossLog("Clicking on Multiplayer",3)
	Send("{DOWN}{ENTER}")
	Sleep(100)
	
	PitbossLog("Clicking on Direct IP Game",3)
	Send("{DOWN 2}{ENTER}")
	Sleep(500)
	
	;(Moby) PitbossLog("Clicking on Player Name",3) Not necessary since by default the cursor is right on the player name
	PitbossLog("Entering Player Name",3)
	Send("{HOME}+{END}"&$iniPlayerName)
	
	PitbossLog("Clicking on Server Address",3)
	send("{TAB 5}")
	PitbossLog("Entering Server Address",3)
	Send("{HOME}+{END}"&$iniServerAddress)
	
	PitbossLog("Clicking on Game Password",3)
	send("{TAB}")
	PitbossLog("Entering Game Password",3)
	Send("{HOME}+{END}"&$iniGamePassword)
	
	PitbossLog("Clicking on Connect",3)
	send("{TAB}{ENTER}")
	PitbossLog("Waiting "&$iniSecondsToConnect&" seconds for the connection process to finish.",3)
	Sleep($iniSecondsToConnect*1000)
	
	PitbossLog("Clicking on Leader "&$iniPlayerNum,3)
	Send("{TAB 2}")
	For $i = 2 To $iniPlayerNum
		Send("{DOWN}")
	Next
	;(Moby) If the first civic was selected, then just press once enter
	If $iniPlayerNum <> 1 Then Send("{ENTER}")
	Send("{ENTER}")
	Sleep(250)
	
	PitbossLog("Entering Player Password",3)
	;(Moby) in plain old Civ4, U have to make 2 additional TABs before entering the password
	If $exe = $iniPathToExe Then Send("{TAB 2}")
	Send("{HOME}+{END}"&$iniPlayerPassword)
	Send("{TAB}{ENTER}")
	
	ExitScript("Finished Successfully")
EndFunc

Func Abort()
	ExitScript("User Aborted")
EndFunc

Func ExitScript($reason)
	SaveIniFile()
	PitbossLog( "Script stopped at " & _Now() & " | Reason: " & $reason, 0)
	PitbossLog( "",0 )
	Exit
EndFunc
#endregion

#region InitFunctions
;**********************
; INIT FUNCTIONS
;**********************
Func Init()
	InitLog()
	CheckCLVars()
	LoadINI()
	CheckExe()
	PitbossLog( "Script started at " & _Now() ,0)
EndFunc

Func CheckCLVars()
	If $CmdLine[0] > 0 Then
		$CLProfile = $CmdLine[1]
		$CLAutoLaunch = 1
	EndIf
EndFunc

Func CheckExe()
	PitbossLog("CheckExe()",3)
	If NOT FileExists ( $iniPathToExe ) Then
		$iniPathToExe = FileOpenDialog("Please Locate Civilization4.exe","C:\","Executable Files (*.exe)",1,"Civilization4.exe")
		If @error OR $iniPathToExe = 1 Then
			ExitScript("User did not locate executable")
		EndIf
		SaveIniFile()
	EndIf
EndFunc

Func InitLog()
	$LogFile = FileOpen(@ScriptDir & "\" & $LOGFILENAME, 1)
	PitbossLog("InitLog()",3)
EndFunc

Func LoadINI()
	PitbossLog("LoadINI()",3)
	Dim $SectionNames, $Settings, $i, $ValidProfile, $BackupProfile
	
	; First load global ini settings
	$Settings = IniReadSection(@ScriptDir & "\" & $INIFILENAME,"global")
	If NOT @error Then
		For $i = 1 To $Settings[0][0]
			SetIniVariable($Settings[$i][0], $Settings[$i][1])
		Next
	EndIf
	
	; Load the section names to see if there are multiple profiles
	$SectionNames = IniReadSectionNames ( @ScriptDir & "\" & $INIFILENAME )
	If @error OR UBound($SectionNames)-1 = 0 OR UBound($SectionNames)-1 = 1 Then
		; There are no profiles - create a default one
		$ActiveProfile = "default"
		$MultipleProfiles = 0
		SetIniDefaults()
		SaveIniFile()
	ElseIf UBound($SectionNames)-1 >= 3 Then
		; There are multiple profiles. We'll load the one marked as default in the global ini settings.
		$ActiveProfile = $iniDefaultProfile
		$MultipleProfiles = 1
	Else
		; There is only one profile. It should be set as the default profile.
		$ActiveProfile = $iniDefaultProfile
		$MultipleProfiles = 0
	EndIf
	
	If Not $CLProfile = "" Then
		$ActiveProfile = $CLProfile
	EndIf
	
	$ValidProfile = 0
	$BackupProfile = ""
	$SectionNames = IniReadSectionNames ( @ScriptDir & "\" & $INIFILENAME )
	For $i = 1 To $SectionNames[0]
		If $SectionNames[$i] <> "global" AND $SectionNames[$i] = $ActiveProfile Then
			$ValidProfile = 1
		EndIf
		If $SectionNames[$i] <> "global" AND $BackupProfile = "" Then
			$BackupProfile = $SectionNames[$i]
		EndIf
	Next
	If $ValidProfile = 0 Then
		$ActiveProfile = $BackupProfile
		$CLAutoLaunch = 0
	EndIf
	
	ActivateProfile($ActiveProfile)
	
EndFunc
#endregion InitFunctions

#region UtilityFunctions
;**********************
; UTILITY FUNCTIONS
;**********************
Func PitbossLog($Line, $level = 1)
	; Log Levels:
	; 0 - No Logging
	; 1 - Errors only
	; 2 - Information and Errors
	; 3 - Full debug logging
	If $level <= $iniLogLevel Then
		FileWriteLine($LogFile, $Line )
	EndIf
EndFunc

Func GetModList()
	Local $i = 1
	Local $Mods[$i]
    Local $search
	Local $dir
	Local $modsdir
	$Mods[0] = "None"
	
	$dir = StringRegExp($iniPathToExe, "(.*)(\\[^\\]+)",1)
	If @error > 0 Then
		SetError(1)
		Return $Mods
	EndIf
	$dir = $dir[0]
	$modsdir = $dir & "\Mods"
	
	$search = FileFindFirstFile($modsdir & "\*.*")
    While 1
        Dim $file = FileFindNextFile($search)
        If @error Or StringLen($file) < 1 Then ExitLoop
        If StringInStr(FileGetAttrib($modsdir & "\" & $file), "D") And ($file <> "." Or $file <> "..") Then
			ReDim $Mods[$i+1]
			$Mods[$i] = $file
			$i = $i + 1
        EndIf
    WEnd
	
	If FileExists ( $dir & "\Warlords\Civ4Warlords.exe" ) Then
		ReDim $Mods[$i+1]
		$Mods[$i] = "(Warlords) None"
		$i = $i + 1
		
		If Not FileExists( $iniWarlordsExe ) Then
			$iniWarlordsExe = $dir & "\Warlords\Civ4Warlords.exe"
		EndIf
		
		$modsdir = $dir & "\Warlords\Mods"
		$search = FileFindFirstFile($modsdir & "\*.*")
		While 1
			Dim $file = FileFindNextFile($search)
			If @error Or StringLen($file) < 1 Then ExitLoop
			If StringInStr(FileGetAttrib($modsdir & "\" & $file), "D") And ($file <> "." Or $file <> "..") Then
				ReDim $Mods[$i+1]
				$Mods[$i] = "(Warlords) " & $file
				$i = $i + 1
			EndIf
		WEnd
	EndIf
	
	If FileExists ( $dir & "\Beyond the Sword\Civ4BeyondSword.exe" ) Then
		ReDim $Mods[$i+1]
		$Mods[$i] = "(BtS) None"
		$i = $i + 1
		
		If Not FileExists( $iniBTSExe ) Then
			$iniBTSExe = $dir & "\Beyond the Sword\Civ4BeyondSword.exe"
		EndIf
		
		$modsdir = $dir & "\Beyond the Sword\Mods"
		$search = FileFindFirstFile($modsdir & "\*.*")
		While 1
			Dim $file = FileFindNextFile($search)
			If @error Or StringLen($file) < 1 Then ExitLoop
			If StringInStr(FileGetAttrib($modsdir & "\" & $file), "D") And ($file <> "." Or $file <> "..") Then
				ReDim $Mods[$i+1]
				$Mods[$i] = "(BtS) " & $file
				$i = $i + 1
			EndIf
		WEnd
	EndIf
	
	Return $Mods
EndFunc

Func SetIniVariable($variable, $value)
	PitbossLog("SetIniVariable("&$variable&","&$value&")",3)
	$variable = "ini"&$variable
	If IsDeclared($variable) Then
		Assign($variable,$value,4)
	EndIf
EndFunc

Func UpdateVarsFromGUI()
	PitbossLog("UpdateVarsFromGUI()",3)
	$iniServerAddress = GUICtrlRead($InputServerAddress)
	$iniPlayerName = GUICtrlRead($InputPlayerName)
	$iniGamePassword = GUICtrlRead($InputGamePassword)
	$iniPlayerPassword = GUICtrlRead($InputPlayerPassword)
	$iniRememberGamePassword = BitAND(GUICtrlRead($CheckboxRememberGamePassword),$GUI_CHECKED)
	$iniRememberPlayerPassword = BitAND(GUICtrlRead($CheckboxRememberPlayerPassword),$GUI_CHECKED)
	$iniPlayerNum = GUICtrlRead($ComboLeaderNumber)
	$iniMod = GUICtrlRead($ComboMod)
	$iniAutoLogin = BitAND(GUICtrlRead($CheckboxAutoLogin),$GUI_CHECKED)
	
	SaveIniFile()
EndFunc

Func UpdateGUIFromVars()
	PitbossLog("UpdateGUIFromVars()",3)
	GUICtrlSetData($InputServerAddress,$iniServerAddress)
	GUICtrlSetData($InputPlayerName,$iniPlayerName)
	GUICtrlSetData($InputGamePassword,$iniGamePassword)
	If $iniRememberGamePassword = 1 Then
		GUICtrlSetState($CheckboxRememberGamePassword,$GUI_CHECKED)
	Else
		GUICtrlSetState($CheckboxRememberGamePassword,$GUI_UNCHECKED)
	EndIf
	GUICtrlSetData($InputPlayerPassword,$iniPlayerPassword)
	If $iniRememberPlayerPassword = 1 Then
		GUICtrlSetState($CheckboxRememberPlayerPassword,$GUI_CHECKED)
	Else
		GUICtrlSetState($CheckboxRememberPlayerPassword,$GUI_UNCHECKED)
	EndIf
	If $iniPlayerNum <> "" Then
		GUICtrlSetData($ComboLeaderNumber,$iniPlayerNum)
	Else
		GUICtrlSetData($ComboLeaderNumber,1)
		$iniPlayerNum = 1
	EndIf
	If $iniAutoLogin = 1 Then
		GUICtrlSetState($CheckboxAutoLogin,$GUI_CHECKED)
	Else 
		GUICtrlSetState($CheckboxAutoLogin,$GUI_UNCHECKED)
	EndIf
	if $iniMod = "" Then
		GUICtrlSetData($ComboMod,"None")
	Else
		GUICtrlSetData($ComboMod,$iniMod)
	EndIf
	
	GUICtrlSetData($ListProfiles,$ActiveProfile)
EndFunc

Func SetIniDefaults()
	PitbossLog("SetIniDefaults()",3)
	$iniServerAddress = "PitbossServer.com"
	$iniRememberGamePassword = 0
	$iniGamePassword = ""
	$iniRememberPlayerPassword = 0
	$iniPlayerPassword = ""
	$iniPlayerNum = 1
	$iniPlayerName = "Player Name"
	$iniMod = "None"
	$iniExeOverride = ""
EndFunc

Func ActivateProfile($profile)
	PitbossLog("ActivateProfile("&$profile&")",3)
	
	Dim $Settings
	
	$ActiveProfile = $profile
	$Settings = IniReadSection(@ScriptDir & "\" & $INIFILENAME,$profile)
	For $i = 1 To $Settings[0][0]
		SetIniVariable($Settings[$i][0], $Settings[$i][1])
	Next
EndFunc

Func NewProfile($profile)
	PitbossLog("NewProfile("&$profile&")",3)
	
	$ActiveProfile = $profile
	SetIniDefaults()
	SaveIniFile()
EndFunc

Func DuplicateProfile($oldprofile, $newprofile)
	PitbossLog("DuplicateProfile("&$oldprofile&","&$newprofile&")",3)
	
	ActivateProfile($oldprofile)
	$ActiveProfile = $newprofile
	SaveIniFile()
EndFunc

Func RenameProfile($oldname, $newname)
	PitbossLog("DuplicateProfile("&$oldname&","&$newname&")",3)
	DuplicateProfile($oldname, $newname)
	DeleteProfile($oldname)
EndFunc

Func DeleteProfile($profile)
	PitbossLog("DeleteProfile("&$profile&")",3)
	IniDelete(@ScriptDir & "\" & $INIFILENAME,$profile)
EndFunc

Func SaveIniFile()
	PitbossLog("SaveIniFile()",3)
	
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","DefaultProfile",$ActiveProfile)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","PathToExe",$iniPathToExe)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","WarlordsExe",$iniWarlordsExe)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","BTSExe",$iniBTSExe)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","LogLevel",$iniLogLevel)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","AutoLogin",$iniAutoLogin)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","CivWindowTitle",$iniCivWindowTitle)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","WarlordsWindowTitle",$iniWarlordsWindowTitle)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","BTSWindowTitle",$iniBTSWindowTitle)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","NOCDWindowTitle",$iniNOCDWindowTitle)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","SecondsToLoad",$iniSecondsToLoad)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,"global","SecondsToConnect",$iniSecondsToConnect)
	
	IniWrite(@ScriptDir & "\" & $INIFILENAME,$ActiveProfile,"ServerAddress",$iniServerAddress)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,$ActiveProfile,"RememberGamePassword",$iniRememberGamePassword)
	If $iniRememberGamePassword = 1 Then
		IniWrite(@ScriptDir & "\" & $INIFILENAME,$ActiveProfile,"GamePassword",$iniGamePassword)
	Else
		IniWrite(@ScriptDir & "\" & $INIFILENAME,$ActiveProfile,"GamePassword","")
	EndIf
	IniWrite(@ScriptDir & "\" & $INIFILENAME,$ActiveProfile,"RememberPlayerPassword",$iniRememberPlayerPassword)
	If $iniRememberPlayerPassword = 1 Then
		IniWrite(@ScriptDir & "\" & $INIFILENAME,$ActiveProfile,"PlayerPassword",$iniPlayerPassword)
	Else
		IniWrite(@ScriptDir & "\" & $INIFILENAME,$ActiveProfile,"PlayerPassword","")
	EndIf
	IniWrite(@ScriptDir & "\" & $INIFILENAME,$ActiveProfile,"PlayerNum",$iniPlayerNum)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,$ActiveProfile,"PlayerName",$iniPlayerName)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,$ActiveProfile,"Mod",$iniMod)
	IniWrite(@ScriptDir & "\" & $INIFILENAME,$ActiveProfile,"ExeOverride",$iniExeOverride)
EndFunc
#endregion UtilityFunctions

;***********************
; RUN THE MAIN FUNCTION
;***********************
PitbossLauncher()